/*
 * Decompiled with CFR 0.152.
 */
package com.wu.framework.inner.lazy.database.smart.database.adapter;

import com.wu.framework.inner.lazy.database.smart.database.SmartLazyOperation;
import java.sql.Connection;
import java.util.stream.Stream;
import javax.sql.DataSource;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.jdbc.datasource.DataSourceUtils;

@ConditionalOnBean(value={DataSource.class})
@ConditionalOnProperty(prefix="spring.lazy", name={"enable-reverse-engineering"}, havingValue="true")
public class ReverseEngineeringAdapter
implements InitializingBean {
    private final DataSource dataSource;
    private final SmartLazyOperation smartLazyOperation;

    public ReverseEngineeringAdapter(DataSource dataSource, SmartLazyOperation smartLazyOperation) {
        this.dataSource = dataSource;
        this.smartLazyOperation = smartLazyOperation;
    }

    public void afterPropertiesSet() throws Exception {
        Connection connection = DataSourceUtils.getConnection((DataSource)this.dataSource);
        String catalog = connection.getCatalog();
        try {
            ((Stream)this.smartLazyOperation.showTables(catalog).stream().parallel()).forEach(showTable -> this.smartLazyOperation.stuffedJava(showTable.getTableSchema(), showTable.getTableName()));
        }
        finally {
            connection.close();
        }
    }
}

