/*
 * Decompiled with CFR 0.152.
 */
package com.wu.framework.inner.lazy.database.smart.database.persistence;

import com.wu.framework.inner.layer.data.ProcessException;
import com.wu.framework.inner.layer.data.schema.SchemaMap;
import com.wu.framework.inner.layer.stereotype.MethodParamFunction;
import com.wu.framework.inner.layer.stereotype.MethodParamFunctionException;
import com.wu.framework.inner.layer.util.FileUtil;
import com.wu.framework.inner.lazy.database.domain.LazyDatabase;
import com.wu.framework.inner.lazy.database.domain.LazyTableInfo;
import com.wu.framework.inner.lazy.database.expand.database.persistence.LazyBaseOperation;
import com.wu.framework.inner.lazy.database.expand.database.persistence.config.ExportDataConfiguration;
import com.wu.framework.inner.lazy.database.expand.database.persistence.domain.Page;
import com.wu.framework.inner.lazy.database.expand.database.persistence.stream.lambda.LazyLambdaStream;
import com.wu.framework.inner.lazy.database.smart.database.Perfect;
import com.wu.framework.inner.lazy.persistence.analyze.DefaultMySQLDataProcessAnalyze;
import com.wu.framework.inner.lazy.persistence.analyze.MySQLDataProcessAnalyze;
import com.wu.framework.inner.lazy.persistence.map.EasyHashMap;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;
import org.springframework.util.ObjectUtils;

public class PerfectLazyOperation
implements Perfect {
    private static final Logger log = LoggerFactory.getLogger(PerfectLazyOperation.class);
    private final String tableTemp = "\n-- ----------------------------\n-- LazyTableInfo data for %s   \u7b2c\u3010 %s ~ %s \u3011\u6761\u6570\u636e  \n-- LazyTableInfo table_comment for %s \n-- ----------------------------";
    private final LazyBaseOperation lazyBaseOperation;
    private final ExportDataConfiguration exportDataConfiguration;
    private final DefaultMySQLDataProcessAnalyze mySQLDataProcessAnalyze = new DefaultMySQLDataProcessAnalyze();
    private final LazyLambdaStream lazyLambdaStream;

    public PerfectLazyOperation(LazyBaseOperation lazyBaseOperation, ExportDataConfiguration exportDataConfiguration, LazyLambdaStream lazyLambdaStream) {
        this.lazyBaseOperation = lazyBaseOperation;
        this.exportDataConfiguration = exportDataConfiguration;
        this.lazyLambdaStream = lazyLambdaStream;
    }

    public <T> void scroll(Page page, @NonNull Class<T> returnType, String sql, MethodParamFunction<Page<T>> methodParamFunction, Object ... params) throws ExecutionException, InterruptedException, MethodParamFunctionException, IOException, ProcessException, SQLException {
        if (ObjectUtils.isEmpty((Object)page)) {
            page = new Page(1, 1000);
        }
        ExecutorService executorService = null;
        do {
            if (page.getPages() > 10L) {
                if (null == executorService) {
                    executorService = Executors.newWorkStealingPool(10);
                }
                Page finalPage = page;
                executorService.submit(() -> {
                    try {
                        methodParamFunction.defaultMethod((Object)this.lazyBaseOperation.page(finalPage, returnType, sql, params));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }).get();
                continue;
            }
            Page pageResult = this.lazyBaseOperation.page(page, returnType, sql, params);
            log.info("\u5f53\u524d\u67e5\u8be2\u9875\u6570:" + page.getCurrent());
            methodParamFunction.defaultMethod((Object)pageResult);
        } while (page.getRecord() != null && page.getRecord().size() == page.getSize());
    }

    @Override
    public void saveSqlFile(String nameDatabase) throws IOException, ProcessException, MethodParamFunctionException, ExecutionException, InterruptedException, SQLException {
        String filePackage = System.getProperty("user.dir") + File.separator + "data_file" + File.separator + nameDatabase;
        if (nameDatabase == null) {
            nameDatabase = (String)this.lazyBaseOperation.executeSQLForBean("select database()", String.class, new Object[0]);
        }
        String sqlSelectTable = "select concat('%s.',table_name) tableName, engine, table_comment tableComment, create_time createTime from information_schema.tables where table_schema = '%s' ";
        List allTables = this.lazyBaseOperation.executeSQL(String.format(sqlSelectTable, nameDatabase, nameDatabase), EasyHashMap.class, new Object[0]);
        BufferedWriter file = FileUtil.createFile((String)System.getProperty("user.dir"), (String)String.format("\u6570\u636e\u5e93%s\u6570\u636e.sql", nameDatabase));
        file.newLine();
        file.write(String.format("use %s;", nameDatabase));
        file.newLine();
        for (EasyHashMap table : allTables) {
            EasyHashMap one;
            List ignoreFields;
            String countSQL = "select count(1) from %s ";
            String tableName = table.get((Object)"tableName").toString();
            SchemaMap createTableSchema = (SchemaMap)this.lazyBaseOperation.executeSQLForBean("show create table %s", SchemaMap.class, new Object[]{tableName});
            Object createTableSql = createTableSchema.get((Object)"Create Table");
            file.write("DROP TABLE IF EXISTS " + tableName.replace(nameDatabase + ".", "") + ";");
            file.newLine();
            file.write(String.valueOf(createTableSql));
            file.write(";");
            Object tableComment = table.get((Object)"TABLECOMMENT");
            Long count = (Long)this.lazyBaseOperation.executeSQLForBean(String.format(countSQL, tableName), Long.class, new Object[0]);
            if (count == 0L) continue;
            AtomicReference tableInfo = new AtomicReference();
            String selectSQL = "select * from %s ";
            if (count > 1000L) {
                Page page = new Page(1, 1000);
                this.scroll(page, EasyHashMap.class, selectSQL, scrollPage -> {
                    EasyHashMap one;
                    List ignoreFields;
                    if (ObjectUtils.isEmpty((Object)scrollPage.getRecord())) {
                        return scrollPage;
                    }
                    List record = (List)scrollPage.getRecord();
                    List<String> ignoreExportedFields = this.exportDataConfiguration.getIgnoreExportedFields();
                    if (!ObjectUtils.isEmpty(ignoreExportedFields) && !ObjectUtils.isEmpty(ignoreFields = (one = (EasyHashMap)record.get(0)).keySet().stream().filter(key -> ignoreExportedFields.contains(key)).collect(Collectors.toList()))) {
                        List ignoredData;
                        record = ignoredData = record.stream().map(easyHashMap -> {
                            for (Object ignoreField : ignoreFields) {
                                easyHashMap.remove(ignoreField);
                            }
                            return easyHashMap;
                        }).collect(Collectors.toList());
                    }
                    tableInfo.set(record.get(0));
                    int from = (scrollPage.getCurrent() - 1) * scrollPage.getSize();
                    int to = from + scrollPage.getRecord().size();
                    file.write(String.format("\n-- ----------------------------\n-- LazyTableInfo data for %s   \u7b2c\u3010 %s ~ %s \u3011\u6761\u6570\u636e  \n-- LazyTableInfo table_comment for %s \n-- ----------------------------", tableName, from, to, tableComment));
                    file.newLine();
                    ((EasyHashMap)tableInfo.get()).setUniqueLabel(tableName);
                    MySQLDataProcessAnalyze.MySQLProcessResult mySQLProcessResult = this.mySQLDataProcessAnalyze.upsertDataPack(record, ((EasyHashMap)tableInfo.get()).toEasyTableAnnotation(false, true));
                    String s = mySQLProcessResult.getSql();
                    s = s.replaceAll("'true'", "1").replaceAll("'false'", "0").replaceAll("'null'", "null");
                    file.write(s);
                    file.write(";");
                    file.newLine();
                    page.setCurrent(page.getCurrent() + 1);
                    return scrollPage;
                }, tableName);
                continue;
            }
            List tableDateList = this.lazyBaseOperation.executeSQL(String.format(selectSQL, tableName), EasyHashMap.class, new Object[0]);
            if (ObjectUtils.isEmpty((Object)tableDateList)) continue;
            List<String> ignoreExportedFields = this.exportDataConfiguration.getIgnoreExportedFields();
            if (!ObjectUtils.isEmpty(ignoreExportedFields) && !ObjectUtils.isEmpty(ignoreFields = (one = (EasyHashMap)tableDateList.get(0)).keySet().stream().filter(key -> ignoreExportedFields.contains(key)).collect(Collectors.toList()))) {
                List ignoredData;
                tableDateList = ignoredData = tableDateList.stream().map(easyHashMap -> {
                    for (Object ignoreField : ignoreFields) {
                        easyHashMap.remove(ignoreField);
                    }
                    return easyHashMap;
                }).collect(Collectors.toList());
            }
            int from = 0;
            int to = tableDateList.size();
            file.write(String.format("\n-- ----------------------------\n-- LazyTableInfo data for %s   \u7b2c\u3010 %s ~ %s \u3011\u6761\u6570\u636e  \n-- LazyTableInfo table_comment for %s \n-- ----------------------------", tableName, from, to, tableComment));
            file.newLine();
            tableInfo.set(tableDateList.get(0));
            ((EasyHashMap)tableInfo.get()).setUniqueLabel(tableName);
            MySQLDataProcessAnalyze.MySQLProcessResult mySQLProcessResult = this.mySQLDataProcessAnalyze.upsertDataPack(tableDateList, ((EasyHashMap)tableInfo.get()).toEasyTableAnnotation(false, true));
            String s = mySQLProcessResult.getSql();
            s = s.replaceAll("'true'", "1").replaceAll("'false'", "0").replaceAll("'null'", "null");
            file.write(s);
            file.write(";");
            file.newLine();
        }
        file.close();
        log.info("\u6570\u636e\u5907\u4efd\u7ed3\u675f\u8f93\u51fa\u6587\u4ef6\u5730\u5740:" + System.getProperty("user.dir"));
    }

    public void saveSqlFile() throws ProcessException, SQLException, MethodParamFunctionException, IOException, ExecutionException, InterruptedException {
        List<LazyDatabase> databaseList = this.showDatabases();
        for (LazyDatabase database : databaseList) {
            this.saveSqlFile(database.getDatabase());
        }
    }

    public void saveSoftSqlFile() throws ProcessException, SQLException, MethodParamFunctionException, IOException, ExecutionException, InterruptedException {
        List<LazyDatabase> databaseList = this.showDatabases();
        for (LazyDatabase database : databaseList) {
            this.saveSoftSqlFile(database.getDatabase());
        }
    }

    @Override
    public void saveSoftSqlFile(String nameDatabase) throws ProcessException, SQLException, MethodParamFunctionException, IOException, ExecutionException, InterruptedException {
        String filePackage = System.getProperty("user.dir") + File.separator + "data_file" + File.separator + nameDatabase;
        if (nameDatabase == null) {
            nameDatabase = (String)this.lazyBaseOperation.executeSQLForBean("select database()", String.class, new Object[0]);
        }
        String sqlSelectTable = "select concat('%s.',table_name) tableName, engine, table_comment tableComment, create_time createTime from information_schema.tables where table_schema = '%s' ";
        List allTables = this.lazyBaseOperation.executeSQL(String.format(sqlSelectTable, nameDatabase, nameDatabase), EasyHashMap.class, new Object[0]);
        BufferedWriter file = FileUtil.createFile((String)System.getProperty("user.dir"), (String)String.format("\u6570\u636e\u5e93%s\u6570\u636e.sql", nameDatabase));
        file.newLine();
        file.write(String.format("use %s;", nameDatabase));
        file.newLine();
        for (EasyHashMap table : allTables) {
            EasyHashMap one;
            List ignoreFields;
            String countSQL = "select count(1) from %s ";
            String tableName = table.get((Object)"tableName").toString();
            SchemaMap createTableSchema = (SchemaMap)this.lazyBaseOperation.executeSQLForBean("show create table %s", SchemaMap.class, new Object[]{tableName});
            String createTableSql = String.valueOf(createTableSchema.get((Object)"Create Table"));
            file.newLine();
            createTableSql = createTableSql.replaceAll("CREATE TABLE", "CREATE TABLE IF NOT EXISTS");
            file.write(createTableSql);
            file.write(";");
            Object tableComment = table.get((Object)"TABLECOMMENT");
            Long count = (Long)this.lazyBaseOperation.executeSQLForBean(String.format(countSQL, tableName), Long.class, new Object[0]);
            if (count == 0L) continue;
            AtomicReference tableInfo = new AtomicReference();
            String selectSQL = "select * from %s ";
            if (count > 1000L) {
                Page page = new Page(1, 1000);
                this.scroll(page, EasyHashMap.class, selectSQL, scrollPage -> {
                    EasyHashMap one;
                    List ignoreFields;
                    if (ObjectUtils.isEmpty((Object)scrollPage.getRecord())) {
                        return scrollPage;
                    }
                    List record = (List)scrollPage.getRecord();
                    List<String> ignoreExportedFields = this.exportDataConfiguration.getIgnoreExportedFields();
                    if (!ObjectUtils.isEmpty(ignoreExportedFields) && !ObjectUtils.isEmpty(ignoreFields = (one = (EasyHashMap)record.get(0)).keySet().stream().filter(key -> ignoreExportedFields.contains(key)).collect(Collectors.toList()))) {
                        List ignoredData;
                        record = ignoredData = record.stream().map(easyHashMap -> {
                            for (Object ignoreField : ignoreFields) {
                                easyHashMap.remove(ignoreField);
                            }
                            return easyHashMap;
                        }).collect(Collectors.toList());
                    }
                    tableInfo.set(record.get(0));
                    int from = (scrollPage.getCurrent() - 1) * scrollPage.getSize();
                    int to = from + scrollPage.getRecord().size();
                    file.write(String.format("\n-- ----------------------------\n-- LazyTableInfo data for %s   \u7b2c\u3010 %s ~ %s \u3011\u6761\u6570\u636e  \n-- LazyTableInfo table_comment for %s \n-- ----------------------------", tableName, from, to, tableComment));
                    file.newLine();
                    ((EasyHashMap)tableInfo.get()).setUniqueLabel(tableName);
                    MySQLDataProcessAnalyze.MySQLProcessResult mySQLProcessResult = this.mySQLDataProcessAnalyze.upsertDataPack(record, ((EasyHashMap)tableInfo.get()).toEasyTableAnnotation(false, true));
                    String s = mySQLProcessResult.getSql();
                    s = s.replaceAll("'true'", "1").replaceAll("'false'", "0").replaceAll("'null'", "null");
                    file.write(s);
                    file.write(";");
                    file.newLine();
                    page.setCurrent(page.getCurrent() + 1);
                    return scrollPage;
                }, tableName);
                continue;
            }
            List tableDateList = this.lazyBaseOperation.executeSQL(String.format(selectSQL, tableName), EasyHashMap.class, new Object[0]);
            if (ObjectUtils.isEmpty((Object)tableDateList)) continue;
            List<String> ignoreExportedFields = this.exportDataConfiguration.getIgnoreExportedFields();
            if (!ObjectUtils.isEmpty(ignoreExportedFields) && !ObjectUtils.isEmpty(ignoreFields = (one = (EasyHashMap)tableDateList.get(0)).keySet().stream().filter(key -> ignoreExportedFields.contains(key)).collect(Collectors.toList()))) {
                List ignoredData;
                tableDateList = ignoredData = tableDateList.stream().map(easyHashMap -> {
                    for (Object ignoreField : ignoreFields) {
                        easyHashMap.remove(ignoreField);
                    }
                    return easyHashMap;
                }).collect(Collectors.toList());
            }
            int from = 0;
            int to = tableDateList.size();
            file.write(String.format("\n-- ----------------------------\n-- LazyTableInfo data for %s   \u7b2c\u3010 %s ~ %s \u3011\u6761\u6570\u636e  \n-- LazyTableInfo table_comment for %s \n-- ----------------------------", tableName, from, to, tableComment));
            file.newLine();
            tableInfo.set(tableDateList.get(0));
            ((EasyHashMap)tableInfo.get()).setUniqueLabel(tableName);
            MySQLDataProcessAnalyze.MySQLProcessResult mySQLProcessResult = this.mySQLDataProcessAnalyze.upsertDataPack(tableDateList, ((EasyHashMap)tableInfo.get()).toEasyTableAnnotation(false, true));
            String s = mySQLProcessResult.getSql();
            s = s.replaceAll("'true'", "1").replaceAll("'false'", "0").replaceAll("'null'", "null");
            file.write(s);
            file.write(";");
            file.newLine();
        }
        file.close();
        log.info("\u6570\u636e\u5907\u4efd\u7ed3\u675f\u8f93\u51fa\u6587\u4ef6\u5730\u5740:" + System.getProperty("user.dir"));
    }

    @Override
    public void saveUpsertSqlFile(String nameDatabase) throws ProcessException, SQLException, MethodParamFunctionException, IOException, ExecutionException, InterruptedException {
        String filePackage = System.getProperty("user.dir") + File.separator + "data_file" + File.separator + nameDatabase;
        if (nameDatabase == null) {
            nameDatabase = (String)this.lazyBaseOperation.executeSQLForBean("select database()", String.class, new Object[0]);
        }
        String sqlSelectTable = "select concat('%s.',table_name) tableName, engine, table_comment tableComment, create_time createTime from information_schema.tables where table_schema = '%s' ";
        List allTables = this.lazyBaseOperation.executeSQL(String.format(sqlSelectTable, nameDatabase, nameDatabase), EasyHashMap.class, new Object[0]);
        BufferedWriter file = FileUtil.createFile((String)System.getProperty("user.dir"), (String)String.format("\u6570\u636e\u5e93%s\u6570\u636e.sql", nameDatabase));
        file.newLine();
        file.write(String.format("use %s;", nameDatabase));
        file.newLine();
        for (EasyHashMap table : allTables) {
            EasyHashMap one;
            List ignoreFields;
            String countSQL = "select count(1) from %s ";
            String tableName = table.get((Object)"tableName").toString();
            Object tableComment = table.get((Object)"TABLECOMMENT");
            Long count = (Long)this.lazyBaseOperation.executeSQLForBean(String.format(countSQL, tableName), Long.class, new Object[0]);
            if (count == 0L) continue;
            AtomicReference tableInfo = new AtomicReference();
            String selectSQL = "select * from %s ";
            if (count > 1000L) {
                Page page = new Page(1, 1000);
                this.scroll(page, EasyHashMap.class, selectSQL, scrollPage -> {
                    EasyHashMap one;
                    List ignoreFields;
                    if (ObjectUtils.isEmpty((Object)scrollPage.getRecord())) {
                        return scrollPage;
                    }
                    List record = (List)scrollPage.getRecord();
                    List<String> ignoreExportedFields = this.exportDataConfiguration.getIgnoreExportedFields();
                    if (!ObjectUtils.isEmpty(ignoreExportedFields) && !ObjectUtils.isEmpty(ignoreFields = (one = (EasyHashMap)record.get(0)).keySet().stream().filter(key -> ignoreExportedFields.contains(key)).collect(Collectors.toList()))) {
                        List ignoredData;
                        record = ignoredData = record.stream().map(easyHashMap -> {
                            for (Object ignoreField : ignoreFields) {
                                easyHashMap.remove(ignoreField);
                            }
                            return easyHashMap;
                        }).collect(Collectors.toList());
                    }
                    tableInfo.set(record.get(0));
                    int from = (scrollPage.getCurrent() - 1) * scrollPage.getSize();
                    int to = from + scrollPage.getRecord().size();
                    file.write(String.format("\n-- ----------------------------\n-- LazyTableInfo data for %s   \u7b2c\u3010 %s ~ %s \u3011\u6761\u6570\u636e  \n-- LazyTableInfo table_comment for %s \n-- ----------------------------", tableName, from, to, tableComment));
                    file.newLine();
                    ((EasyHashMap)tableInfo.get()).setUniqueLabel(tableName);
                    MySQLDataProcessAnalyze.MySQLProcessResult mySQLProcessResult = this.mySQLDataProcessAnalyze.upsertDataPack(record, ((EasyHashMap)tableInfo.get()).toEasyTableAnnotation(false, true));
                    String s = mySQLProcessResult.getSql();
                    s = s.replaceAll("'true'", "1").replaceAll("'false'", "0").replaceAll("'null'", "null");
                    file.write(s);
                    file.write(";");
                    file.newLine();
                    page.setCurrent(page.getCurrent() + 1);
                    return scrollPage;
                }, tableName);
                continue;
            }
            List tableDateList = this.lazyBaseOperation.executeSQL(String.format(selectSQL, tableName), EasyHashMap.class, new Object[0]);
            if (ObjectUtils.isEmpty((Object)tableDateList)) continue;
            List<String> ignoreExportedFields = this.exportDataConfiguration.getIgnoreExportedFields();
            if (!ObjectUtils.isEmpty(ignoreExportedFields) && !ObjectUtils.isEmpty(ignoreFields = (one = (EasyHashMap)tableDateList.get(0)).keySet().stream().filter(key -> ignoreExportedFields.contains(key)).collect(Collectors.toList()))) {
                List ignoredData;
                tableDateList = ignoredData = tableDateList.stream().map(easyHashMap -> {
                    for (Object ignoreField : ignoreFields) {
                        easyHashMap.remove(ignoreField);
                    }
                    return easyHashMap;
                }).collect(Collectors.toList());
            }
            int from = 0;
            int to = tableDateList.size();
            file.write(String.format("\n-- ----------------------------\n-- LazyTableInfo data for %s   \u7b2c\u3010 %s ~ %s \u3011\u6761\u6570\u636e  \n-- LazyTableInfo table_comment for %s \n-- ----------------------------", tableName, from, to, tableComment));
            file.newLine();
            tableInfo.set(tableDateList.get(0));
            ((EasyHashMap)tableInfo.get()).setUniqueLabel(tableName);
            MySQLDataProcessAnalyze.MySQLProcessResult mySQLProcessResult = this.mySQLDataProcessAnalyze.upsertDataPack(tableDateList, ((EasyHashMap)tableInfo.get()).toEasyTableAnnotation(false, true));
            String s = mySQLProcessResult.getSql();
            s = s.replaceAll("'true'", "1").replaceAll("'false'", "0").replaceAll("'null'", "null");
            file.write(s);
            file.write(";");
            file.newLine();
        }
        file.close();
        log.info("\u6570\u636e\u5907\u4efd\u7ed3\u675f\u8f93\u51fa\u6587\u4ef6\u5730\u5740:" + System.getProperty("user.dir"));
    }

    @Override
    public List<LazyDatabase> showDatabases() {
        List databaseList = this.lazyBaseOperation.executeSQL("show databases;", LazyDatabase.class, new Object[0]);
        return databaseList;
    }

    @Override
    public List<LazyTableInfo> showTables(@NonNull String tableSchema) {
        String sqlSelectTable = "select * from information_schema.tables where table_schema = '%s' ";
        List tables = this.lazyBaseOperation.executeSQL(sqlSelectTable, LazyTableInfo.class, new Object[]{tableSchema});
        return tables;
    }
}

