/*
 * Decompiled with CFR 0.152.
 */
package com.wu.framework.inner.lazy.database.expand.database.persistence.method;

import com.wu.framework.inner.layer.CamelAndUnderLineConverter;
import com.wu.framework.inner.layer.data.convert.LazyDataFactory;
import com.wu.framework.inner.layer.stereotype.MethodParamFunction;
import com.wu.framework.inner.lazy.database.domain.LazyColumn;
import com.wu.framework.inner.lazy.database.domain.LazyTableInfo;
import com.wu.framework.inner.lazy.database.expand.database.persistence.domain.PersistenceRepository;
import com.wu.framework.inner.lazy.database.expand.database.persistence.domain.PersistenceRepositoryFactory;
import com.wu.framework.inner.lazy.database.expand.database.persistence.method.LazyOperationMethod;
import com.wu.framework.inner.lazy.persistence.analyze.DefaultMySQLDataProcessAnalyze;
import com.wu.framework.inner.lazy.persistence.conf.ClassLazyTableEndpoint;
import com.wu.framework.inner.lazy.persistence.conf.FieldLazyTableFieldEndpoint;
import com.wu.framework.inner.lazy.persistence.conf.LazyDatabaseJsonMessage;
import com.wu.framework.inner.lazy.persistence.conf.LazyTableEndpoint;
import com.wu.framework.inner.lazy.persistence.conf.LazyTableFieldEndpoint;
import com.wu.framework.inner.lazy.persistence.map.EasyHashMap;
import com.wu.framework.inner.lazy.persistence.util.LazyTableFieldUtil;
import com.wu.framework.inner.lazy.persistence.util.LazyTableUtil;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ObjectUtils;

public abstract class AbstractLazyOperationMethod
implements LazyOperationMethod {
    DefaultMySQLDataProcessAnalyze processAnalyze = new DefaultMySQLDataProcessAnalyze();
    Logger log = LoggerFactory.getLogger(AbstractLazyOperationMethod.class);

    @Deprecated
    public static boolean isWrapClass(Class clazz) {
        try {
            if (String.class.isAssignableFrom(clazz)) {
                return true;
            }
            if (Byte[].class.isAssignableFrom(clazz)) {
                return true;
            }
            if (Byte.class.isAssignableFrom(clazz)) {
                return true;
            }
            if (byte[].class.isAssignableFrom(clazz)) {
                return true;
            }
            if (Byte.TYPE.isAssignableFrom(clazz)) {
                return true;
            }
            return ((Class)clazz.getField("TYPE").get(null)).isPrimitive();
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public Object execute(Connection connection, Object[] sourceParams) throws Exception {
        int n = 0;
        Object[] objectArray = sourceParams;
        int n2 = objectArray.length;
        if (n < n2) {
            Object param = objectArray[n];
            try (PreparedStatement preparedStatement = connection.prepareStatement(this.analyzePersistenceRepository(param).getQueryString());){
                Boolean bl = preparedStatement.execute();
                return bl;
            }
        }
        return null;
    }

    public Object accurateExecution(Connection connection, Object param) throws Exception {
        return this.executionFunction(connection, (MethodParamFunction<PreparedStatement>)((MethodParamFunction)preparedStatement -> {
            preparedStatement.execute();
            return preparedStatement;
        }), param);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object executionFunction(Connection connection, MethodParamFunction<PreparedStatement> methodParamFunction, Object param) throws Exception {
        PersistenceRepository persistenceRepository = this.analyzePersistenceRepository(param);
        try (PreparedStatement preparedStatement = connection.prepareStatement(persistenceRepository.getQueryString());){
            Object object = methodParamFunction.defaultMethod((Object)preparedStatement);
            return object;
        }
    }

    public <E> List<E> resultSetConverter(ResultSet resultSet, String resultType) throws SQLException, NoSuchFieldException, InstantiationException, IllegalAccessException {
        Class<?> domainClass = null;
        try {
            domainClass = Class.forName(resultType);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return this.resultSetConverter(resultSet, domainClass);
    }

    public <E> List<E> resultSetConverter(ResultSet resultSet, Class<E> domainClass) throws SQLException, InstantiationException, IllegalAccessException, NoSuchFieldException {
        ArrayList<Object> list = new ArrayList<Object>();
        if (Map.class.isAssignableFrom(domainClass)) {
            while (resultSet.next()) {
                EasyHashMap hashMap = new HashMap();
                ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                if (EasyHashMap.class.isAssignableFrom(domainClass)) {
                    hashMap = new EasyHashMap();
                    String tableName = resultSetMetaData.getTableName(1);
                    hashMap.setUniqueLabel(CamelAndUnderLineConverter.capitalizeFirstLetter((String)tableName));
                }
                int columnCount = resultSetMetaData.getColumnCount();
                for (int i = 1; i <= columnCount; ++i) {
                    String columnName = resultSetMetaData.getColumnName(i);
                    String columnClassName = resultSetMetaData.getColumnClassName(i);
                    Object columnValue = resultSet.getObject(i);
                    if (EasyHashMap.class.isAssignableFrom(domainClass)) {
                        hashMap.put((Object)CamelAndUnderLineConverter.lineToHumpField((String)columnName), columnValue, columnClassName);
                        continue;
                    }
                    hashMap.put(CamelAndUnderLineConverter.lineToHumpField((String)columnName), columnValue);
                }
                list.add(hashMap);
            }
        } else if (AbstractLazyOperationMethod.isWrapClass(domainClass)) {
            while (resultSet.next()) {
                list.add(resultSet.getObject(1));
            }
        } else {
            List convertedFieldList = LazyTableFieldUtil.analyzeFieldOnAnnotation(domainClass, null);
            Map<String, String> convertedFieldMap = convertedFieldList.stream().collect(Collectors.toMap(LazyTableFieldEndpoint::getName, LazyTableFieldEndpoint::getName));
            while (resultSet.next()) {
                E e = domainClass.newInstance();
                ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                int columnCount = resultSetMetaData.getColumnCount();
                for (int i = 1; i <= columnCount; ++i) {
                    String columnLabel;
                    String columnName = resultSetMetaData.getColumnName(i).toLowerCase();
                    String fieldName = convertedFieldMap.getOrDefault(columnName = CamelAndUnderLineConverter.lineToHumpField((String)columnName), convertedFieldMap.get(columnLabel = resultSetMetaData.getColumnLabel(i)));
                    if (ObjectUtils.isEmpty((Object)fieldName)) continue;
                    Field field = domainClass.getDeclaredField(fieldName);
                    Class<?> fieldType = field.getType();
                    field.setAccessible(true);
                    Object object = resultSet.getObject(i);
                    LazyDataFactory.handler(e, (Field)field, (Object)object);
                }
                list.add(e);
            }
        }
        return list;
    }

    protected <T> T convertToTheCorrespondingObject(Object obj, Class<T> clazz) {
        return null;
    }

    public String loadSqlParameters(String sqlFormat, Object ... params) {
        PersistenceRepository persistenceRepository = PersistenceRepositoryFactory.create();
        String sql = String.format(sqlFormat, params);
        persistenceRepository.setQueryString(sql);
        return persistenceRepository.getQueryString();
    }

    public synchronized boolean perfect(Connection connection, EasyHashMap easyHashMap) throws SQLException, NoSuchFieldException, InstantiationException, IllegalAccessException {
        ClassLazyTableEndpoint classLazyTableEndpoint = easyHashMap.toEasyTableAnnotation();
        return this.perfect(connection, (LazyTableEndpoint)classLazyTableEndpoint);
    }

    public synchronized boolean perfect(Connection connection, Class entityClass) throws SQLException, NoSuchFieldException, InstantiationException, IllegalAccessException {
        if (LazyDatabaseJsonMessage.localCacheEntityClass.contains(entityClass)) {
            return true;
        }
        if (!EasyHashMap.class.isAssignableFrom(entityClass)) {
            LazyDatabaseJsonMessage.localCacheEntityClass.add(entityClass);
        }
        ClassLazyTableEndpoint classLazyTableEndpoint = LazyTableUtil.analyzeLazyTable((Class)entityClass);
        return this.perfect(connection, (LazyTableEndpoint)classLazyTableEndpoint);
    }

    public synchronized boolean perfect(Connection connection, LazyTableEndpoint classLazyTableEndpoint) throws SQLException, NoSuchFieldException, InstantiationException, IllegalAccessException {
        String schema;
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery(this.loadSqlParameters("select * from information_schema.tables where table_schema='%s' and table_name='%s' ", schema = ObjectUtils.isEmpty((Object)classLazyTableEndpoint.getSchema()) ? connection.getCatalog() : classLazyTableEndpoint.getSchema(), classLazyTableEndpoint.getTableName()));
        List<LazyTableInfo> lazyTableInfos = this.resultSetConverter(resultSet, LazyTableInfo.class);
        if (ObjectUtils.isEmpty(lazyTableInfos)) {
            String createTableSQL = classLazyTableEndpoint.creatTableSQL();
            for (String sql : createTableSQL.split(";")) {
                statement.execute(sql);
            }
            this.log.info("create table {} success", (Object)classLazyTableEndpoint.getTableName());
        } else {
            ResultSet resultSetLazyColumn = statement.executeQuery(this.loadSqlParameters("select * from information_schema.COLUMNS where table_schema='%s' and table_name='%s' ", schema, classLazyTableEndpoint.getTableName()));
            List<LazyColumn> lazyColumnCollection = this.resultSetConverter(resultSetLazyColumn, LazyColumn.class);
            ArrayList<FieldLazyTableFieldEndpoint> currentColumnNameList = new ArrayList<FieldLazyTableFieldEndpoint>();
            for (LazyColumn lazyColumn : lazyColumnCollection) {
                FieldLazyTableFieldEndpoint oldFieldLazyTableFieldEndpoint = new FieldLazyTableFieldEndpoint();
                oldFieldLazyTableFieldEndpoint.setColumnName(lazyColumn.getColumnName());
                oldFieldLazyTableFieldEndpoint.setColumnType(lazyColumn.getColumnType());
                oldFieldLazyTableFieldEndpoint.setNotNull(!"yes".equalsIgnoreCase(lazyColumn.getIsNullable()));
                oldFieldLazyTableFieldEndpoint.setDefaultValue(lazyColumn.getColumnDefault());
                oldFieldLazyTableFieldEndpoint.setComment(lazyColumn.getColumnComment());
                currentColumnNameList.add(oldFieldLazyTableFieldEndpoint);
            }
            String alterTableSQL = classLazyTableEndpoint.alterTableSQL(currentColumnNameList);
            if (!ObjectUtils.isEmpty((Object)alterTableSQL)) {
                try {
                    boolean lazyColumn = statement.execute(alterTableSQL);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new RuntimeException("\u6267\u884csql \u5931\u8d25: " + alterTableSQL);
                }
            }
        }
        statement.close();
        return true;
    }
}

