/*
 * Decompiled with CFR 0.152.
 */
package com.wu.framework.inner.lazy.database.expand.database.persistence.proxy;

import com.wu.framework.inner.database.dynamic.LazyDynamicAdapter;
import com.wu.framework.inner.layer.stereotype.proxy.ProxyStrategicApproach;
import com.wu.framework.inner.lazy.database.expand.database.persistence.method.LazyOperationMethod;
import com.wu.framework.inner.lazy.database.smart.database.persistence.PerfectLazyOperation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.context.annotation.Import;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.jdbc.datasource.DataSourceUtils;

@ConditionalOnBean(value={DataSource.class})
@Import(value={PerfectLazyOperation.class})
public class LazyOperationProxy
implements InvocationHandler,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(LazyOperationProxy.class);
    private static final Map<Class<? extends LazyOperationMethod>, LazyOperationMethod> LAZY_OPERATION_METHOD_MAP = new HashMap<Class<? extends LazyOperationMethod>, LazyOperationMethod>();
    private final List<LazyOperationMethod> lazyOperationMethods;
    private final LazyDynamicAdapter lazyDynamicAdapter;

    public LazyOperationProxy(List<LazyOperationMethod> lazyOperationMethods, LazyDynamicAdapter lazyDynamicAdapter) {
        this.lazyOperationMethods = lazyOperationMethods;
        this.lazyDynamicAdapter = lazyDynamicAdapter;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        ProxyStrategicApproach mergedAnnotation = (ProxyStrategicApproach)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, ProxyStrategicApproach.class);
        if (null != mergedAnnotation) {
            LazyOperationMethod lazyOperationMethod = LAZY_OPERATION_METHOD_MAP.get(mergedAnnotation.proxyClass());
            if (null == lazyOperationMethod) {
                log.error("\u65e0\u6cd5\u627e\u5230\u5bf9\u5e94class \uff1a\u3010{}\u3011\u7684\u4ee3\u7406\u5b9e\u73b0", (Object)mergedAnnotation.proxyClass());
            }
            DataSource dataSource = this.lazyDynamicAdapter.determineDataSource();
            Connection connection = DataSourceUtils.getConnection((DataSource)dataSource);
            boolean isConnectionTransactional = DataSourceUtils.isConnectionTransactional((Connection)connection, (DataSource)dataSource);
            boolean autoCommit = connection.getAutoCommit();
            try {
                if (connection.isClosed()) {
                    System.out.println("this.connection  \u5173\u95ed\u4e86");
                }
                Object execute = lazyOperationMethod.execute(connection, args);
                if (connection != null && !isConnectionTransactional && !autoCommit) {
                    log.debug("Committing JDBC Connection [" + connection + "]");
                    connection.commit();
                }
                Object object = execute;
                return object;
            }
            catch (Exception exception) {
                if (connection != null && !isConnectionTransactional && !autoCommit) {
                    log.debug("Rolling back JDBC Connection [" + connection + "]");
                    connection.rollback();
                }
                exception.printStackTrace();
                throw exception;
            }
            finally {
                DataSourceUtils.releaseConnection((Connection)connection, (DataSource)dataSource);
            }
        }
        if (method.getParameterCount() == 0) {
            return method.invoke((Object)this, args);
        }
        return method.invoke(null, args);
    }

    public void afterPropertiesSet() throws Exception {
        this.lazyOperationMethods.forEach(lazyOperationMethod -> LAZY_OPERATION_METHOD_MAP.put((Class<? extends LazyOperationMethod>)lazyOperationMethod.getClass(), (LazyOperationMethod)lazyOperationMethod));
    }

    public DataSource determineConnection() throws SQLException {
        return this.lazyDynamicAdapter.determineDataSource();
    }
}

