/*
 * Decompiled with CFR 0.152.
 */
package com.wu.framework.inner.lazy.database.smart.database.persistence;

import com.wu.framework.inner.layer.CamelAndUnderLineConverter;
import com.wu.framework.inner.layer.util.DataTransformUntil;
import com.wu.framework.inner.lazy.config.LazyOperationConfig;
import com.wu.framework.inner.lazy.config.enums.MysqlColumnTypeEnum;
import com.wu.framework.inner.lazy.database.domain.LazyColumn;
import com.wu.framework.inner.lazy.database.domain.LazyTableInfo;
import com.wu.framework.inner.lazy.database.expand.database.persistence.stream.condition.AbstractBasicComparison;
import com.wu.framework.inner.lazy.database.expand.database.persistence.stream.lambda.LazyLambdaStream;
import com.wu.framework.inner.lazy.database.expand.database.persistence.stream.wrapper.LazyWrappers;
import com.wu.framework.inner.lazy.database.smart.database.AutoStuffed;
import com.wu.framework.inner.lazy.persistence.conf.ClassLazyTableEndpoint;
import com.wu.framework.inner.lazy.persistence.conf.FieldLazyTableFieldEndpoint;
import com.wu.framework.inner.lazy.persistence.map.EasyHashMap;
import com.wu.framework.inner.lazy.persistence.util.LazyTableUtil;
import java.io.File;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class LazyOperationAutoStuffed
implements AutoStuffed {
    private static final Logger log = LoggerFactory.getLogger(LazyOperationAutoStuffed.class);
    public final LazyLambdaStream lazyLambdaStream;
    private final LazyOperationConfig operationConfig;
    ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(5, 20, 20L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(20));

    public LazyOperationAutoStuffed(LazyLambdaStream lazyLambdaStream) {
        this.lazyLambdaStream = lazyLambdaStream;
        this.operationConfig = new LazyOperationConfig();
    }

    public LazyOperationAutoStuffed(LazyOperationConfig operationConfig, LazyLambdaStream lazyLambdaStream) {
        this.operationConfig = operationConfig;
        this.lazyLambdaStream = lazyLambdaStream;
    }

    private void stuffedSimple(LazyTableInfo table, List<LazyColumn> lazyColumnList, Long num) {
        Assert.notNull((Object)num, (String)"'num' must not be null ");
        if (this.operationConfig.getIgnoredDatabase().contains(table.getTableSchema())) {
            log.warn("\u53d7\u4fdd\u62a4\u7684\u6570\u636e\u5e93:{}\u4e0d\u4f1a\u81ea\u52a8\u586b\u5145,\u66f4\u591a\u914d\u7f6e\u53c2\u8003\u914d\u7f6e\u6587\u4ef6\u6dfb\u52a0 spring.lazy.ignored-database:{} ", (Object)table.getTableSchema(), (Object)this.operationConfig.getIgnoredDatabase());
            return;
        }
        String schema = table.getTableSchema();
        String tableName = table.getTableName();
        if (ObjectUtils.isEmpty(lazyColumnList)) {
            return;
        }
        ArrayList<EasyHashMap> list = new ArrayList<EasyHashMap>();
        int i = 0;
        while ((long)i <= num) {
            EasyHashMap objectObjectEasyHashMap = new EasyHashMap(schema + "." + tableName);
            objectObjectEasyHashMap.setKeyAdjust(false);
            for (LazyColumn lazyColumn : lazyColumnList) {
                String columnName = lazyColumn.getColumnName();
                Long characterMaximumLength = lazyColumn.getCharacterMaximumLength();
                String extra = lazyColumn.getExtra();
                String isNullable = lazyColumn.getIsNullable();
                if ("auto_increment".equals(extra) || this.operationConfig.getFillIgnoredFields().contains(columnName) && "YES".equals(isNullable)) continue;
                String columnDataType = lazyColumn.getDataType();
                MysqlColumnTypeEnum mysqlColumnTypeEnum = (MysqlColumnTypeEnum)MysqlColumnTypeEnum.MYSQL_COLUMN_TYPE_ENUM_MAP.get(columnDataType);
                if (null == mysqlColumnTypeEnum) {
                    log.warn("\u81ea\u52a8\u586b\u5145\u6570\u636eschema:{} tableName:{} \u65e0\u6cd5\u627e\u5230\u7c7b\u578b{}\uff0c\u5f53\u524d\u5b57\u6bb5{}\u6570\u636e\u586b\u5145\u4e3anull", new Object[]{schema, tableName, columnDataType, columnName});
                    continue;
                }
                Class javaType = mysqlColumnTypeEnum.getJavaType();
                if (LocalDateTime.class.isAssignableFrom(javaType)) {
                    objectObjectEasyHashMap.put((Object)columnName, (Object)"2022-12-12 00:00:00");
                    continue;
                }
                if (Date.class.isAssignableFrom(javaType)) {
                    objectObjectEasyHashMap.put((Object)columnName, (Object)"2022-12-12");
                    continue;
                }
                if (Date.class.isAssignableFrom(javaType)) {
                    objectObjectEasyHashMap.put((Object)columnName, (Object)"2022-12-12");
                    continue;
                }
                if (File.class.isAssignableFrom(javaType)) {
                    try {
                        objectObjectEasyHashMap.put((Object)columnName, (Object)File.createTempFile("temp", "temp"));
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                if (columnDataType.contains("varchar") || columnDataType.contains("char")) {
                    objectObjectEasyHashMap.put((Object)columnName, DataTransformUntil.simulationBaseBean((Class)javaType, (Integer)Math.toIntExact(characterMaximumLength)));
                } else {
                    objectObjectEasyHashMap.put((Object)columnName, DataTransformUntil.simulationBaseBean((Class)javaType, (Integer)mysqlColumnTypeEnum.getBound()));
                }
                if (!columnDataType.contains("decimal")) continue;
                objectObjectEasyHashMap.put((Object)columnName, (Object)0);
            }
            list.add(objectObjectEasyHashMap);
            ++i;
        }
        try {
            this.lazyLambdaStream.insert(list);
        }
        catch (Throwable throwable) {
            log.error("\u5f53\u524d\u6570\u636e\u63d2\u5165\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u5f53\u524d\u6570\u636e\u5e93\u8868\u7ed3\u6784{}", lazyColumnList);
            throwable.printStackTrace();
        }
    }

    @Override
    public void stuffed(LazyTableInfo table, Long num) {
        Assert.notNull((Object)num, (String)"'num' must not be null ");
        if (this.operationConfig.getIgnoredDatabase().contains(table.getTableSchema())) {
            log.warn("\u53d7\u4fdd\u62a4\u7684\u6570\u636e\u5e93:{}\u4e0d\u4f1a\u81ea\u52a8\u586b\u5145,\u66f4\u591a\u914d\u7f6e\u53c2\u8003\u914d\u7f6e\u6587\u4ef6\u6dfb\u52a0 spring.lazy.ignored-database:{} ", (Object)table.getTableSchema(), (Object)this.operationConfig.getIgnoredDatabase());
            return;
        }
        String schema = table.getTableSchema();
        String tableName = table.getTableName();
        List<LazyColumn> lazyColumnList = this.lazyLambdaStream.selectList(((AbstractBasicComparison)LazyWrappers.lambdaWrapper().eq(LazyColumn::getTableSchema, (Object)schema)).eq(LazyColumn::getTableName, (Object)tableName)).stream().collect(Collectors.toList());
        if (ObjectUtils.isEmpty(lazyColumnList)) {
            return;
        }
        if (num > this.operationConfig.getFillMaximum()) {
            long time = num / this.operationConfig.getFillMaximum();
            long remainingSize = num % this.operationConfig.getFillMaximum();
            int i = 0;
            while ((long)i < time) {
                log.info("\u6267\u884c\u6b21\u6570:{},\u6dfb\u52a0\u7684\u6570\u636e\u5e93:{},\u8868:{}", new Object[]{i, schema, tableName});
                this.threadPoolExecutor.submit(() -> this.stuffedSimple(table, lazyColumnList, this.operationConfig.getFillMaximum()));
                ++i;
            }
            this.threadPoolExecutor.submit(() -> this.stuffedSimple(table, lazyColumnList, remainingSize));
        } else {
            this.stuffedSimple(table, lazyColumnList, num);
        }
    }

    @Override
    public <T> void stuffed(Class<T> tableClass, Long num) {
        Assert.notNull((Object)num, (String)"'num' must not be null ");
        ClassLazyTableEndpoint classLazyTableEndpoint = LazyTableUtil.analyzeLazyTable(tableClass);
        if (this.operationConfig.getIgnoredDatabase().contains(classLazyTableEndpoint.getSchema())) {
            log.warn("\u53d7\u4fdd\u62a4\u7684\u6570\u636e\u5e93:{}\u4e0d\u4f1a\u81ea\u52a8\u586b\u5145,\u66f4\u591a\u914d\u7f6e\u53c2\u8003\u914d\u7f6e\u6587\u4ef6\u6dfb\u52a0 spring.lazy.ignored-database:{} ", (Object)classLazyTableEndpoint.getSchema(), (Object)this.operationConfig.getIgnoredDatabase());
            return;
        }
        if (num > this.operationConfig.getFillMaximum()) {
            long time = num / this.operationConfig.getFillMaximum();
            long remainingSize = num % this.operationConfig.getFillMaximum();
            int i = 0;
            while ((long)i < time) {
                this.threadPoolExecutor.submit(() -> {
                    ArrayList<Object> tList = new ArrayList<Object>();
                    int j = 0;
                    while ((long)j < this.operationConfig.getFillMaximum()) {
                        tList.add(DataTransformUntil.simulationBean((Class)tableClass));
                        ++j;
                    }
                    this.lazyLambdaStream.insert(tList);
                });
                ++i;
            }
            this.threadPoolExecutor.submit(() -> {
                ArrayList<Object> tList = new ArrayList<Object>();
                int i = 0;
                while ((long)i < remainingSize) {
                    tList.add(DataTransformUntil.simulationBean((Class)tableClass));
                    ++i;
                }
                this.lazyLambdaStream.insert(tList);
            });
        } else {
            ArrayList<Object> tList = new ArrayList<Object>();
            int i = 0;
            while ((long)i < num) {
                tList.add(DataTransformUntil.simulationBean(tableClass));
                ++i;
            }
            this.lazyLambdaStream.insert(tList);
        }
    }

    @Override
    public void stuffedJava(String schema, String tableName) {
        LazyTableInfo lazyTableInfo = (LazyTableInfo)this.lazyLambdaStream.of(LazyTableInfo.class).selectOne(((AbstractBasicComparison)LazyWrappers.lambdaWrapper().eqIgnoreEmpty(LazyTableInfo::getTableSchema, (Object)schema)).eqIgnoreEmpty(LazyTableInfo::getTableName, (Object)tableName));
        List fieldLazyTableFieldEndpointList = this.lazyLambdaStream.of(LazyColumn.class).selectList(((AbstractBasicComparison)LazyWrappers.lambdaWrapper().eqIgnoreEmpty(LazyColumn::getTableSchema, (Object)schema)).eqIgnoreEmpty(LazyColumn::getTableName, (Object)tableName)).stream().map(lazyColumn -> {
            FieldLazyTableFieldEndpoint fieldEndpoint = new FieldLazyTableFieldEndpoint();
            String columnName = lazyColumn.getColumnName();
            fieldEndpoint.setColumnName(columnName);
            fieldEndpoint.setName(CamelAndUnderLineConverter.lineToHumpField((String)columnName));
            fieldEndpoint.setComment(lazyColumn.getColumnComment());
            fieldEndpoint.setColumnType(lazyColumn.getColumnType());
            fieldEndpoint.setDataType(lazyColumn.getDataType());
            return fieldEndpoint;
        }).collect(Collectors.toList());
        ClassLazyTableEndpoint tableEndpoint = new ClassLazyTableEndpoint();
        tableEndpoint.setSchema(schema);
        tableEndpoint.setTableName(tableName);
        tableEndpoint.setClassName(CamelAndUnderLineConverter.lineToHumpClass((String)tableName));
        tableEndpoint.setFieldEndpoints(fieldLazyTableFieldEndpointList);
        tableEndpoint.setComment(lazyTableInfo.getTableComment());
        tableEndpoint.setPackageName(this.operationConfig.getReverseEngineering().getPackageName() + "." + "domain");
        String entitySuffix = this.operationConfig.getReverseEngineering().getEntitySuffix();
        if (!ObjectUtils.isEmpty((Object)entitySuffix)) {
            String className = tableEndpoint.getClassName();
            tableEndpoint.setClassName(className + entitySuffix);
        }
        LazyTableUtil.createJava((ClassLazyTableEndpoint)tableEndpoint, (LazyOperationConfig.ReverseEngineering)this.operationConfig.getReverseEngineering());
    }
}

