/*
 * Decompiled with CFR 0.152.
 */
package com.wu.framework.inner.lazy.database.smart.database.persistence;

import com.wu.framework.inner.layer.data.ProcessException;
import com.wu.framework.inner.layer.stereotype.MethodParamFunctionException;
import com.wu.framework.inner.lazy.database.domain.LazyDatabase;
import com.wu.framework.inner.lazy.database.domain.LazyTableInfo;
import com.wu.framework.inner.lazy.database.smart.database.AutoStuffed;
import com.wu.framework.inner.lazy.database.smart.database.Perfect;
import com.wu.framework.inner.lazy.database.smart.database.SmartLazyOperation;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import java.util.concurrent.ExecutionException;

public class LazySmartLazyOperation
implements SmartLazyOperation {
    private final AutoStuffed autoStuffed;
    private final Perfect perfect;

    public LazySmartLazyOperation(AutoStuffed autoStuffed, Perfect perfect) {
        this.autoStuffed = autoStuffed;
        this.perfect = perfect;
    }

    @Override
    public void saveSqlFile(String nameDatabase) {
        try {
            this.perfect.saveSqlFile(nameDatabase);
        }
        catch (ProcessException | MethodParamFunctionException | IOException | InterruptedException | SQLException | ExecutionException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void saveSoftSqlFile(String nameDatabase) {
        try {
            this.perfect.saveSoftSqlFile(nameDatabase);
        }
        catch (ProcessException | MethodParamFunctionException | IOException | InterruptedException | SQLException | ExecutionException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void saveUpsertSqlFile(String nameDatabase) {
        try {
            this.perfect.saveUpsertSqlFile(nameDatabase);
        }
        catch (ProcessException | MethodParamFunctionException | IOException | InterruptedException | SQLException | ExecutionException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void stuffed(String schema, String table, Long num) {
        this.autoStuffed.stuffed(schema, table, num);
    }

    @Override
    public void stuffed(Class table, Long num) {
        this.autoStuffed.stuffed(table, num);
    }

    @Override
    public void stuffedAll(Long num) {
        for (LazyDatabase showDatabase : this.perfect.showDatabases()) {
            System.out.println("\u8ba1\u5212\u6267\u884c\u6570\u636e\u5e93\u586b\u5145" + showDatabase.getDatabase());
            for (LazyTableInfo showTable : this.perfect.showTables(showDatabase.getDatabase())) {
                this.autoStuffed.stuffed(showTable, num);
            }
        }
    }

    @Override
    public void stuffedJava(String schema, String tableName) {
        this.autoStuffed.stuffedJava(schema, tableName);
    }

    @Override
    public List<LazyDatabase> showDatabases() {
        return this.perfect.showDatabases();
    }

    @Override
    public List<LazyTableInfo> showTables(String schema) {
        return this.perfect.showTables(schema);
    }
}

