/*
 * Decompiled with CFR 0.152.
 */
package com.wu.framework.inner.redis.aop;

import com.wu.framework.inner.redis.annotation.LazyRedis;
import com.wu.framework.inner.redis.component.LazyRedisTemplate;
import java.lang.reflect.Method;
import lombok.NonNull;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.Pointcut;
import org.springframework.aop.support.AbstractPointcutAdvisor;
import org.springframework.aop.support.ComposablePointcut;
import org.springframework.aop.support.annotation.AnnotationMatchingPointcut;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.core.annotation.AnnotationUtils;

public class LazyRedisDBAOPAdvisor
extends AbstractPointcutAdvisor
implements BeanFactoryAware {
    private Advice advice;
    private Pointcut pointcut;

    public LazyRedisDBAOPAdvisor(@NonNull LazyRedisDBInterceptor lazyRedisDBInterceptor) {
        if (lazyRedisDBInterceptor == null) {
            throw new NullPointerException("lazyRedisDBInterceptor is marked non-null but is null");
        }
        this.advice = lazyRedisDBInterceptor;
        this.pointcut = this.buildPointcut();
    }

    private Pointcut buildPointcut() {
        AnnotationMatchingPointcut cpc = new AnnotationMatchingPointcut(LazyRedis.class, true);
        AnnotationMatchingPointcut mpc = AnnotationMatchingPointcut.forMethodAnnotation(LazyRedis.class);
        return new ComposablePointcut((Pointcut)cpc).union((Pointcut)mpc);
    }

    public Pointcut getPointcut() {
        return this.pointcut;
    }

    public Advice getAdvice() {
        return this.advice;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
    }

    public static class LazyRedisDBInterceptor
    implements MethodInterceptor {
        private final LazyRedisTemplate lazyRedisTemplate;

        public LazyRedisDBInterceptor(LazyRedisTemplate lazyRedisTemplate) {
            this.lazyRedisTemplate = lazyRedisTemplate;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object invoke(MethodInvocation invocation) throws Throwable {
            LazyRedis lazyRedis = this.determineLazyRedis(invocation);
            this.lazyRedisTemplate.setDyDatabase(lazyRedis.database());
            try {
                Object object = invocation.proceed();
                return object;
            }
            finally {
                this.lazyRedisTemplate.reset();
            }
        }

        public LazyRedis determineLazyRedis(MethodInvocation invocation) {
            Method method = invocation.getMethod();
            Class<?> declaringClass = method.getDeclaringClass();
            LazyRedis lazyRedis = method.isAnnotationPresent(LazyRedis.class) ? method.getAnnotation(LazyRedis.class) : (LazyRedis)AnnotationUtils.findAnnotation(declaringClass, LazyRedis.class);
            return lazyRedis;
        }
    }
}

