/*
 * Decompiled with CFR 0.152.
 */
package com.wu.framework.inner.redis.component;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.data.redis.RedisProperties;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.RedisStandaloneConfiguration;
import org.springframework.data.redis.connection.lettuce.LettuceClientConfiguration;
import org.springframework.data.redis.connection.lettuce.LettuceConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;

@ConditionalOnProperty(prefix="spring.redis", value={"host"})
public class LazyRedisTemplate<K, V>
extends RedisTemplate<K, V> {
    private static final Logger log = LoggerFactory.getLogger(LazyRedisTemplate.class);
    private final Integer MASTER;
    private final RedisProperties redisProperties;
    protected Map<Integer, RedisConnectionFactory> redisConnectionFactoryMap = new ConcurrentHashMap<Integer, RedisConnectionFactory>(20);
    private Integer dyDatabase;

    public LazyRedisTemplate(RedisConnectionFactory redisConnectionFactory, RedisProperties redisProperties) {
        this.MASTER = redisProperties.getDatabase();
        this.redisProperties = redisProperties;
        this.dyDatabase = this.MASTER;
        this.redisConnectionFactoryMap.put(this.MASTER, redisConnectionFactory);
    }

    public RedisConnectionFactory getConnectionFactory() {
        int database = this.getDyDatabase();
        try {
            return this.getConnectionFactory(database);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.printf("\u65e0\u6cd5\u627e\u5230redis\u6570\u636e\u5e93 %s \u4f7f\u7528redis \u9ed8\u8ba4\u914d\u7f6e\u6570\u636e\u5e93%n", database);
            return this.getConnectionFactory(this.MASTER);
        }
    }

    public RedisConnectionFactory getConnectionFactory(int database) {
        if (this.redisConnectionFactoryMap.containsKey(database)) {
            return this.redisConnectionFactoryMap.get(database);
        }
        RedisStandaloneConfiguration redisConfiguration = new RedisStandaloneConfiguration(this.redisProperties.getHost(), this.redisProperties.getPort());
        redisConfiguration.setDatabase(database);
        redisConfiguration.setPassword(this.redisProperties.getPassword());
        LettuceClientConfiguration.LettuceClientConfigurationBuilder builder = LettuceClientConfiguration.builder();
        LettuceConnectionFactory lettuceConnectionFactory = new LettuceConnectionFactory(redisConfiguration, builder.build());
        lettuceConnectionFactory.afterPropertiesSet();
        this.redisConnectionFactoryMap.put(database, (RedisConnectionFactory)lettuceConnectionFactory);
        return lettuceConnectionFactory;
    }

    public Integer getDyDatabase() {
        return this.dyDatabase;
    }

    public void setDyDatabase(Integer dyDatabase) {
        this.dyDatabase = dyDatabase;
    }

    public void reset() {
        this.dyDatabase = this.MASTER;
    }
}

