package uk.num.modules.contacts.utils;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;

import java.io.IOException;

public class CustomStringSerializer extends StdSerializer<String> {

  public CustomStringSerializer() {
    this(null);
  }

  public CustomStringSerializer(Class<String> t) {
    super(t);
  }

  @Override
  public void serialize(String value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
    gen.writeString(sanitise(value));
  }

  public static String sanitise(String value) {
    if (value == null) {
      return null;
    }
    String result = value;

    // Replace start and end double quotes with back-tick quotes
    if (result.startsWith("\"")) {
      result = "`" + result.substring(1);
    }

    if (result.endsWith("\"")) {
      result = result.substring(0, result.length() - 1) + "`";
    }

    return result;
  }

}
