/*
 * Decompiled with CFR 0.152.
 */
package uy.klutter.elasticsearch;

import java.nio.file.Path;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.KotlinPackage;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinSyntheticClass;
import nl.komponents.kovenant.Deferred;
import nl.komponents.kovenant.KovenantPackage;
import nl.komponents.kovenant.Promise;
import nl.komponents.kovenant.functional.FunctionalPackage;
import org.elasticsearch.action.ActionRequestBuilder;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthStatus;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequestBuilder;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.node.Node;
import org.elasticsearch.node.NodeBuilder;
import org.jetbrains.annotations.NotNull;
import uy.klutter.elasticsearch.ElasticsearchPackage$Client$22314bdf;
import uy.klutter.elasticsearch.ElasticsearchPackage$Exceptions$eb243d86;
import uy.klutter.elasticsearch.ElasticsearchPackage$Kovenant$49a646fe;
import uy.klutter.elasticsearch.EsConfig;
import uy.klutter.elasticsearch.IndexTypeMapping;

@KotlinSyntheticClass(abiVersion=23, kind=KotlinSyntheticClass.Kind.PACKAGE_PART)
public final class ElasticsearchPackage$Client$22314bdf {
    @NotNull
    public static final Client esNodeClient(@JetValueParameter(name="clusterName") @NotNull String clusterName, @JetValueParameter(name="settings") @NotNull Map<String, ? extends String> settings) {
        Intrinsics.checkParameterIsNotNull((Object)clusterName, (String)"clusterName");
        Intrinsics.checkParameterIsNotNull(settings, (String)"settings");
        return ElasticsearchPackage$Client$22314bdf.esNodeClient(clusterName, (Function1<? super ImmutableSettings.Builder, ? extends Unit>)((Function1)new Function1<ImmutableSettings.Builder, Unit>(settings){
            final /* synthetic */ Map $settings;

            public final void invoke(@JetValueParameter(name="$receiver") ImmutableSettings.Builder $receiver) {
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                Iterable $receiver2 = this.$settings.entrySet();
                for (T element : $receiver2) {
                    Map.Entry it = (Map.Entry)element;
                    $receiver.put((String)it.getKey(), (String)it.getValue());
                }
            }
            {
                this.$settings = map;
                super(1);
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Client esNodeClient(@JetValueParameter(name="clusterName") @NotNull String clusterName, @JetValueParameter(name="init") @NotNull Function1<? super ImmutableSettings.Builder, ? extends Unit> init) {
        void var3_2;
        Intrinsics.checkParameterIsNotNull((Object)clusterName, (String)"clusterName");
        Intrinsics.checkParameterIsNotNull(init, (String)"init");
        ImmutableSettings.Builder $receiver = ImmutableSettings.settingsBuilder().put("cluster.name", clusterName).put("client.transport.sniff", false).put("node.name", "nodeClient-" + System.currentTimeMillis()).put("http.enabled", false).put("node.data", false).put("node.master", false);
        ImmutableSettings.Builder $receiver2 = $receiver;
        init.invoke((Object)$receiver2);
        Settings settings = ((ImmutableSettings.Builder)var3_2).build();
        Client client = NodeBuilder.nodeBuilder().settings(settings).node().client();
        Intrinsics.checkExpressionValueIsNotNull((Object)client, (String)"NodeBuilder.nodeBuilder(\u2026settings).node().client()");
        return client;
    }

    @NotNull
    public static final Client esTransportClient(@JetValueParameter(name="clusterName") @NotNull String clusterName, @JetValueParameter(name="nodes") @NotNull List<? extends TransportAddress> nodes, @JetValueParameter(name="settings") @NotNull Map<String, ? extends String> settings) {
        Intrinsics.checkParameterIsNotNull((Object)clusterName, (String)"clusterName");
        Intrinsics.checkParameterIsNotNull(nodes, (String)"nodes");
        Intrinsics.checkParameterIsNotNull(settings, (String)"settings");
        return ElasticsearchPackage$Client$22314bdf.esTransportClient(clusterName, nodes, (Function1<? super ImmutableSettings.Builder, ? extends Unit>)((Function1)new Function1<ImmutableSettings.Builder, Unit>(settings){
            final /* synthetic */ Map $settings;

            public final void invoke(@JetValueParameter(name="$receiver") ImmutableSettings.Builder $receiver) {
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                Iterable $receiver2 = this.$settings.entrySet();
                for (T element : $receiver2) {
                    Map.Entry it = (Map.Entry)element;
                    $receiver.put((String)it.getKey(), (String)it.getValue());
                }
            }
            {
                this.$settings = map;
                super(1);
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Client esTransportClient(@JetValueParameter(name="clusterName") @NotNull String clusterName, @JetValueParameter(name="nodes") @NotNull List<? extends TransportAddress> nodes, @JetValueParameter(name="init") @NotNull Function1<? super ImmutableSettings.Builder, ? extends Unit> init) {
        void $receiver;
        Intrinsics.checkParameterIsNotNull((Object)clusterName, (String)"clusterName");
        Intrinsics.checkParameterIsNotNull(nodes, (String)"nodes");
        Intrinsics.checkParameterIsNotNull(init, (String)"init");
        ImmutableSettings.Builder builder = ImmutableSettings.settingsBuilder().put("cluster.name", clusterName).put("client.transport.sniff", false);
        Object $receiver2 = (ImmutableSettings.Builder)$receiver;
        init.invoke($receiver2);
        Settings settings = ((ImmutableSettings.Builder)$receiver).build();
        TransportClient client = new TransportClient(settings);
        $receiver2 = nodes;
        Iterator iterator = $receiver2.iterator();
        while (iterator.hasNext()) {
            Object element = iterator.next();
            TransportAddress it = (TransportAddress)element;
            client.addTransportAddress(it);
        }
        Client client2 = NodeBuilder.nodeBuilder().settings(settings).node().client();
        Intrinsics.checkExpressionValueIsNotNull((Object)client2, (String)"NodeBuilder.nodeBuilder(\u2026settings).node().client()");
        return client2;
    }

    @NotNull
    public static final Promise<Client, Exception> esEmbeddedClient(@JetValueParameter(name="clusterName") @NotNull String clusterName, @JetValueParameter(name="baseDir") @NotNull Path baseDir, @JetValueParameter(name="settings") @NotNull Map<String, ? extends String> settings) {
        Intrinsics.checkParameterIsNotNull((Object)clusterName, (String)"clusterName");
        Intrinsics.checkParameterIsNotNull((Object)baseDir, (String)"baseDir");
        Intrinsics.checkParameterIsNotNull(settings, (String)"settings");
        return ElasticsearchPackage$Client$22314bdf.esEmbeddedClient(clusterName, baseDir, (Function1<? super ImmutableSettings.Builder, ? extends Unit>)((Function1)new Function1<ImmutableSettings.Builder, Unit>(settings){
            final /* synthetic */ Map $settings;

            public final void invoke(@JetValueParameter(name="$receiver") ImmutableSettings.Builder $receiver) {
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                Iterable $receiver2 = this.$settings.entrySet();
                for (T element : $receiver2) {
                    Map.Entry it = (Map.Entry)element;
                    $receiver.put((String)it.getKey(), (String)it.getValue());
                }
            }
            {
                this.$settings = map;
                super(1);
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Promise<Client, Exception> esEmbeddedClient(@JetValueParameter(name="clusterName") @NotNull String clusterName, @JetValueParameter(name="baseDir") @NotNull Path baseDir, @JetValueParameter(name="init") @NotNull Function1<? super ImmutableSettings.Builder, ? extends Unit> init) {
        Intrinsics.checkParameterIsNotNull((Object)clusterName, (String)"clusterName");
        Intrinsics.checkParameterIsNotNull((Object)baseDir, (String)"baseDir");
        Intrinsics.checkParameterIsNotNull(init, (String)"init");
        Deferred deferred = KovenantPackage.deferred$default(null, (int)1);
        try {
            void $receiver;
            Path esRoot = baseDir.toAbsolutePath();
            ImmutableSettings.Builder builder = ImmutableSettings.settingsBuilder().put("path.data", esRoot + "/data").put("path.work", esRoot + "/work").put("path.logs", esRoot + "/logs").put("http.enabled", false).put("index.number_of_shards", "2").put("index.number_of_replicas", "0").put("cluster.routing.schedule", "50ms").put("cluster.name", clusterName).put("client.transport.sniff", false).put("node.name", "nodeEmbedded-" + System.currentTimeMillis()).put("node.data", true).put("cluster.routing.allocation.disk.threshold_enabled", true).put("cluster.routing.allocation.disk.watermark.low", "10gb");
            ImmutableSettings.Builder $receiver2 = (ImmutableSettings.Builder)$receiver;
            init.invoke((Object)$receiver2);
            Settings settings = ((ImmutableSettings.Builder)$receiver).build();
            Node tempNode = NodeBuilder.nodeBuilder().local(true).data(true).settings(settings).node();
            Client tempClient = tempNode.client();
            return FunctionalPackage.bind(ElasticsearchPackage$Client$22314bdf.waitForYellowCluster(tempClient), (Function1)((Function1)new Function1<ClusterHealthStatus, Promise<Client, Exception>>(deferred){
                final /* synthetic */ Deferred $deferred;

                @NotNull
                public final Promise<Client, Exception> invoke(@JetValueParameter(name="it") @NotNull ClusterHealthStatus it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    return this.$deferred.getPromise();
                }
                {
                    this.$deferred = deferred;
                    super(1);
                }
            }));
        }
        catch (Throwable ex) {
            deferred.reject((Object)ElasticsearchPackage$Exceptions$eb243d86.wrapThrowable(ex));
            return deferred.getPromise();
        }
    }

    @NotNull
    public static final Promise<ClusterHealthStatus, Exception> waitForGreenCluster(@JetValueParameter(name="$receiver") Client $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return ElasticsearchPackage$Kovenant$49a646fe.promise((ActionRequestBuilder)$receiver.admin().cluster().prepareHealth(new String[0]).setWaitForGreenStatus().setTimeout(TimeValue.timeValueSeconds((long)EsConfig.INSTANCE$.getAdminActionTimeoutInSeconds())), waitForGreenCluster.1.INSTANCE$);
    }

    @NotNull
    public static final Promise<ClusterHealthStatus, Exception> waitForYellowCluster(@JetValueParameter(name="$receiver") Client $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return ElasticsearchPackage$Kovenant$49a646fe.promise((ActionRequestBuilder)$receiver.admin().cluster().prepareHealth(new String[0]).setWaitForYellowStatus().setTimeout(TimeValue.timeValueSeconds((long)EsConfig.INSTANCE$.getAdminActionTimeoutInSeconds())), waitForYellowCluster.1.INSTANCE$);
    }

    @NotNull
    public static final Promise<ClusterHealthStatus, Exception> waitForGreenIndex(@JetValueParameter(name="$receiver") Client $receiver, String ... indices) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)indices, (String)"indices");
        return ElasticsearchPackage$Kovenant$49a646fe.promise((ActionRequestBuilder)$receiver.admin().cluster().prepareHealth(indices).setWaitForGreenStatus().setTimeout(TimeValue.timeValueSeconds((long)EsConfig.INSTANCE$.getAdminActionTimeoutInSeconds())), waitForGreenIndex.1.INSTANCE$);
    }

    @NotNull
    public static final Promise<ClusterHealthStatus, Exception> waitForYellowIndex(@JetValueParameter(name="$receiver") Client $receiver, String ... indices) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)indices, (String)"indices");
        return ElasticsearchPackage$Kovenant$49a646fe.promise((ActionRequestBuilder)$receiver.admin().cluster().prepareHealth(indices).setWaitForYellowStatus().setTimeout(TimeValue.timeValueSeconds((long)EsConfig.INSTANCE$.getAdminActionTimeoutInSeconds())), waitForYellowIndex.1.INSTANCE$);
    }

    @NotNull
    public static final Promise<Boolean, Exception> indexExists(@JetValueParameter(name="$receiver") Client $receiver, String ... indices) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)indices, (String)"indices");
        return ElasticsearchPackage$Kovenant$49a646fe.promise((ActionRequestBuilder)$receiver.admin().indices().prepareExists(indices), indexExists.1.INSTANCE$);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Promise<Unit, Exception> createIndex(@JetValueParameter(name="$receiver") Client $receiver, @JetValueParameter(name="index") @NotNull String index, @JetValueParameter(name="mappings") @NotNull List<? extends IndexTypeMapping> mappings2, @JetValueParameter(name="shardCount") int shardCount, @JetValueParameter(name="replicaCount") int replicaCount, @JetValueParameter(name="settingsInit") @NotNull Function1<? super ImmutableSettings.Builder, ? extends Unit> settingsInit) {
        void $receiver2;
        CreateIndexRequestBuilder $receiver3;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)index, (String)"index");
        Intrinsics.checkParameterIsNotNull(mappings2, (String)"mappings");
        Intrinsics.checkParameterIsNotNull(settingsInit, (String)"settingsInit");
        ImmutableSettings.Builder builder = ImmutableSettings.settingsBuilder().put("number_of_shards", shardCount).put("number_of_replicas", replicaCount);
        ImmutableSettings.Builder $receiver4 = (ImmutableSettings.Builder)$receiver3;
        settingsInit.invoke((Object)$receiver4);
        Settings indexSettings = ((ImmutableSettings.Builder)$receiver3).build();
        $receiver3 = $receiver.admin().indices().prepareCreate(index).setSettings(indexSettings);
        $receiver4 = $receiver3;
        Iterable iterable = mappings2;
        for (Object element : $receiver2) {
            IndexTypeMapping it = (IndexTypeMapping)element;
            $receiver4.addMapping(it.getType(), it.getJson());
        }
        return ElasticsearchPackage$Kovenant$49a646fe.promiseNothing((ActionRequestBuilder)$receiver3);
    }

    @NotNull
    public static /* synthetic */ Promise createIndex$default(Client client, String string, List list, int n, int n2, Function1 function1, int n3) {
        if ((n3 & 4) != 0) {
            n = EsConfig.INSTANCE$.getIndexShardCount();
        }
        if ((n3 & 8) != 0) {
            n2 = EsConfig.INSTANCE$.getIndexReplicaCount();
        }
        if ((n3 & 0x10) != 0) {
            function1 = createIndex.1.INSTANCE$;
        }
        return ElasticsearchPackage$Client$22314bdf.createIndex(client, string, list, n, n2, (Function1<? super ImmutableSettings.Builder, ? extends Unit>)function1);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Promise<List<? extends Boolean>, Exception> updateIndexMappings(@JetValueParameter(name="$receiver") Client $receiver, @JetValueParameter(name="index") @NotNull String index, @JetValueParameter(name="mappings") @NotNull List<? extends IndexTypeMapping> mappings2) {
        void $receiver2;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)index, (String)"index");
        Intrinsics.checkParameterIsNotNull(mappings2, (String)"mappings");
        LinkedList actions = KotlinPackage.linkedListOf((Object[])new Promise[0]);
        Iterable iterable = mappings2;
        for (Object element : $receiver2) {
            IndexTypeMapping it = (IndexTypeMapping)element;
            actions.add(ElasticsearchPackage$Kovenant$49a646fe.promise((ActionRequestBuilder)$receiver.admin().indices().preparePutMapping(new String[]{index}).setType(it.getType()).setSource(it.getJson()), updateIndexMappings.1.1.INSTANCE$));
        }
        return KovenantPackage.all$default((List)actions, null, (boolean)false, (int)6);
    }
}

