/*
 * Decompiled with CFR 0.152.
 */
package uy.klutter.elasticsearch;

import java.nio.file.Path;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kotlin.KotlinPackage;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import nl.komponents.kovenant.Bulk_apiKt;
import nl.komponents.kovenant.Deferred;
import nl.komponents.kovenant.Promise;
import nl.komponents.kovenant.Promises_apiKt;
import nl.komponents.kovenant.functional.MoniadicKt;
import org.elasticsearch.action.ActionRequestBuilder;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthStatus;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequestBuilder;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.node.Node;
import org.elasticsearch.node.NodeBuilder;
import org.jetbrains.annotations.NotNull;
import uy.klutter.elasticsearch.ClientKt;
import uy.klutter.elasticsearch.EsConfig;
import uy.klutter.elasticsearch.ExceptionsKt;
import uy.klutter.elasticsearch.IndexTypeMapping;
import uy.klutter.elasticsearch.KovenantKt;

@KotlinFileFacade(version={0, 25, 0}, abiVersion=25, data={"\u0014\f)\u0001Rm]#nE\u0016$G-\u001a3DY&,g\u000e\u001e\u0006\fG2,8\u000f^3s\u001d\u0006lWM\u0003\u0004TiJLgn\u001a\u0006\u0007W>$H.\u001b8\u000b\u000f\t\f7/\u001a#je*!\u0001+\u0019;i\u0015\u0011Q\u0017M^1\u000b\u00079LwN\u0003\u0003gS2,'\u0002C:fiRLgnZ:\u000b\u00075\u000b\u0007OC\u0004Qe>l\u0017n]3\u000b\u00059d'BC6p[B|g.\u001a8ug*A1n\u001c<f]\u0006tGO\u0003\u0004DY&,g\u000e\u001e\u0006\u0004_J<'\"D3mCN$\u0018nY:fCJ\u001c\u0007N\u0003\u0004dY&,g\u000e\u001e\u0006\n\u000bb\u001cW\r\u001d;j_:TA\u0001\\1oO*!Q\u000f^5m\u0015!\u0019E.[3oi.#(\u0002B5oSRT\u0011BR;oGRLwN\\\u0019\u000b\u000f\t+\u0018\u000e\u001c3fe*\t\u0012*\\7vi\u0006\u0014G.Z*fiRLgnZ:\u000b\r\r|W.\\8o\u0015\u0011)f.\u001b;\u000b\u0013\u0015CH/\u001a8tS>t'b\u00016w[*Ia-\u001e8di&|gn\u001d\u0006\rKNtu\u000eZ3DY&,g\u000e\u001e\u0006\u0012KN$&/\u00198ta>\u0014Ho\u00117jK:$(\"\u00028pI\u0016\u001c(\u0002\u0002'jgRT\u0001\u0003\u0016:b]N\u0004xN\u001d;BI\u0012\u0014Xm]:\u000b\u0013Q\u0014\u0018M\\:q_J$(bC2sK\u0006$X-\u00138eKbTQ!\u001b8eKbT\u0001\"\\1qa&twm\u001d\u0006\u0011\u0013:$W\r\u001f+za\u0016l\u0015\r\u001d9j]\u001eT!!^=\u000b\u000f-dW\u000f\u001e;fe*Q1\u000f[1sI\u000e{WO\u001c;\u000b\u0007%sGO\u0003\u0007sKBd\u0017nY1D_VtGO\u0003\u0007tKR$\u0018N\\4t\u0013:LGOC\u0006j]\u0012,\u00070\u0012=jgR\u001c(bB5oI&\u001cWm\u001d\u0006\u0006\u0003J\u0014\u0018-\u001f\u0006\b\u0005>|G.Z1o\u0015M)\b\u000fZ1uK&sG-\u001a=NCB\u0004\u0018N\\4t\u0015M9\u0018-\u001b;G_J<%/Z3o\u00072,8\u000f^3s\u0015M\u0019E.^:uKJDU-\u00197uQN#\u0018\r^;t\u0015\u0019\t7\r^5p]*)\u0011\rZ7j]*91\r\\;ti\u0016\u0014(B\u00025fC2$\bNC\txC&$hi\u001c:He\u0016,g.\u00138eKbTAc^1ji\u001a{'/W3mY><8\t\\;ti\u0016\u0014(BE<bSR4uN]-fY2|w/\u00138eKb\u0004-A\u0003\u0002\u0011\u0007)1\u0001\u0002\u0001\t\u00031\u0001Q!\u0001\u0005\u0004\u000b\t!\u0011\u0001c\u0002\u0006\u0005\u0011\r\u0001\u0002B\u0003\u0004\t\tA)\u0001\u0004\u0001\u0006\u0007\u0011\u0001\u0001\"\u0002\u0007\u0001\u000b\u0005Aa!\u0002\u0002\u0005\b!5QA\u0001\u0003\u0005\u0011\u001d)1\u0001\"\u0003\t\f1\u0001Q!\u0001\u0005\t\u000b\t!Y\u0001#\u0005\u0006\u0005\u00111\u0001\"C\u0003\u0004\t\u001bAy\u0001\u0004\u0001\u0006\u0005\u0011\t\u0001BC\u0003\u0004\t\u001fA\u0019\u0002\u0004\u0001\u0006\u0005\u0011%\u00012B\u0003\u0003\t\u001fA\u0011!\u0002\u0002\u0005\u0005!\u0015QA\u0001\u0003\u0002\u0011+)!\u0001\u0002\u0006\t\u000b\u0015\u0019A\u0001\u0001\u0005\r\u0019\u0001)!\u0001\u0002\u0004\t\u001c\u0015\u0011Aq\u0003E\u0005\u000b\r!A\u0002C\u0007\r\u0001\u0015\u0019A\u0011\u0004E\r\u0019\u0001)1\u0001\u0002\u0001\t\u001d1\u0001Qa\u0001\u0003\u0001\u0011;a\u0001!\u0002\u0002\u0005\u0001!yQA\u0001C\u000f\u0011?)!\u0001B\b\t\u0019\u0015\u0011AQ\u0002E\b\u000b\r!\u0001\u0001c\t\r\u0001\u0015\u0011Aq\u0003E\u0013\u000b\r!\u0011\u0003\u0003\n\r\u0001\u0015\u0011AA\u0003E\u0012\u000b\u0005AQ#\u0002\u0002\u0005&!-RA\u0001\u0003\u0014\u0011#)1\u0001b\n\t*1\u0001Qa\u0001\u0003\u0001\u0011[a\u0001!B\u0002\u0005\u0001!IB\u0002A\u0003\u0004\t\u0001A\u0019\u0004\u0004\u0001\u0006\u0005\u00111\u0001rG\u0003\u0003\tYAA$\u0002\u0002\u0005.!eRA\u0001\u0003\u0018\u0011u)1\u0001b\f\t71\u0001Qq\u0010\u0003\u00041\u0001iz\u0001\u0002\u0001\t\u00025\u0019Q!\u0001E\u00011\u0003\u00016\u0001AO\b\t\u0001A!!D\u0002\u0006\u0003!\u0015\u0001T\u0001)\u0004\u0002u\rB\u0001\u0001E\u0005\u001b5)\u0011\u0001C\u0002\n\t%\u0019Q!\u0001E\u00011\u0003IA!C\u0002\u0006\u0003!\u0005\u0001\u0014\u0001\r\u0004!\u000e\t\u0011%D\u0003\u0002\u0011\u0015IA!C\u0002\u0006\u0003!9\u0001dB\u0005\u0005\u0013\r)\u0011\u0001\u0003\u0005\u0019\u0011a)\u0011kA\u0005\u0005\u0001%\t\u0001\u0012C\u0007\u0002\u0011%i\u0011\u0001c\u0005\u000e\u0003!U\u0001lA\u0006\u0006\u0005\u0004!1\u0001\u0007\u0001\u001e\u0010\u0011\u0001\u0001\u0012A\u0007\u0004\u000b\u0005A\t\u0001'\u0001Q\u0007\u0001iz\u0001\u0002\u0001\t\u00055\u0019Q!\u0001E\u00031\u000b\u00016\u0011A\u000f\u0015\t\u0001A9\"d\b\u0006\u0003!Y\u0011\u0002B\u0005\u0004\u000b\u0005AQ\u0002G\u0007\n\t%\u0019Q!\u0001E\u000e17A2\"U\u0002\u0002\t9\u00016!A\u0011\u000e\u000b\u0005AQ!\u0003\u0003\n\u0007\u0015\t\u0001b\u0002\r\b\u0013\u0011I1!B\u0001\t\u0011aA\u0001$B)\u0004\u0013\u0011\u0001\u0011\"\u0001E\t\u001b\u0005A\u0011\"D\u0001\t\u00145\t\u0001r\u0004-\u0004\u0017\u0015YCa\u0001\r\u0011;\u001f!\u0001\u0001#\u0001\u000e\u0007\u0015\t\u0001\u0012\u0001M\u0001!\u000e\u0001Q4\u0005\u0003\u0001\u0011\u0013iQ\"B\u0001\t\u0007%!\u0011bA\u0003\u0002\u0011\u0003A\n!\u0003\u0003\n\u0007\u0015\t\u0001\u0012\u0001M\u00011\r\u00016\u0011A\u0011\u0004\u000b\u0005Aq\u0001G\u0004R\u0007\u001d!\u0001#C\u0001\t!5\t\u0001\"C\u0007\u0002\u0011+A6aCC.\t\rA\u0002#h\u0004\u0005\u0001!\u0005QbA\u0003\u0002\u0011\u0003A\n\u0001U\u0002\u0001;Q!\u0001\u0001c\u0006\u000e \u0015\t\u0001bC\u0005\u0005\u0013\r)\u0011\u0001C\u0007\u0019\u001b%!\u0011bA\u0003\u0002\u00117AZ\u0002G\u0006R\u0007\u0005!a\u0002UB\u0001C\r)\u0011\u0001C\u0004\u0019\u000fE\u001bq\u0001\u0002\t\n\u0003!\u0001R\"\u0001\u0005\n\u001b\u0005Ay\u0002W\u0002\f\u000bk\"1\u0001'\t\u001e\u0010\u0011\u0001\u0001\u0012A\u0007\u0004\u000b\u0005A\t\u0001'\u0001Q\u0007\u0001iJ\u0002\u0002\u0001\t#5AQ!\u0001E\u0011\u0013\u0011I1!B\u0001\t$a\r\u0002\u0014\u0005)\u0004\u0002u\rB\u0001\u0001E\u0005\u001b5)\u0011\u0001C\u0002\n\t%\u0019Q!\u0001E\u00011\u0003IA!C\u0002\u0006\u0003!\u0005\u0001\u0014\u0001\r\u0004!\u000e\t\u0011eA\u0003\u0002\u0011\u001dAr!U\u0002\n\tCI\u0011\u0001\u0003\t\u000e\u0003!IQ\"\u0001\u0005\u0013\u001b\u0005A)\u0002W\u0002\f\u000bu\"1\u0001'\t\u001e\u0010\u0011\u0001\u0001\u0012A\u0007\u0004\u000b\u0005A\t\u0001'\u0001Q\u0007\u0001iJ\u0002\u0002\u0001\t#5AQ!\u0001E\u0011\u0013\u0011I1!B\u0001\t$a\r\u0002\u0014\u0005)\u0004\u0002u!B\u0001\u0001E\f\u001b?)\u0011\u0001C\u0006\n\t%\u0019Q!\u0001\u0005\u000e15IA!C\u0002\u0006\u0003!m\u00014\u0004\r\f#\u000e\tAA\u0004)\u0004\u0003\u0005\u001aQ!\u0001\u0005\b1\u001d\t6!\u0003C\u0011\u0013\u0005A\u0001#D\u0001\t\u00135\t\u0001BE\u0007\u0002\u0011?A6aC\u0003c\u0002\u0011\u0019QcA\u0003\u0002\u0011\u001dAr\u0001G\n\u001e\u0010\u0011\u0001\u0001rE\u0007\u0004\u000b\u0005A\t\u0001'\u0001Q\u0007\u0003iJ\u0002\u0002\u0001\t)5AQ!\u0001E\u0011\u0013\u0011I1!B\u0001\t)a!\u0002\u0014\u0005)\u0004\u0003u=A!\u0001\u0005\u0017\u001b\r)\u0011\u0001#\u000b\u0019*A\u001b\u0019!h\u0004\u0005\u0003!9RbA\u0003\u0002\u0011SAJ\u0003U\u0002\u0003;Q!\u0011\u0001c\f\u000e \u0015\t\u0001bC\u0005\u0005\u0013\r)\u0011\u0001C\u0007\u0019\u001b%!\u0011bA\u0003\u0002\u00117AZ\u0002G\u0006R\u0007\u0005!a\u0002UB\u0003C5)\u0011\u0001C\u0003\n\t%\u0019Q!\u0001E\u000e17IA!C\u0002\u0006\u0003!A\u0001\u0004\u0003\r\u0006#\u000eyAaE\u0005\u0002\u0011#i\u0011\u0001\u0003\t\u000e\u0003!IQ\"\u0001\u0005\u0013\u001b\u0005!)!D\u0001\u0005\u00065\t\u0001r\u0004-\u0004\u0017\u0015\rDaA\u000b\u0004\u000b\u0005Aq\u0001G\u0004\u00191u\rB\u0001\u0001E\u0019\u001b%)\u0011\u0001C\u000b\n\u000b\u0011\u0005\u0011bA\u0003\u0002\u0011\u0003A\n\u0001G\u000b\u0012\u0007\u0015\t\u0001\u0012\u0001M\u0001!\u000e\u0005\u0011%D\u0003\u0002\u0011\u0015IA!C\u0002\u0006\u0003!-\u00024F\u0005\u0005\u0013\r)\u0011\u0001\u0003\u0005\u0019\u0011a)\u0011k\u0001\u0005\u00051%\t\u0001\u0012C\u0007\u0002\u0011Ai!\u0001C\u0005\r\u0002a\u001b1\"B\u001e\u0005\u0007U\u0019Q!\u0001\u0005\b1\u001dA\"$h\u0004\u0005\u0001!\u001dRbA\u0003\u0002\u0011\u0003A\n\u0001UB\u0001;3!\u0001\u0001\u0003\u000b\u000e\u0011\u0015\t\u0001\u0012E\u0005\u0005\u0013\r)\u0011\u0001\u0003\u000b\u0019)a\u0005\u0002kA\u0001\"%\u0015\t\u0001\"B\u0005\n\u0013!)\u0011\u0001#\t\n\t%\u0019Q!\u0001E\u00161WA\n#\u0003\u0003\n\u0007\u0015\t\u0001\u0002\u0003\r\t1\u0015\t6!\u0003\u0003\u001b\u0013\u0005A\t\"D\u0001\t!5\t\u0001\"C\u0007\u0002\u0011IA6aC\u0003\u001d\t\r)2!B\u0001\t\u000fa9\u0001TG\u0011\u000e\u000b\u0005AQ!\u0003\u0003\n\u0007\u0015\t\u0001\u0002\u0007\r\u0019\u0013\u0011I1!B\u0001\t\u0011aA\u0001$B)\u0004\u000b\u0011U\u0012\"\u0001E\t\u001b\u0005A\u0001\u0003W\u0002\f\u000bG\"1!F\u0002\u0006\u0003!9\u0001d\u0002M\u001e;G!\u0001\u0001#\r\u000e\u0013\u0015\t\u0001\"F\u0005\u0006\t\u0003I1!B\u0001\t\u0002a\u0005\u0001$F\t\u0004\u000b\u0005A\t\u0001'\u0001Q\u0007\u0003\tS\"B\u0001\t\u000b%!\u0011bA\u0003\u0002\u0011aA\u0002$\u0003\u0003\n\u0007\u0015\t\u0001\u0002\u0003\r\t1\u0015\t6\u0001\u0003C\u001e\u0013\u0005A\t\"D\u0001\t!5\u0011\u0001\"\u0003G\u00011\u000eYQ\u0001\b\u0003\u0004+\r)\u0011\u0001C\u0004\u0019\u000faq\u0012%D\u0003\u0002\u0011\u0015IA!C\u0002\u0006\u0003!A\u0002\u0004G\u0005\u0005\u0013\r)\u0011\u0001\u0003\u0005\u0019\u0011a)\u0011kA\u0003\u0005=%\t\u0001\u0012C\u0007\u0002\u0011AA6aCC2\t\r)2!B\u0001\t\u000fa9\u0001THO\u0012\t\u0001A\t$D\u0005\u0006\u0003!)\u0012\"\u0002C\u0001\u0013\r)\u0011\u0001#\u0001\u0019\u0002a)\u0012cA\u0003\u0002\u0011\u0003A\n\u0001UB\u0001C5)\u0011\u0001C\u0003\n\t%\u0019Q!\u0001\u0005\u00191aIA!C\u0002\u0006\u0003!A\u0001\u0004\u0003\r\u0006#\u000eAAQH\u0005\u0002\u0011#i\u0011\u0001\u0003\t\u000e\u0005!IA\u0012\u0001-\u0004\u0017\u0001"})
public final class ClientKt {
    @NotNull
    public static final Client esNodeClient(@NotNull String clusterName, @NotNull Map<String, ? extends String> settings) {
        Intrinsics.checkParameterIsNotNull((Object)clusterName, (String)"clusterName");
        Intrinsics.checkParameterIsNotNull(settings, (String)"settings");
        return ClientKt.esNodeClient(clusterName, (Function1<? super ImmutableSettings.Builder, ? extends Unit>)((Function1)new Function1<ImmutableSettings.Builder, Unit>(settings){
            final /* synthetic */ Map $settings;

            public final void invoke(ImmutableSettings.Builder $receiver) {
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                Iterable $receiver2 = this.$settings.entrySet();
                for (T element : $receiver2) {
                    Map.Entry it = (Map.Entry)element;
                    $receiver.put((String)it.getKey(), (String)it.getValue());
                }
            }
            {
                this.$settings = map;
                super(1);
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Client esNodeClient(@NotNull String clusterName, @NotNull Function1<? super ImmutableSettings.Builder, ? extends Unit> init) {
        void var3_2;
        Intrinsics.checkParameterIsNotNull((Object)clusterName, (String)"clusterName");
        Intrinsics.checkParameterIsNotNull(init, (String)"init");
        ImmutableSettings.Builder $receiver = ImmutableSettings.settingsBuilder().put("cluster.name", clusterName).put("client.transport.sniff", false).put("node.name", "nodeClient-" + System.currentTimeMillis()).put("http.enabled", false).put("node.data", false).put("node.master", false);
        ImmutableSettings.Builder $receiver2 = $receiver;
        init.invoke((Object)$receiver2);
        Settings settings = ((ImmutableSettings.Builder)var3_2).build();
        Client client = NodeBuilder.nodeBuilder().settings(settings).node().client();
        Intrinsics.checkExpressionValueIsNotNull((Object)client, (String)"NodeBuilder.nodeBuilder(\u2026settings).node().client()");
        return client;
    }

    @NotNull
    public static final Client esTransportClient(@NotNull String clusterName, @NotNull List<? extends TransportAddress> nodes, @NotNull Map<String, ? extends String> settings) {
        Intrinsics.checkParameterIsNotNull((Object)clusterName, (String)"clusterName");
        Intrinsics.checkParameterIsNotNull(nodes, (String)"nodes");
        Intrinsics.checkParameterIsNotNull(settings, (String)"settings");
        return ClientKt.esTransportClient(clusterName, nodes, (Function1<? super ImmutableSettings.Builder, ? extends Unit>)((Function1)new Function1<ImmutableSettings.Builder, Unit>(settings){
            final /* synthetic */ Map $settings;

            public final void invoke(ImmutableSettings.Builder $receiver) {
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                Iterable $receiver2 = this.$settings.entrySet();
                for (T element : $receiver2) {
                    Map.Entry it = (Map.Entry)element;
                    $receiver.put((String)it.getKey(), (String)it.getValue());
                }
            }
            {
                this.$settings = map;
                super(1);
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Client esTransportClient(@NotNull String clusterName, @NotNull List<? extends TransportAddress> nodes, @NotNull Function1<? super ImmutableSettings.Builder, ? extends Unit> init) {
        void $receiver;
        Intrinsics.checkParameterIsNotNull((Object)clusterName, (String)"clusterName");
        Intrinsics.checkParameterIsNotNull(nodes, (String)"nodes");
        Intrinsics.checkParameterIsNotNull(init, (String)"init");
        ImmutableSettings.Builder builder = ImmutableSettings.settingsBuilder().put("cluster.name", clusterName).put("client.transport.sniff", false);
        Object $receiver2 = (ImmutableSettings.Builder)$receiver;
        init.invoke($receiver2);
        Settings settings = ((ImmutableSettings.Builder)$receiver).build();
        TransportClient client = new TransportClient(settings);
        $receiver2 = nodes;
        Iterator iterator = $receiver2.iterator();
        while (iterator.hasNext()) {
            Object element = iterator.next();
            TransportAddress it = (TransportAddress)element;
            client.addTransportAddress(it);
        }
        Client client2 = NodeBuilder.nodeBuilder().settings(settings).node().client();
        Intrinsics.checkExpressionValueIsNotNull((Object)client2, (String)"NodeBuilder.nodeBuilder(\u2026settings).node().client()");
        return client2;
    }

    @NotNull
    public static final Promise<Client, Exception> esEmbeddedClient(@NotNull String clusterName, @NotNull Path baseDir, @NotNull Map<String, ? extends String> settings) {
        Intrinsics.checkParameterIsNotNull((Object)clusterName, (String)"clusterName");
        Intrinsics.checkParameterIsNotNull((Object)baseDir, (String)"baseDir");
        Intrinsics.checkParameterIsNotNull(settings, (String)"settings");
        return ClientKt.esEmbeddedClient(clusterName, baseDir, (Function1<? super ImmutableSettings.Builder, ? extends Unit>)((Function1)new Function1<ImmutableSettings.Builder, Unit>(settings){
            final /* synthetic */ Map $settings;

            public final void invoke(ImmutableSettings.Builder $receiver) {
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                Iterable $receiver2 = this.$settings.entrySet();
                for (T element : $receiver2) {
                    Map.Entry it = (Map.Entry)element;
                    $receiver.put((String)it.getKey(), (String)it.getValue());
                }
            }
            {
                this.$settings = map;
                super(1);
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Promise<Client, Exception> esEmbeddedClient(@NotNull String clusterName, @NotNull Path baseDir, @NotNull Function1<? super ImmutableSettings.Builder, ? extends Unit> init) {
        Intrinsics.checkParameterIsNotNull((Object)clusterName, (String)"clusterName");
        Intrinsics.checkParameterIsNotNull((Object)baseDir, (String)"baseDir");
        Intrinsics.checkParameterIsNotNull(init, (String)"init");
        Deferred deferred = Promises_apiKt.deferred$default(null, (int)1);
        try {
            void $receiver;
            Path esRoot = baseDir.toAbsolutePath();
            ImmutableSettings.Builder builder = ImmutableSettings.settingsBuilder().put("path.data", esRoot + "/data").put("path.work", esRoot + "/work").put("path.logs", esRoot + "/logs").put("http.enabled", false).put("index.number_of_shards", "2").put("index.number_of_replicas", "0").put("cluster.routing.schedule", "50ms").put("cluster.name", clusterName).put("client.transport.sniff", false).put("node.name", "nodeEmbedded-" + System.currentTimeMillis()).put("node.data", true).put("cluster.routing.allocation.disk.threshold_enabled", true).put("cluster.routing.allocation.disk.watermark.low", "10gb");
            ImmutableSettings.Builder $receiver2 = (ImmutableSettings.Builder)$receiver;
            init.invoke((Object)$receiver2);
            Settings settings = ((ImmutableSettings.Builder)$receiver).build();
            Node tempNode = NodeBuilder.nodeBuilder().local(true).data(true).settings(settings).node();
            Client tempClient = tempNode.client();
            return MoniadicKt.bind(ClientKt.waitForYellowCluster(tempClient), (Function1)((Function1)new Function1<ClusterHealthStatus, Promise<Client, Exception>>(deferred){
                final /* synthetic */ Deferred $deferred;

                @NotNull
                public final Promise<Client, Exception> invoke(@NotNull ClusterHealthStatus it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    return this.$deferred.getPromise();
                }
                {
                    this.$deferred = deferred;
                    super(1);
                }
            }));
        }
        catch (Throwable ex) {
            deferred.reject((Object)ExceptionsKt.wrapThrowable(ex));
            return deferred.getPromise();
        }
    }

    @NotNull
    public static final Promise<ClusterHealthStatus, Exception> waitForGreenCluster(Client $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return KovenantKt.promise((ActionRequestBuilder)$receiver.admin().cluster().prepareHealth(new String[0]).setWaitForGreenStatus().setTimeout(TimeValue.timeValueSeconds((long)EsConfig.INSTANCE$.getAdminActionTimeoutInSeconds())), waitForGreenCluster.1.INSTANCE$);
    }

    @NotNull
    public static final Promise<ClusterHealthStatus, Exception> waitForYellowCluster(Client $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return KovenantKt.promise((ActionRequestBuilder)$receiver.admin().cluster().prepareHealth(new String[0]).setWaitForYellowStatus().setTimeout(TimeValue.timeValueSeconds((long)EsConfig.INSTANCE$.getAdminActionTimeoutInSeconds())), waitForYellowCluster.1.INSTANCE$);
    }

    @NotNull
    public static final Promise<ClusterHealthStatus, Exception> waitForGreenIndex(Client $receiver, String ... indices) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)indices, (String)"indices");
        return KovenantKt.promise((ActionRequestBuilder)$receiver.admin().cluster().prepareHealth(indices).setWaitForGreenStatus().setTimeout(TimeValue.timeValueSeconds((long)EsConfig.INSTANCE$.getAdminActionTimeoutInSeconds())), waitForGreenIndex.1.INSTANCE$);
    }

    @NotNull
    public static final Promise<ClusterHealthStatus, Exception> waitForYellowIndex(Client $receiver, String ... indices) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)indices, (String)"indices");
        return KovenantKt.promise((ActionRequestBuilder)$receiver.admin().cluster().prepareHealth(indices).setWaitForYellowStatus().setTimeout(TimeValue.timeValueSeconds((long)EsConfig.INSTANCE$.getAdminActionTimeoutInSeconds())), waitForYellowIndex.1.INSTANCE$);
    }

    @NotNull
    public static final Promise<Boolean, Exception> indexExists(Client $receiver, String ... indices) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)indices, (String)"indices");
        return KovenantKt.promise((ActionRequestBuilder)$receiver.admin().indices().prepareExists(indices), indexExists.1.INSTANCE$);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Promise<Unit, Exception> createIndex(Client $receiver, @NotNull String index, @NotNull List<? extends IndexTypeMapping> mappings2, int shardCount, int replicaCount, @NotNull Function1<? super ImmutableSettings.Builder, ? extends Unit> settingsInit) {
        void $receiver2;
        CreateIndexRequestBuilder $receiver3;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)index, (String)"index");
        Intrinsics.checkParameterIsNotNull(mappings2, (String)"mappings");
        Intrinsics.checkParameterIsNotNull(settingsInit, (String)"settingsInit");
        ImmutableSettings.Builder builder = ImmutableSettings.settingsBuilder().put("number_of_shards", shardCount).put("number_of_replicas", replicaCount);
        ImmutableSettings.Builder $receiver4 = (ImmutableSettings.Builder)$receiver3;
        settingsInit.invoke((Object)$receiver4);
        Settings indexSettings = ((ImmutableSettings.Builder)$receiver3).build();
        $receiver3 = $receiver.admin().indices().prepareCreate(index).setSettings(indexSettings);
        $receiver4 = $receiver3;
        Iterable iterable = mappings2;
        for (Object element : $receiver2) {
            IndexTypeMapping it = (IndexTypeMapping)element;
            $receiver4.addMapping(it.getType(), it.getJson());
        }
        return KovenantKt.promiseNothing((ActionRequestBuilder)$receiver3);
    }

    @NotNull
    public static /* synthetic */ Promise createIndex$default(Client client, String string, List list, int n, int n2, Function1 function1, int n3) {
        if ((n3 & 4) != 0) {
            n = EsConfig.INSTANCE$.getIndexShardCount();
        }
        if ((n3 & 8) != 0) {
            n2 = EsConfig.INSTANCE$.getIndexReplicaCount();
        }
        if ((n3 & 0x10) != 0) {
            function1 = createIndex.1.INSTANCE$;
        }
        return ClientKt.createIndex(client, string, list, n, n2, (Function1<? super ImmutableSettings.Builder, ? extends Unit>)function1);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Promise<List<? extends Boolean>, Exception> updateIndexMappings(Client $receiver, @NotNull String index, @NotNull List<? extends IndexTypeMapping> mappings2) {
        void $receiver2;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)index, (String)"index");
        Intrinsics.checkParameterIsNotNull(mappings2, (String)"mappings");
        LinkedList actions = KotlinPackage.linkedListOf((Object[])new Promise[0]);
        Iterable iterable = mappings2;
        for (Object element : $receiver2) {
            IndexTypeMapping it = (IndexTypeMapping)element;
            actions.add(KovenantKt.promise((ActionRequestBuilder)$receiver.admin().indices().preparePutMapping(new String[]{index}).setType(it.getType()).setSource(it.getJson()), updateIndexMappings.1.1.INSTANCE$));
        }
        return Bulk_apiKt.all$default((List)actions, null, (boolean)false, (int)6);
    }
}

