/*
 * Decompiled with CFR 0.152.
 */
package video.api.client.api.models;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;

public class Quality
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_QUALITY = "quality";
    @SerializedName(value="quality")
    private QualityEnum quality;
    public static final String SERIALIZED_NAME_STATUS = "status";
    @SerializedName(value="status")
    private StatusEnum status;

    public Quality quality(QualityEnum quality) {
        this.quality = quality;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="720p", value="The quality of the video you have, in pixels. Choices include 360p, 480p, 720p, 1080p, and 2160p.")
    public QualityEnum getQuality() {
        return this.quality;
    }

    public void setQuality(QualityEnum quality) {
        this.quality = quality;
    }

    public Quality status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The status of your video. Statuses include waiting - the video is waiting to be encoded. encoding - the video is in the process of being encoded. encoded - the video was successfully encoded. failed - the video failed to be encoded.")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Quality quality = (Quality)o;
        return Objects.equals((Object)this.quality, (Object)quality.quality) && Objects.equals((Object)this.status, (Object)quality.status);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.quality, this.status});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Quality {\n");
        sb.append("    quality: ").append(this.toIndentedString((Object)this.quality)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum StatusEnum {
        WAITING("waiting"),
        ENCODING("encoding"),
        ENCODED("encoded"),
        FAILED("failed");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<StatusEnum> {
            public void write(JsonWriter jsonWriter, StatusEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public StatusEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return StatusEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum QualityEnum {
        _240P("240p"),
        _360P("360p"),
        _480P("480p"),
        _720P("720p"),
        _1080P("1080p"),
        _2160P("2160p");

        private String value;

        private QualityEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static QualityEnum fromValue(String value) {
            for (QualityEnum b : QualityEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<QualityEnum> {
            public void write(JsonWriter jsonWriter, QualityEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public QualityEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return QualityEnum.fromValue(value);
            }
        }
    }
}

