/*
 * Decompiled with CFR 0.152.
 */
package video.api.client.api.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;

public class VideoSessionReferrer
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_URL = "url";
    @SerializedName(value="url")
    private String url;
    public static final String SERIALIZED_NAME_MEDIUM = "medium";
    @SerializedName(value="medium")
    private String medium;
    public static final String SERIALIZED_NAME_SOURCE = "source";
    @SerializedName(value="source")
    private String source;
    public static final String SERIALIZED_NAME_SEARCH_TERM = "searchTerm";
    @SerializedName(value="searchTerm")
    private String searchTerm;

    public VideoSessionReferrer url(String url) {
        this.url = url;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="https://api.video", value="The link the viewer used to reach the video session.")
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public VideoSessionReferrer medium(String medium) {
        this.medium = medium;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="organic", value="How they arrived at the site, for example organic or paid. Organic meaning they found it themselves and paid meaning they followed a link from an advertisement.")
    public String getMedium() {
        return this.medium;
    }

    public void setMedium(String medium) {
        this.medium = medium;
    }

    public VideoSessionReferrer source(String source) {
        this.source = source;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="https://google.com", value="The source the referrer came from to the video session. For example if they searched through google to find the stream.")
    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public VideoSessionReferrer searchTerm(String searchTerm) {
        this.searchTerm = searchTerm;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The search term they typed to arrive at the video session.")
    public String getSearchTerm() {
        return this.searchTerm;
    }

    public void setSearchTerm(String searchTerm) {
        this.searchTerm = searchTerm;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VideoSessionReferrer videoSessionReferrer = (VideoSessionReferrer)o;
        return Objects.equals(this.url, videoSessionReferrer.url) && Objects.equals(this.medium, videoSessionReferrer.medium) && Objects.equals(this.source, videoSessionReferrer.source) && Objects.equals(this.searchTerm, videoSessionReferrer.searchTerm);
    }

    public int hashCode() {
        return Objects.hash(this.url, this.medium, this.source, this.searchTerm);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class VideoSessionReferrer {\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("    medium: ").append(this.toIndentedString(this.medium)).append("\n");
        sb.append("    source: ").append(this.toIndentedString(this.source)).append("\n");
        sb.append("    searchTerm: ").append(this.toIndentedString(this.searchTerm)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

