/*
 * Decompiled with CFR 0.152.
 */
package video.api.client.api;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class ApiException
extends Exception {
    private int code = 0;
    private Map<String, List<String>> responseHeaders = null;
    private String responseBody = null;
    private String bodyMessage = null;
    private List<ApiProblem> problems;

    public ApiException() {
    }

    public ApiException(Throwable throwable) {
        super(throwable);
    }

    public ApiException(String message) {
        super(message);
    }

    public ApiException(String message, Throwable throwable, int code, Map<String, List<String>> responseHeaders, String responseBody) {
        super(message, throwable);
        this.code = code;
        this.responseHeaders = responseHeaders;
        this.responseBody = responseBody;
        Type typeOfHashMap = new TypeToken<Map<String, Object>>(){}.getType();
        Map parsedResponse = (Map)new Gson().fromJson(responseBody, typeOfHashMap);
        if (parsedResponse != null) {
            List problemsList;
            String details = null;
            try {
                if (parsedResponse.get("title") != null) {
                    details = (String)parsedResponse.get("title");
                } else if (parsedResponse.get("events") != null) {
                    details = (String)parsedResponse.get("events");
                }
            }
            catch (JsonSyntaxException jsonSyntaxException) {
                // empty catch block
            }
            this.bodyMessage = StringUtils.isNotBlank((CharSequence)message) && details != null ? message + ": " + details : (details != null ? details : message);
            if (parsedResponse.containsKey("problems") && (problemsList = (List)parsedResponse.get("problems")) != null) {
                this.problems = problemsList.stream().filter(Objects::nonNull).map(p -> new ApiProblem((String)p.get("type"), (String)p.get("title"), (String)p.get("name"))).collect(Collectors.toList());
            }
        }
    }

    @Override
    public String getMessage() {
        if (this.bodyMessage != null) {
            return this.bodyMessage;
        }
        return super.getMessage();
    }

    public List<ApiProblem> getProblems() {
        return this.problems;
    }

    public ApiException(String message, int code, Map<String, List<String>> responseHeaders, String responseBody) {
        this(message, null, code, responseHeaders, responseBody);
    }

    public ApiException(String message, Throwable throwable, int code, Map<String, List<String>> responseHeaders) {
        this(message, throwable, code, responseHeaders, null);
    }

    public ApiException(int code, Map<String, List<String>> responseHeaders, String responseBody) {
        this(null, null, code, responseHeaders, responseBody);
    }

    public ApiException(int code, String message) {
        super(message);
        this.code = code;
    }

    public ApiException(int code, String message, Map<String, List<String>> responseHeaders, String responseBody) {
        this(code, message);
        this.responseHeaders = responseHeaders;
        this.responseBody = responseBody;
    }

    public int getCode() {
        return this.code;
    }

    public Map<String, List<String>> getResponseHeaders() {
        return this.responseHeaders;
    }

    public String getResponseBody() {
        return this.responseBody;
    }

    public static class ApiProblem {
        private String type;
        private String title;
        private String name;

        public ApiProblem(String type, String title, String name) {
            this.type = type;
            this.title = title;
            this.name = name;
        }

        public String getType() {
            return this.type;
        }

        public String getTitle() {
            return this.title;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return "ApiProblem{type='" + this.type + '\'' + ", title='" + this.title + '\'' + ", name='" + this.name + '\'' + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ApiProblem that = (ApiProblem)o;
            return Objects.equals(this.getType(), that.getType()) && Objects.equals(this.getTitle(), that.getTitle()) && Objects.equals(this.getName(), that.getName());
        }
    }
}

