/*
 * Decompiled with CFR 0.152.
 */
package video.api.client.api.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;

public class LiveStreamCreationPayload
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_RECORD = "record";
    @SerializedName(value="record")
    private Boolean record = false;
    public static final String SERIALIZED_NAME_PUBLIC = "public";
    @SerializedName(value="public")
    private Boolean _public;
    public static final String SERIALIZED_NAME_PLAYER_ID = "playerId";
    @SerializedName(value="playerId")
    private String playerId;

    public LiveStreamCreationPayload name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="My Live Stream Video", required=true, value="Add a name for your live stream here.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public LiveStreamCreationPayload record(Boolean record) {
        this.record = record;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="true", value="Whether you are recording or not. True for record, false for not record.")
    public Boolean getRecord() {
        return this.record;
    }

    public void setRecord(Boolean record) {
        this.record = record;
    }

    public LiveStreamCreationPayload _public(Boolean _public) {
        this._public = _public;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="BETA FEATURE Please limit all public = false (\"private\") livestreams to 3,000 users. Whether your video can be viewed by everyone, or requires authentication to see it. A setting of false will require a unique token for each view.")
    public Boolean getPublic() {
        return this._public;
    }

    public void setPublic(Boolean _public) {
        this._public = _public;
    }

    public LiveStreamCreationPayload playerId(String playerId) {
        this.playerId = playerId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="pl4f4ferf5erfr5zed4fsdd", value="The unique identifier for the player.")
    public String getPlayerId() {
        return this.playerId;
    }

    public void setPlayerId(String playerId) {
        this.playerId = playerId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LiveStreamCreationPayload liveStreamCreationPayload = (LiveStreamCreationPayload)o;
        return Objects.equals(this.name, liveStreamCreationPayload.name) && Objects.equals(this.record, liveStreamCreationPayload.record) && Objects.equals(this._public, liveStreamCreationPayload._public) && Objects.equals(this.playerId, liveStreamCreationPayload.playerId);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.record, this._public, this.playerId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LiveStreamCreationPayload {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    record: ").append(this.toIndentedString(this.record)).append("\n");
        sb.append("    _public: ").append(this.toIndentedString(this._public)).append("\n");
        sb.append("    playerId: ").append(this.toIndentedString(this.playerId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

