/*
 * Decompiled with CFR 0.152.
 */
package video.api.client.api.clients;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import okhttp3.Call;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import video.api.client.ApiVideoClient;

public abstract class AbstractApiTest {
    private final OkHttpClient httpClient = (OkHttpClient)Mockito.mock(OkHttpClient.class);
    protected final ApiVideoClient apiClientMock = new ApiVideoClient(this.httpClient);

    private Call buildAnswer(InvocationOnMock invocationOnMock, Integer statusCode, String body) throws IOException {
        Request request = (Request)invocationOnMock.getArgument(0, Request.class);
        Call call = (Call)Mockito.mock(Call.class);
        Mockito.when((Object)call.execute()).thenReturn((Object)new Response.Builder().request(request).protocol(Protocol.HTTP_2).code(statusCode.intValue()).message("").body(ResponseBody.create((MediaType)MediaType.get((String)"application/json; charset=utf-8"), (String)body)).build());
        return call;
    }

    protected String readResourceFile(String path) {
        try {
            URL resource = this.getClass().getResource(path);
            if (resource == null) {
                throw new FileNotFoundException(path);
            }
            return new String(Files.readAllBytes(Paths.get(resource.toURI())));
        }
        catch (IOException | URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    protected void answerOnAnyRequest(Integer statusCode, String body) {
        Mockito.when((Object)this.httpClient.newCall((Request)Mockito.any())).thenAnswer(invocationOnMock -> this.buildAnswer(invocationOnMock, statusCode, body));
    }
}

