/*
 * Decompiled with CFR 0.152.
 */
package video.api.client.api.clients;

import java.time.OffsetDateTime;
import java.util.List;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import video.api.client.api.ApiException;
import video.api.client.api.clients.AbstractApiTest;
import video.api.client.api.clients.RawStatisticsApi;
import video.api.client.api.models.LiveStreamSession;
import video.api.client.api.models.LiveStreamSessionClient;
import video.api.client.api.models.LiveStreamSessionDevice;
import video.api.client.api.models.LiveStreamSessionLocation;
import video.api.client.api.models.LiveStreamSessionReferrer;
import video.api.client.api.models.LiveStreamSessionSession;
import video.api.client.api.models.Page;
import video.api.client.api.models.PlayerSessionEvent;
import video.api.client.api.models.VideoSession;
import video.api.client.api.models.VideoSessionClient;
import video.api.client.api.models.VideoSessionDevice;
import video.api.client.api.models.VideoSessionLocation;
import video.api.client.api.models.VideoSessionOs;
import video.api.client.api.models.VideoSessionReferrer;
import video.api.client.api.models.VideoSessionSession;

@DisplayName(value="RawStatisticsApi")
public class RawStatisticsApiTest
extends AbstractApiTest {
    private final RawStatisticsApi api;

    public RawStatisticsApiTest() {
        this.api = this.apiClientMock.rawStatistics();
    }

    @Nested
    @DisplayName(value="listVideoSessions")
    class listVideoSessions {
        private static final String PAYLOADS_PATH = "/payloads/rawstatistics/listVideoSessions/";

        listVideoSessions() {
        }

        @Test
        @DisplayName(value="required parameters")
        public void requiredParametersTest() {
            RawStatisticsApiTest.this.answerOnAnyRequest(201, "{}");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> RawStatisticsApiTest.this.api.listVideoSessions(null, "2022-01").execute()).isInstanceOf(ApiException.class)).hasMessage("Missing the required parameter 'videoId' when calling listVideoSessions");
            Assertions.assertThatNoException().isThrownBy(() -> RawStatisticsApiTest.this.api.listVideoSessions("vi4k0jvEUuaTdRAEjQ4Prklg", "2022-01").execute());
        }

        @Test
        @DisplayName(value="200 response")
        public void responseWithStatus200Test() throws ApiException {
            RawStatisticsApiTest.this.answerOnAnyRequest(200, RawStatisticsApiTest.this.readResourceFile("/payloads/rawstatistics/listVideoSessions/responses/200.json"));
            Page page = RawStatisticsApiTest.this.api.listVideoSessions("vi4k0jvEUuaTdRAEjQ4Prklg", "2022-01").execute();
            Assertions.assertThat((Integer)page.getCurrentPage()).isEqualTo(1);
            Assertions.assertThat((Integer)page.getPageSize()).isEqualTo(25);
            Assertions.assertThat((Integer)page.getPagesTotal()).isEqualTo(1);
            Assertions.assertThat((Integer)page.getCurrentPageItems()).isEqualTo(1);
            Assertions.assertThat((List)page.getItems()).containsExactlyInAnyOrder((Object[])new VideoSession[]{new VideoSession().session(new VideoSessionSession().sessionId("psEmFwGQUAXR2lFHj5nDOpy").loadedAt(OffsetDateTime.parse("2019-06-24T11:45:01.109Z")).endedAt(OffsetDateTime.parse("2019-06-24T11:49:19.243Z"))).location(new VideoSessionLocation().country("France").city("Paris")).referrer(new VideoSessionReferrer().url("https://api.video").medium("organic").source("https://google.com").searchTerm("video encoding hosting and delivery")).device(new VideoSessionDevice().type("desktop").vendor("Dell").model("unknown")).os(new VideoSessionOs().name("Microsoft Windows").shortname("W10").version("Windows10")).client(new VideoSessionClient().type("browser").name("Firefox").version("67.0"))});
        }

        @Test
        @DisplayName(value="404 response")
        public void responseWithStatus404Test() throws ApiException {
            RawStatisticsApiTest.this.answerOnAnyRequest(404, RawStatisticsApiTest.this.readResourceFile("/payloads/rawstatistics/listVideoSessions/responses/404.json"));
            ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> RawStatisticsApiTest.this.api.listVideoSessions("vi4k0jvEUuaTdRAEjQ4Prklg", "2022-01").execute()).isInstanceOf(ApiException.class)).satisfies(e -> Assertions.assertThat((int)((ApiException)e).getCode()).isEqualTo(404))).hasMessage("The requested resource was not found.");
        }
    }

    @Nested
    @DisplayName(value="listSessionEvents")
    class listSessionEvents {
        private static final String PAYLOADS_PATH = "/payloads/rawstatistics/listSessionEvents/";

        listSessionEvents() {
        }

        @Test
        @DisplayName(value="required parameters")
        public void requiredParametersTest() {
            RawStatisticsApiTest.this.answerOnAnyRequest(201, "{}");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> RawStatisticsApiTest.this.api.listSessionEvents(null).execute()).isInstanceOf(ApiException.class)).hasMessage("Missing the required parameter 'sessionId' when calling listSessionEvents");
            Assertions.assertThatNoException().isThrownBy(() -> RawStatisticsApiTest.this.api.listSessionEvents("psEmFwGQUAXR2lFHj5nDOpy").execute());
        }

        @Test
        @DisplayName(value="200 response")
        public void responseWithStatus200Test() throws ApiException {
            RawStatisticsApiTest.this.answerOnAnyRequest(200, RawStatisticsApiTest.this.readResourceFile("/payloads/rawstatistics/listSessionEvents/responses/200.json"));
            Page page = RawStatisticsApiTest.this.api.listSessionEvents("psEmFwGQUAXR2lFHj5nDOpy").execute();
            Assertions.assertThat((Integer)page.getCurrentPage()).isEqualTo(1);
            Assertions.assertThat((Integer)page.getCurrentPageItems()).isEqualTo(25);
            Assertions.assertThat((Integer)page.getPageSize()).isEqualTo(25);
            Assertions.assertThat((Integer)page.getPagesTotal()).isEqualTo(2);
            Assertions.assertThat((Integer)page.getItemsTotal()).isEqualTo(30);
            Assertions.assertThat((List)page.getItems()).containsExactlyInAnyOrder((Object[])new PlayerSessionEvent[]{new PlayerSessionEvent().type("ready").emittedAt(OffsetDateTime.parse("2020-09-15T09:47:42+00:00")).at(Integer.valueOf(0)), new PlayerSessionEvent().type("play").emittedAt(OffsetDateTime.parse("2020-09-15T21:35:57+00:00")).at(Integer.valueOf(0)), new PlayerSessionEvent().type("pause").emittedAt(OffsetDateTime.parse("2020-09-15T21:36:05+00:00")).at(Integer.valueOf(7)), new PlayerSessionEvent().type("resume").emittedAt(OffsetDateTime.parse("2020-09-15T21:36:19+00:00")).at(Integer.valueOf(21)), new PlayerSessionEvent().type("seek.forward").emittedAt(OffsetDateTime.parse("2020-09-15T21:36:19+00:00")).from(Integer.valueOf(7)).to(Integer.valueOf(21)), new PlayerSessionEvent().type("end").emittedAt(OffsetDateTime.parse("2020-09-15T21:36:28+00:00")).at(Integer.valueOf(30)), new PlayerSessionEvent().type("play").emittedAt(OffsetDateTime.parse("2020-09-15T21:36:29+00:00")).at(Integer.valueOf(0)), new PlayerSessionEvent().type("seek.backward").emittedAt(OffsetDateTime.parse("2020-09-15T21:36:29+00:00")).from(Integer.valueOf(30)).to(Integer.valueOf(0)), new PlayerSessionEvent().type("pause").emittedAt(OffsetDateTime.parse("2020-09-15T21:36:29+00:00")).at(Integer.valueOf(21)), new PlayerSessionEvent().type("resume").emittedAt(OffsetDateTime.parse("2020-09-15T21:36:30+00:00")).at(Integer.valueOf(21)), new PlayerSessionEvent().type("seek.forward").emittedAt(OffsetDateTime.parse("2020-09-15T21:36:30+00:00")).from(Integer.valueOf(0)).to(Integer.valueOf(21)), new PlayerSessionEvent().type("pause").emittedAt(OffsetDateTime.parse("2020-09-15T21:36:33+00:00")).at(Integer.valueOf(20)), new PlayerSessionEvent().type("resume").emittedAt(OffsetDateTime.parse("2020-09-15T21:36:33+00:00")).at(Integer.valueOf(20)), new PlayerSessionEvent().type("seek.backward").emittedAt(OffsetDateTime.parse("2020-09-15T21:36:33+00:00")).from(Integer.valueOf(24)).to(Integer.valueOf(20)), new PlayerSessionEvent().type("pause").emittedAt(OffsetDateTime.parse("2020-09-15T21:36:39+00:00")).at(Integer.valueOf(17)), new PlayerSessionEvent().type("resume").emittedAt(OffsetDateTime.parse("2020-09-15T21:36:39+00:00")).at(Integer.valueOf(17)), new PlayerSessionEvent().type("seek.forward").emittedAt(OffsetDateTime.parse("2020-09-15T21:36:39+00:00")).from(Integer.valueOf(17)).to(Integer.valueOf(17)), new PlayerSessionEvent().type("pause").emittedAt(OffsetDateTime.parse("2020-09-15T21:36:41+00:00")).at(Integer.valueOf(19)), new PlayerSessionEvent().type("ready").emittedAt(OffsetDateTime.parse("2020-09-17T09:20:47+00:00")).at(Integer.valueOf(0)), new PlayerSessionEvent().type("ready").emittedAt(OffsetDateTime.parse("2020-09-17T09:41:01+00:00")).at(Integer.valueOf(0)), new PlayerSessionEvent().type("ready").emittedAt(OffsetDateTime.parse("2020-09-17T09:41:08+00:00")).at(Integer.valueOf(0)), new PlayerSessionEvent().type("play").emittedAt(OffsetDateTime.parse("2020-09-17T09:41:10+00:00")).at(Integer.valueOf(0)), new PlayerSessionEvent().type("pause").emittedAt(OffsetDateTime.parse("2020-09-17T09:41:12+00:00")).at(Integer.valueOf(1)), new PlayerSessionEvent().type("resume").emittedAt(OffsetDateTime.parse("2020-09-17T09:41:13+00:00")).at(Integer.valueOf(1)), new PlayerSessionEvent().type("pause").emittedAt(OffsetDateTime.parse("2020-09-17T09:41:15+00:00")).at(Integer.valueOf(3))});
        }

        @Test
        @DisplayName(value="404 response")
        public void responseWithStatus404Test() throws ApiException {
            RawStatisticsApiTest.this.answerOnAnyRequest(404, RawStatisticsApiTest.this.readResourceFile("/payloads/rawstatistics/listSessionEvents/responses/404.json"));
            ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> RawStatisticsApiTest.this.api.listSessionEvents("psEmFwGQUAXR2lFHj5nDOpy").execute()).isInstanceOf(ApiException.class)).satisfies(e -> Assertions.assertThat((int)((ApiException)e).getCode()).isEqualTo(404))).hasMessage("The requested resource was not found.");
        }
    }

    @Nested
    @DisplayName(value="listLiveStreamSessions")
    class listLiveStreamSessions {
        private static final String PAYLOADS_PATH = "/payloads/rawstatistics/listLiveStreamSessions/";

        listLiveStreamSessions() {
        }

        @Test
        @DisplayName(value="required parameters")
        public void requiredParametersTest() {
            RawStatisticsApiTest.this.answerOnAnyRequest(201, "{}");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> RawStatisticsApiTest.this.api.listLiveStreamSessions(null, "2022-01").execute()).isInstanceOf(ApiException.class)).hasMessage("Missing the required parameter 'liveStreamId' when calling listLiveStreamSessions");
            Assertions.assertThatNoException().isThrownBy(() -> RawStatisticsApiTest.this.api.listLiveStreamSessions("vi4k0jvEUuaTdRAEjQ4Jfrgz", "2022-01").execute());
        }

        @Test
        @DisplayName(value="200 response")
        public void responseWithStatus200Test() throws ApiException {
            RawStatisticsApiTest.this.answerOnAnyRequest(200, RawStatisticsApiTest.this.readResourceFile("/payloads/rawstatistics/listLiveStreamSessions/responses/200.json"));
            Page page = RawStatisticsApiTest.this.api.listLiveStreamSessions("vi4k0jvEUuaTdRAEjQ4Jfrgz", "2022-01").execute();
            Assertions.assertThat((Integer)page.getCurrentPage()).isEqualTo(1);
            Assertions.assertThat((Integer)page.getPageSize()).isEqualTo(25);
            Assertions.assertThat((Integer)page.getPagesTotal()).isEqualTo(1);
            Assertions.assertThat((Integer)page.getCurrentPageItems()).isEqualTo(1);
            Assertions.assertThat((List)page.getItems()).containsExactlyInAnyOrder((Object[])new LiveStreamSession[]{new LiveStreamSession().session(new LiveStreamSessionSession().sessionId("ps4zRWVOv2If2vzKJLMr3jQo").loadedAt(OffsetDateTime.parse("2018-09-11T13:04:37.89Z")).endedAt(OffsetDateTime.parse("2018-09-11T14:47:22.186Z"))).location(new LiveStreamSessionLocation().country("France").city("Paris")).referrer(new LiveStreamSessionReferrer().url("unknown").medium("unknown").source("unknown").searchTerm("unknown")).device(new LiveStreamSessionDevice().type("desktop").vendor("unknown").model("unknown")).os(new VideoSessionOs().name("unknown").shortname("unknown").version("unknown")).client(new LiveStreamSessionClient().type("browser").name("Firefox").version("61.0"))});
        }

        @Test
        @DisplayName(value="404 response")
        public void responseWithStatus404Test() throws ApiException {
            RawStatisticsApiTest.this.answerOnAnyRequest(404, RawStatisticsApiTest.this.readResourceFile("/payloads/rawstatistics/listLiveStreamSessions/responses/404.json"));
            ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> RawStatisticsApiTest.this.api.listLiveStreamSessions("vi4k0jvEUuaTdRAEjQ4Jfrgz", "2022-01").execute()).isInstanceOf(ApiException.class)).satisfies(e -> Assertions.assertThat((int)((ApiException)e).getCode()).isEqualTo(404))).hasMessage("The requested resource was not found.");
        }
    }
}

