/*
 * Decompiled with CFR 0.152.
 */
package video.api.client.api.clients;

import java.io.File;
import java.math.BigDecimal;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import video.api.client.api.ApiException;
import video.api.client.api.clients.AbstractApiTest;
import video.api.client.api.clients.VideosApi;
import video.api.client.api.models.BytesRange;
import video.api.client.api.models.Metadata;
import video.api.client.api.models.Page;
import video.api.client.api.models.Quality;
import video.api.client.api.models.Video;
import video.api.client.api.models.VideoAssets;
import video.api.client.api.models.VideoCreationPayload;
import video.api.client.api.models.VideoSource;
import video.api.client.api.models.VideoStatus;
import video.api.client.api.models.VideoStatusIngest;
import video.api.client.api.models.VideoThumbnailPickPayload;
import video.api.client.api.models.VideoUpdatePayload;

@DisplayName(value="VideosApi")
public class VideosApiTest
extends AbstractApiTest {
    private final VideosApi api;

    public VideosApiTest() {
        this.api = this.apiClientMock.videos();
    }

    @Nested
    @DisplayName(value="uploadThumbnail")
    class uploadThumbnail {
        private static final String PAYLOADS_PATH = "/payloads/videos/uploadThumbnail/";

        uploadThumbnail() {
        }

        @Test
        @DisplayName(value="required parameters")
        public void requiredParametersTest() {
            VideosApiTest.this.answerOnAnyRequest(201, "{}");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> VideosApiTest.this.api.uploadThumbnail(null, new File(""))).isInstanceOf(ApiException.class)).hasMessage("Missing the required parameter 'videoId' when calling uploadThumbnail");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> VideosApiTest.this.api.uploadThumbnail("1234", null)).isInstanceOf(ApiException.class)).hasMessage("Missing the required parameter 'file' when calling uploadThumbnail");
            Assertions.assertThatNoException().isThrownBy(() -> VideosApiTest.this.api.uploadThumbnail("videoId_example", new File("")));
        }

        @Test
        @DisplayName(value="200 response")
        public void responseWithStatus200Test() throws ApiException {
            VideosApiTest.this.answerOnAnyRequest(200, VideosApiTest.this.readResourceFile("/payloads/videos/uploadThumbnail/responses/200.json"));
            Video res = VideosApiTest.this.api.uploadThumbnail("videoId_example", new File(""));
            Assertions.assertThat((String)res.getVideoId()).isEqualTo("vi4blUQJFrYWbaG44NChkH27");
            Assertions.assertThat((String)res.getPlayerId()).isEqualTo("pl45KFKdlddgk654dspkze");
            Assertions.assertThat((String)res.getTitle()).isEqualTo("Maths video");
            Assertions.assertThat((String)res.getDescription()).isEqualTo("An amazing video explaining the string theory");
            Assertions.assertThat((Boolean)res.getPublic()).isEqualTo(false);
            Assertions.assertThat((Boolean)res.getPanoramic()).isEqualTo(false);
            Assertions.assertThat((Boolean)res.getMp4Support()).isEqualTo(true);
            Assertions.assertThat((List)res.getTags()).isEqualTo(Arrays.asList("maths", "string theory", "video"));
            Assertions.assertThat((List)res.getMetadata()).isEqualTo(Arrays.asList(new Metadata("Author", "John Doe"), new Metadata("Format", "Tutorial")));
            Assertions.assertThat((Object)res.getSource()).isEqualTo((Object)new VideoSource().uri("/videos/vi4blUQJFrYWbaG44NChkH27/source"));
            Assertions.assertThat((Object)res.getAssets()).isEqualTo((Object)new VideoAssets().hls(URI.create("https://cdn.api.video/vod/vi4blUQJFrYWbaG44NChkH27/hls/manifest.m3u8")).iframe("<iframe src=\"https://embed.api.video/vod/vi4blUQJFrYWbaG44NChkH27\" width=\"100%\" height=\"100%\" frameborder=\"0\" scrolling=\"no\" allowfullscreen=\"\"></iframe>").player(URI.create("https://embed.api.video/vod/vi4blUQJFrYWbaG44NChkH27")).thumbnail(URI.create("https://cdn.api.video/vod/vi4blUQJFrYWbaG44NChkH27/thumbnail.jpg")).mp4(URI.create("https://cdn.api.video/vod/vi4blUQJFrYWbaG44NChkH27/mp4/source.mp4")));
        }

        @Test
        @DisplayName(value="400 response")
        public void responseWithStatus400Test() throws ApiException {
            VideosApiTest.this.answerOnAnyRequest(400, VideosApiTest.this.readResourceFile("/payloads/videos/uploadThumbnail/responses/400.json"));
            ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> VideosApiTest.this.api.uploadThumbnail("videoId_example", new File(""))).isInstanceOf(ApiException.class)).satisfies(e -> Assertions.assertThat((int)((ApiException)e).getCode()).isEqualTo(400))).hasMessage("Only [jpeg, jpg, JPG, JPEG] extensions are supported.");
        }

        @Test
        @DisplayName(value="404 response")
        public void responseWithStatus404Test() throws ApiException {
            VideosApiTest.this.answerOnAnyRequest(404, VideosApiTest.this.readResourceFile("/payloads/videos/uploadThumbnail/responses/404.json"));
            ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> VideosApiTest.this.api.uploadThumbnail("videoId_example", new File(""))).isInstanceOf(ApiException.class)).satisfies(e -> Assertions.assertThat((int)((ApiException)e).getCode()).isEqualTo(404))).hasMessage("The requested resource was not found.");
        }
    }

    @Nested
    @DisplayName(value="upload")
    class upload {
        private static final String PAYLOADS_PATH = "/payloads/videos/upload/";

        upload() {
        }

        @Test
        @DisplayName(value="required parameters")
        public void requiredParametersTest() {
            VideosApiTest.this.answerOnAnyRequest(201, "{}");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> VideosApiTest.this.api.upload(null, new File(""))).isInstanceOf(ApiException.class)).hasMessage("Missing the required parameter 'videoId' when calling upload");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> VideosApiTest.this.api.upload("1234", null)).isInstanceOf(ApiException.class)).hasMessage("Missing the required parameter 'file' when calling upload");
            Assertions.assertThatNoException().isThrownBy(() -> VideosApiTest.this.api.upload("videoId_example", new File("")));
        }

        @Test
        @DisplayName(value="201 response")
        public void responseWithStatus201Test() throws ApiException {
            VideosApiTest.this.answerOnAnyRequest(201, VideosApiTest.this.readResourceFile("/payloads/videos/upload/responses/201.json"));
            Video res = VideosApiTest.this.api.upload("vi4blUQJFrYWbaG44NChkH27", new File(""));
            Assertions.assertThat((String)res.getVideoId()).isEqualTo("vi4blUQJFrYWbaG44NChkH27");
            Assertions.assertThat((String)res.getPlayerId()).isEqualTo("pl45KFKdlddgk654dspkze");
            Assertions.assertThat((String)res.getTitle()).isEqualTo("Maths video");
            Assertions.assertThat((String)res.getDescription()).isEqualTo("An amazing video explaining the string theory.");
            Assertions.assertThat((Boolean)res.getPublic()).isEqualTo(false);
            Assertions.assertThat((Boolean)res.getPanoramic()).isEqualTo(false);
            Assertions.assertThat((Boolean)res.getMp4Support()).isEqualTo(true);
            Assertions.assertThat((List)res.getTags()).isEqualTo(Arrays.asList("maths", "string theory", "video"));
            Assertions.assertThat((List)res.getMetadata()).isEqualTo(Arrays.asList(new Metadata("Author", "John Doe"), new Metadata("Format", "Tutorial")));
            Assertions.assertThat((Object)res.getSource()).isEqualTo((Object)new VideoSource().uri("/videos/vi4blUQJFrYWbaG44NChkH27/source"));
            Assertions.assertThat((Object)res.getAssets()).isEqualTo((Object)new VideoAssets().hls(URI.create("https://cdn.api.video/vod/vi4blUQJFrYWbaG44NChkH27/hls/manifest.m3u8")).iframe("<iframe src=\"https://embed.api.video/vod/vi4blUQJFrYWbaG44NChkH27\" width=\"100%\" height=\"100%\" frameborder=\"0\" scrolling=\"no\" allowfullscreen=\"\"></iframe>").player(URI.create("https://embed.api.video/vod/vi4blUQJFrYWbaG44NChkH27")).thumbnail(URI.create("https://cdn.api.video/vod/vi4blUQJFrYWbaG44NChkH27/thumbnail.jpg")).mp4(URI.create("https://cdn.api.video/vod/vi4blUQJFrYWbaG44NChkH27/mp4/source.mp4")));
        }

        @Test
        @DisplayName(value="400 response")
        public void responseWithStatus400Test() throws ApiException {
            VideosApiTest.this.answerOnAnyRequest(400, VideosApiTest.this.readResourceFile("/payloads/videos/upload/responses/400.json"));
            ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> VideosApiTest.this.api.upload("vi4blUQJFrYWbaG44NChkH27", new File(""))).isInstanceOf(ApiException.class)).satisfies(e -> Assertions.assertThat((int)((ApiException)e).getCode()).isEqualTo(400))).hasMessage("The source of the video is already uploaded.");
        }

        @Test
        @DisplayName(value="404 response")
        public void responseWithStatus404Test() throws ApiException {
            VideosApiTest.this.answerOnAnyRequest(404, VideosApiTest.this.readResourceFile("/payloads/videos/upload/responses/404.json"));
            ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> VideosApiTest.this.api.upload("vi4blUQJFrYWbaG44NChkH27", new File(""))).isInstanceOf(ApiException.class)).satisfies(e -> Assertions.assertThat((int)((ApiException)e).getCode()).isEqualTo(404))).hasMessage("The requested resource was not found.");
        }
    }

    @Nested
    @DisplayName(value="create")
    class create {
        private static final String PAYLOADS_PATH = "/payloads/videos/create/";

        create() {
        }

        @Test
        @DisplayName(value="required parameters")
        public void requiredParametersTest() {
            VideosApiTest.this.answerOnAnyRequest(201, "{}");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> VideosApiTest.this.api.create(null)).isInstanceOf(ApiException.class)).hasMessage("Missing the required parameter 'videoCreationPayload' when calling create");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> VideosApiTest.this.api.create(new VideoCreationPayload())).isInstanceOf(ApiException.class)).hasMessage("Missing the required parameter 'videoCreationPayload.title' when calling create");
            Assertions.assertThatNoException().isThrownBy(() -> VideosApiTest.this.api.create(new VideoCreationPayload().title("title")));
        }

        @Test
        @DisplayName(value="201 response")
        public void responseWithStatus201Test() throws ApiException {
            VideosApiTest.this.answerOnAnyRequest(201, VideosApiTest.this.readResourceFile("/payloads/videos/create/responses/201.json"));
            Video res = VideosApiTest.this.api.create(new VideoCreationPayload().title("title"));
            Assertions.assertThat((String)res.getVideoId()).isEqualTo("vi4blUQJFrYWbaG44NChkH27");
            Assertions.assertThat((String)res.getPlayerId()).isEqualTo("pl4k0jvEUuaTdRAEjQ4Jfrgz");
            Assertions.assertThat((String)res.getTitle()).isEqualTo("Maths video");
            Assertions.assertThat((String)res.getDescription()).isEqualTo("An amazing video explaining the string theory");
            Assertions.assertThat((Boolean)res.getPublic()).isEqualTo(false);
            Assertions.assertThat((Boolean)res.getPanoramic()).isEqualTo(false);
            Assertions.assertThat((Boolean)res.getMp4Support()).isEqualTo(true);
            Assertions.assertThat((List)res.getTags()).isEqualTo(Arrays.asList("maths", "string theory", "video"));
            Assertions.assertThat((List)res.getMetadata()).isEqualTo(Arrays.asList(new Metadata("Author", "John Doe"), new Metadata("Format", "Tutorial")));
            Assertions.assertThat((Object)res.getSource()).isEqualTo((Object)new VideoSource().uri("/videos/vi4blUQJFrYWbaG44NChkH27/source"));
            Assertions.assertThat((Object)res.getAssets()).isEqualTo((Object)new VideoAssets().hls(URI.create("https://cdn.api.video/vod/vi4blUQJFrYWbaG44NChkH27/hls/manifest.m3u8")).iframe("<iframe src=\"https://embed.api.video/vod/vi4blUQJFrYWbaG44NChkH27\" width=\"100%\" height=\"100%\" frameborder=\"0\" scrolling=\"no\" allowfullscreen=\"\"></iframe>").player(URI.create("https://embed.api.video/vod/vi4blUQJFrYWbaG44NChkH27")).thumbnail(URI.create("https://cdn.api.video/vod/vi4blUQJFrYWbaG44NChkH27/thumbnail.jpg")).mp4(URI.create("https://cdn.api.video/vod/vi4blUQJFrYWbaG44NChkH27/mp4/source.mp4")));
        }

        @Test
        @DisplayName(value="400 response")
        public void responseWithStatus400Test() throws ApiException {
            VideosApiTest.this.answerOnAnyRequest(400, VideosApiTest.this.readResourceFile("/payloads/videos/create/responses/400.json"));
            ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> VideosApiTest.this.api.create(new VideoCreationPayload().title("title"))).isInstanceOf(ApiException.class)).satisfies(e -> Assertions.assertThat((int)((ApiException)e).getCode()).isEqualTo(400))).hasMessage("This attribute is required.");
        }
    }

    @Nested
    @DisplayName(value="pickThumbnail")
    class pickThumbnail {
        private static final String PAYLOADS_PATH = "/payloads/videos/pickThumbnail/";

        pickThumbnail() {
        }

        @Test
        @DisplayName(value="required parameters")
        public void requiredParametersTest() {
            VideosApiTest.this.answerOnAnyRequest(201, "{}");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> VideosApiTest.this.api.pickThumbnail(null, new VideoThumbnailPickPayload().timecode("10:10:10"))).isInstanceOf(ApiException.class)).hasMessage("Missing the required parameter 'videoId' when calling pickThumbnail");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> VideosApiTest.this.api.pickThumbnail("1234", null)).isInstanceOf(ApiException.class)).hasMessage("Missing the required parameter 'videoThumbnailPickPayload' when calling pickThumbnail");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> VideosApiTest.this.api.pickThumbnail("1234", new VideoThumbnailPickPayload())).isInstanceOf(ApiException.class)).hasMessage("Missing the required parameter 'videoThumbnailPickPayload.timecode' when calling pickThumbnail");
            Assertions.assertThatNoException().isThrownBy(() -> VideosApiTest.this.api.pickThumbnail("vi4blUQJFrYWbaG44NChkH27", new VideoThumbnailPickPayload().timecode("10:10:10")));
        }

        @Test
        @DisplayName(value="200 response")
        public void responseWithStatus200Test() throws ApiException {
            VideosApiTest.this.answerOnAnyRequest(200, VideosApiTest.this.readResourceFile("/payloads/videos/pickThumbnail/responses/200.json"));
            Video res = VideosApiTest.this.api.pickThumbnail("vi4blUQJFrYWbaG44NChkH27", new VideoThumbnailPickPayload().timecode("00:00:00"));
            Assertions.assertThat((String)res.getVideoId()).isEqualTo("vi4blUQJFrYWbaG44NChkH27");
            Assertions.assertThat((String)res.getPlayerId()).isEqualTo("pl45KFKdlddgk654dspkze");
            Assertions.assertThat((String)res.getTitle()).isEqualTo("Maths video");
            Assertions.assertThat((String)res.getDescription()).isEqualTo("An amazing video explaining string theory");
            Assertions.assertThat((Boolean)res.getPublic()).isEqualTo(false);
            Assertions.assertThat((Boolean)res.getPanoramic()).isEqualTo(false);
            Assertions.assertThat((Boolean)res.getMp4Support()).isEqualTo(true);
            Assertions.assertThat((List)res.getTags()).isEqualTo(Arrays.asList("maths", "string theory", "video"));
            Assertions.assertThat((List)res.getMetadata()).isEqualTo(Arrays.asList(new Metadata("Author", "John Doe"), new Metadata("Format", "Tutorial")));
            Assertions.assertThat((Object)res.getSource()).isEqualTo((Object)new VideoSource().uri("/videos/vi4blUQJFrYWbaG44NChkH27/source"));
            Assertions.assertThat((Object)res.getAssets()).isEqualTo((Object)new VideoAssets().hls(URI.create("https://cdn.api.video/vod/vi4blUQJFrYWbaG44NChkH27/hls/manifest.m3u8")).iframe("<iframe src=\"https://embed.api.video/vod/vi4blUQJFrYWbaG44NChkH27\" width=\"100%\" height=\"100%\" frameborder=\"0\" scrolling=\"no\" allowfullscreen=\"\"></iframe>").player(URI.create("https://embed.api.video/vod/vi4blUQJFrYWbaG44NChkH27")).thumbnail(URI.create("https://cdn.api.video/vod/vi4blUQJFrYWbaG44NChkH27/thumbnail.jpg")).mp4(URI.create("https://cdn.api.video/vod/vi4blUQJFrYWbaG44NChkH27/mp4/source.mp4")));
        }

        @Test
        @DisplayName(value="404 response")
        public void responseWithStatus404Test() throws ApiException {
            VideosApiTest.this.answerOnAnyRequest(404, VideosApiTest.this.readResourceFile("/payloads/videos/pickThumbnail/responses/404.json"));
            ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> VideosApiTest.this.api.pickThumbnail("vi4blUQJFrYWbaG44NChkH27", new VideoThumbnailPickPayload().timecode("00:00:00"))).isInstanceOf(ApiException.class)).satisfies(e -> Assertions.assertThat((int)((ApiException)e).getCode()).isEqualTo(404))).hasMessage("The requested resource was not found.");
        }
    }

    @Nested
    @DisplayName(value="update")
    class update {
        private static final String PAYLOADS_PATH = "/payloads/videos/update/";

        update() {
        }

        @Test
        @DisplayName(value="required parameters")
        public void requiredParametersTest() {
            VideosApiTest.this.answerOnAnyRequest(201, "{}");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> VideosApiTest.this.api.update("1234", null)).isInstanceOf(ApiException.class)).hasMessage("Missing the required parameter 'videoUpdatePayload' when calling update");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> VideosApiTest.this.api.update(null, new VideoUpdatePayload())).isInstanceOf(ApiException.class)).hasMessage("Missing the required parameter 'videoId' when calling update");
            Assertions.assertThatNoException().isThrownBy(() -> VideosApiTest.this.api.update("vi4blUQJFrYWbaG44NChkH27", new VideoUpdatePayload()));
        }

        @Test
        @DisplayName(value="200 response")
        public void responseWithStatus200Test() throws ApiException {
            VideosApiTest.this.answerOnAnyRequest(200, VideosApiTest.this.readResourceFile("/payloads/videos/update/responses/200.json"));
            Video res = VideosApiTest.this.api.update("vi4blUQJFrYWbaG44NChkH27", new VideoUpdatePayload());
            Assertions.assertThat((String)res.getVideoId()).isEqualTo("vi4blUQJFrYWbaG44NChkH27");
            Assertions.assertThat((String)res.getPlayerId()).isEqualTo("pl45KFKdlddgk654dspkze");
            Assertions.assertThat((String)res.getTitle()).isEqualTo("Maths video");
            Assertions.assertThat((String)res.getDescription()).isEqualTo("An amazing video explaining the string theory");
            Assertions.assertThat((Boolean)res.getPublic()).isEqualTo(false);
            Assertions.assertThat((Boolean)res.getPanoramic()).isEqualTo(false);
            Assertions.assertThat((Boolean)res.getMp4Support()).isEqualTo(true);
            Assertions.assertThat((List)res.getTags()).isEqualTo(Arrays.asList("maths", "string theory", "video"));
            Assertions.assertThat((List)res.getMetadata()).isEqualTo(Arrays.asList(new Metadata("Author", "John Doe"), new Metadata("Format", "Tutorial")));
            Assertions.assertThat((Object)res.getSource()).isEqualTo((Object)new VideoSource().uri("/videos/vi4blUQJFrYWbaG44NChkH27/source"));
            Assertions.assertThat((Object)res.getAssets()).isEqualTo((Object)new VideoAssets().hls(URI.create("https://cdn.api.video/vod/vi4blUQJFrYWbaG44NChkH27/hls/manifest.m3u8")).iframe("<iframe src=\"https://embed.api.video/vod/vi4blUQJFrYWbaG44NChkH27\" width=\"100%\" height=\"100%\" frameborder=\"0\" scrolling=\"no\" allowfullscreen=\"\"></iframe>").player(URI.create("https://embed.api.video/vod/vi4blUQJFrYWbaG44NChkH27")).thumbnail(URI.create("https://cdn.api.video/vod/vi4blUQJFrYWbaG44NChkH27/thumbnail.jpg")).mp4(URI.create("https://cdn.api.video/vod/vi4blUQJFrYWbaG44NChkH27/mp4/source.mp4")));
        }

        @Test
        @DisplayName(value="400 response")
        public void responseWithStatus400Test() throws ApiException {
            VideosApiTest.this.answerOnAnyRequest(400, VideosApiTest.this.readResourceFile("/payloads/videos/update/responses/400.json"));
            ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> VideosApiTest.this.api.update("vi4blUQJFrYWbaG44NChkH27", new VideoUpdatePayload())).isInstanceOf(ApiException.class)).satisfies(e -> Assertions.assertThat((int)((ApiException)e).getCode()).isEqualTo(400))).hasMessage("This attribute must be a ISO-8601 date.");
        }

        @Test
        @DisplayName(value="404 response")
        public void responseWithStatus404Test() throws ApiException {
            VideosApiTest.this.answerOnAnyRequest(404, VideosApiTest.this.readResourceFile("/payloads/videos/update/responses/404.json"));
            ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> VideosApiTest.this.api.update("vi4blUQJFrYWbaG44NChkH27", new VideoUpdatePayload())).isInstanceOf(ApiException.class)).satisfies(e -> Assertions.assertThat((int)((ApiException)e).getCode()).isEqualTo(404))).hasMessage("The requested resource was not found.");
        }
    }

    @Nested
    @DisplayName(value="list")
    class list {
        private static final String PAYLOADS_PATH = "/payloads/videos/list/";

        list() {
        }

        @Test
        @DisplayName(value="200 response")
        public void responseWithStatus200Test() throws ApiException {
            VideosApiTest.this.answerOnAnyRequest(200, VideosApiTest.this.readResourceFile("/payloads/videos/list/responses/200.json"));
            Page page = VideosApiTest.this.api.list().execute();
            Assertions.assertThat((Integer)page.getCurrentPage()).isEqualTo(1);
            Assertions.assertThat((Integer)page.getPageSize()).isEqualTo(25);
            Assertions.assertThat((Integer)page.getPagesTotal()).isEqualTo(1);
            Assertions.assertThat((Integer)page.getCurrentPageItems()).isEqualTo(11);
            Assertions.assertThat((List)page.getItems()).hasSize(3);
            Video res1 = (Video)page.getItems().get(0);
            Assertions.assertThat((String)res1.getVideoId()).isEqualTo("vi4blUQJFrYWbaG44NChkH27");
            Assertions.assertThat((String)res1.getPlayerId()).isEqualTo("pl45KFKdlddgk654dspkze");
            Assertions.assertThat((String)res1.getTitle()).isEqualTo("Maths video");
            Assertions.assertThat((String)res1.getDescription()).isEqualTo("An amazing video explaining the string theory");
            Assertions.assertThat((Boolean)res1.getPublic()).isEqualTo(false);
            Assertions.assertThat((Boolean)res1.getPanoramic()).isEqualTo(false);
            Assertions.assertThat((Boolean)res1.getMp4Support()).isEqualTo(true);
            Assertions.assertThat((List)res1.getTags()).isEqualTo(Arrays.asList("maths", "string theory", "video"));
            Assertions.assertThat((List)res1.getMetadata()).isEqualTo(Arrays.asList(new Metadata("Author", "John Doe"), new Metadata("Format", "Tutorial")));
            Assertions.assertThat((Object)res1.getSource()).isEqualTo((Object)new VideoSource().uri("/videos/c188ed58-3403-46a2-b91b-44603d10b2c9/source"));
            Assertions.assertThat((Object)res1.getAssets()).isEqualTo((Object)new VideoAssets().hls(URI.create("https://cdn.api.video/vod/vi4blUQJFrYWbaG44NChkH27/hls/manifest.m3u8")).iframe("<iframe src=\"https://embed.api.video/vod/vi4blUQJFrYWbaG44NChkH27\" width=\"100%\" height=\"100%\" frameborder=\"0\" scrolling=\"no\" allowfullscreen=\"\"></iframe>").player(URI.create("https://embed.api.video/vod/vi4blUQJFrYWbaG44NChkH27")).thumbnail(URI.create("https://cdn.api.video/vod/vi4blUQJFrYWbaG44NChkH27/thumbnail.jpg")).mp4(URI.create("https://cdn.api.video/vod/vi4blUQJFrYWbaG44NChkH27/mp4/source.mp4")));
        }

        @Test
        @DisplayName(value="400 response")
        public void responseWithStatus400Test() throws ApiException {
            VideosApiTest.this.answerOnAnyRequest(400, VideosApiTest.this.readResourceFile("/payloads/videos/list/responses/400.json"));
            ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> VideosApiTest.this.api.list().execute()).isInstanceOf(ApiException.class)).satisfies(e -> Assertions.assertThat((int)((ApiException)e).getCode()).isEqualTo(400))).hasMessage("This parameter is out of the allowed range of values.");
        }
    }

    @Nested
    @DisplayName(value="getStatus")
    class getStatus {
        private static final String PAYLOADS_PATH = "/payloads/videos/getStatus/";

        getStatus() {
        }

        @Test
        @DisplayName(value="required parameters")
        public void requiredParametersTest() {
            VideosApiTest.this.answerOnAnyRequest(201, "{}");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> VideosApiTest.this.api.getStatus(null)).isInstanceOf(ApiException.class)).hasMessage("Missing the required parameter 'videoId' when calling getStatus");
            Assertions.assertThatNoException().isThrownBy(() -> VideosApiTest.this.api.getStatus("vi4blUQJFrYWbaG44NChkH27"));
        }

        @Test
        @DisplayName(value="200 response")
        public void responseWithStatus200Test() throws ApiException {
            VideosApiTest.this.answerOnAnyRequest(200, VideosApiTest.this.readResourceFile("/payloads/videos/getStatus/responses/200.json"));
            VideoStatus res = VideosApiTest.this.api.getStatus("vi4blUQJFrYWbaG44NChkH27");
            Assertions.assertThat((Comparable)res.getIngest().getStatus()).isEqualTo((Object)VideoStatusIngest.StatusEnum.UPLOADED);
            Assertions.assertThat((Integer)res.getIngest().getFilesize()).isEqualTo(273579401);
            Assertions.assertThat((List)res.getIngest().getReceivedBytes()).isEqualTo(Arrays.asList(new BytesRange().from(Integer.valueOf(0)).to(Integer.valueOf(0x7FFFFFF)).total(Integer.valueOf(273579401)), new BytesRange().from(Integer.valueOf(0x8000000)).to(Integer.valueOf(0xFFFFFFF)).total(Integer.valueOf(273579401)), new BytesRange().from(Integer.valueOf(0x10000000)).to(Integer.valueOf(273579400)).total(Integer.valueOf(273579401))));
            Assertions.assertThat((Boolean)res.getEncoding().getPlayable()).isTrue();
            Assertions.assertThat((List)res.getEncoding().getQualities()).isEqualTo(Arrays.asList(new Quality().quality(Quality.QualityEnum._360P).status(Quality.StatusEnum.ENCODED), new Quality().quality(Quality.QualityEnum._480P).status(Quality.StatusEnum.ENCODED), new Quality().quality(Quality.QualityEnum._720P).status(Quality.StatusEnum.ENCODED), new Quality().quality(Quality.QualityEnum._1080P).status(Quality.StatusEnum.ENCODING), new Quality().quality(Quality.QualityEnum._2160P).status(Quality.StatusEnum.WAITING)));
            Assertions.assertThat((Integer)res.getEncoding().getMetadata().getWidth()).isEqualTo(424);
            Assertions.assertThat((Integer)res.getEncoding().getMetadata().getHeight()).isEqualTo(240);
            Assertions.assertThat((BigDecimal)res.getEncoding().getMetadata().getBitrate()).isEqualTo((Object)BigDecimal.valueOf(411.218));
            Assertions.assertThat((Integer)res.getEncoding().getMetadata().getDuration()).isEqualTo(4176);
            Assertions.assertThat((Integer)res.getEncoding().getMetadata().getFramerate()).isEqualTo(24);
            Assertions.assertThat((Integer)res.getEncoding().getMetadata().getSamplerate()).isEqualTo(48000);
            Assertions.assertThat((String)res.getEncoding().getMetadata().getVideoCodec()).isEqualTo("h264");
            Assertions.assertThat((String)res.getEncoding().getMetadata().getAudioCodec()).isEqualTo("aac");
            Assertions.assertThat((String)res.getEncoding().getMetadata().getAspectRatio()).isEqualTo("16/9");
        }

        @Test
        @DisplayName(value="404 response")
        public void responseWithStatus404Test() throws ApiException {
            VideosApiTest.this.answerOnAnyRequest(404, VideosApiTest.this.readResourceFile("/payloads/videos/getStatus/responses/404.json"));
            ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> VideosApiTest.this.api.getStatus("vi4blUQJFrYWbaG44NChkH27")).isInstanceOf(ApiException.class)).satisfies(e -> Assertions.assertThat((int)((ApiException)e).getCode()).isEqualTo(404))).hasMessage("The requested resource was not found.");
        }
    }

    @Nested
    @DisplayName(value="uploadWithUploadToken")
    class uploadWithUploadToken {
        private static final String PAYLOADS_PATH = "/payloads/videos/uploadWithUploadToken/";

        uploadWithUploadToken() {
        }

        @Test
        @DisplayName(value="required parameters")
        public void requiredParametersTest() {
            VideosApiTest.this.answerOnAnyRequest(201, "{}");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> VideosApiTest.this.api.uploadWithUploadToken(null, new File(""))).isInstanceOf(ApiException.class)).hasMessage("Missing the required parameter 'token' when calling uploadWithUploadToken");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> VideosApiTest.this.api.uploadWithUploadToken("to1tcmSFHeYY5KzyhOqVKMKb", null)).isInstanceOf(ApiException.class)).hasMessage("Missing the required parameter 'file' when calling upload");
            Assertions.assertThatNoException().isThrownBy(() -> VideosApiTest.this.api.uploadWithUploadToken("to1tcmSFHeYY5KzyhOqVKMKb", new File("")));
        }

        @Test
        @DisplayName(value="201 response")
        public void responseWithStatus201Test() throws ApiException {
            VideosApiTest.this.answerOnAnyRequest(201, VideosApiTest.this.readResourceFile("/payloads/videos/uploadWithUploadToken/responses/201.json"));
            Video res = VideosApiTest.this.api.uploadWithUploadToken("to1tcmSFHeYY5KzyhOqVKMKb", new File(""));
            Assertions.assertThat((String)res.getVideoId()).isEqualTo("vi4k0jvEUuaTdRAEjQ4Jfrgz");
            Assertions.assertThat((String)res.getPlayerId()).isEqualTo("pl45KFKdlddgk654dspkze");
            Assertions.assertThat((String)res.getTitle()).isEqualTo("Maths video");
            Assertions.assertThat((String)res.getDescription()).isEqualTo("An amazing video explaining the string theory");
            Assertions.assertThat((Boolean)res.getPublic()).isEqualTo(false);
            Assertions.assertThat((Boolean)res.getPanoramic()).isEqualTo(false);
            Assertions.assertThat((List)res.getTags()).containsExactlyInAnyOrder((Object[])new String[]{"maths", "string theory", "video"});
            Assertions.assertThat((List)res.getMetadata()).containsExactlyInAnyOrder((Object[])new Metadata[]{new Metadata("Author", "John Doe"), new Metadata("Format", "Tutorial")});
            Assertions.assertThat((Object)res.getSource()).isEqualTo((Object)new VideoSource().uri("/videos/vi4k0jvEUuaTdRAEjQ4Jfrgz/source"));
            Assertions.assertThat((Object)res.getAssets()).isEqualTo((Object)new VideoAssets().hls(URI.create("https://cdn.api.video/vod/vi4blUQJFrYWbaG44NChkH27/hls/manifest.m3u8")).iframe("<iframe src=\"https://embed.api.video/vod/vi4blUQJFrYWbaG44NChkH27\" width=\"100%\" height=\"100%\" frameborder=\"0\" scrolling=\"no\" allowfullscreen=\"\"></iframe>").player(URI.create("https://embed.api.video/vod/vi4blUQJFrYWbaG44NChkH27")).thumbnail(URI.create("https://cdn.api.video/vod/vi4blUQJFrYWbaG44NChkH27/thumbnail.jpg")).mp4(URI.create("https://cdn.api.video/vod/vi4blUQJFrYWbaG44NChkH27/mp4/source.mp4")));
        }
    }

    @Nested
    @DisplayName(value="get")
    class get {
        private static final String PAYLOADS_PATH = "/payloads/videos/get/";

        get() {
        }

        @Test
        @DisplayName(value="required parameters")
        public void requiredParametersTest() {
            VideosApiTest.this.answerOnAnyRequest(201, "{}");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> VideosApiTest.this.api.get(null)).isInstanceOf(ApiException.class)).hasMessage("Missing the required parameter 'videoId' when calling get");
            Assertions.assertThatNoException().isThrownBy(() -> VideosApiTest.this.api.get("vi4blUQJFrYWbaG44NChkH27"));
        }

        @Test
        @DisplayName(value="200 response")
        public void responseWithStatus200Test() throws ApiException {
            VideosApiTest.this.answerOnAnyRequest(200, VideosApiTest.this.readResourceFile("/payloads/videos/get/responses/200.json"));
            Video res = VideosApiTest.this.api.get("videoId_example");
            Assertions.assertThat((String)res.getVideoId()).isEqualTo("vi4blUQJFrYWbaG44NChkH27");
            Assertions.assertThat((String)res.getPlayerId()).isEqualTo("pl45KFKdlddgk654dspkze");
            Assertions.assertThat((String)res.getTitle()).isEqualTo("Maths video");
            Assertions.assertThat((String)res.getDescription()).isEqualTo("An amazing video explaining string theory");
            Assertions.assertThat((Boolean)res.getPublic()).isEqualTo(false);
            Assertions.assertThat((Boolean)res.getPanoramic()).isEqualTo(false);
            Assertions.assertThat((Boolean)res.getMp4Support()).isEqualTo(true);
            Assertions.assertThat((List)res.getTags()).isEqualTo(Arrays.asList("maths", "string theory", "video"));
            Assertions.assertThat((List)res.getMetadata()).isEqualTo(Arrays.asList(new Metadata("Author", "John Doe"), new Metadata("Format", "Tutorial")));
            Assertions.assertThat((Object)res.getSource()).isEqualTo((Object)new VideoSource().uri("/videos/vi4blUQJFrYWbaG44NChkH27/source"));
            Assertions.assertThat((Object)res.getAssets()).isEqualTo((Object)new VideoAssets().hls(URI.create("https://cdn.api.video/vod/vi4blUQJFrYWbaG44NChkH27/hls/manifest.m3u8")).iframe("<iframe src=\"https://embed.api.video/vod/vi4blUQJFrYWbaG44NChkH27\" width=\"100%\" height=\"100%\" frameborder=\"0\" scrolling=\"no\" allowfullscreen=\"\"></iframe>").player(URI.create("https://embed.api.video/vod/vi4blUQJFrYWbaG44NChkH27")).thumbnail(URI.create("https://cdn.api.video/vod/vi4blUQJFrYWbaG44NChkH27/thumbnail.jpg")).mp4(URI.create("https://cdn.api.video/vod/vi4blUQJFrYWbaG44NChkH27/mp4/source.mp4")));
        }

        @Test
        @DisplayName(value="404 response")
        public void responseWithStatus404Test() throws ApiException {
            VideosApiTest.this.answerOnAnyRequest(404, VideosApiTest.this.readResourceFile("/payloads/videos/get/responses/404.json"));
            ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> VideosApiTest.this.api.get("videoId_example")).isInstanceOf(ApiException.class)).satisfies(e -> Assertions.assertThat((int)((ApiException)e).getCode()).isEqualTo(404))).hasMessage("The requested resource was not found.");
        }
    }

    @Nested
    @DisplayName(value="delete")
    class delete {
        private static final String PAYLOADS_PATH = "/payloads/videos/delete/";

        delete() {
        }

        @Test
        @DisplayName(value="required parameters")
        public void requiredParametersTest() {
            VideosApiTest.this.answerOnAnyRequest(201, "{}");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> VideosApiTest.this.api.delete(null)).isInstanceOf(ApiException.class)).hasMessage("Missing the required parameter 'videoId' when calling delete");
            Assertions.assertThatNoException().isThrownBy(() -> VideosApiTest.this.api.delete("vi4blUQJFrYWbaG44NChkH27"));
        }

        @Test
        @DisplayName(value="404 response")
        public void responseWithStatus404Test() throws ApiException {
            VideosApiTest.this.answerOnAnyRequest(404, VideosApiTest.this.readResourceFile("/payloads/videos/delete/responses/404.json"));
            ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> VideosApiTest.this.api.delete("vi4blUQJFrYWbaG44NChkH27")).isInstanceOf(ApiException.class)).satisfies(e -> Assertions.assertThat((int)((ApiException)e).getCode()).isEqualTo(404))).hasMessage("The requested resource was not found.");
        }
    }
}

