/*
 * Decompiled with CFR 0.152.
 */
package video.api.integration;

import java.io.File;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.MethodOrderer;
import org.junit.jupiter.api.Order;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.TestMethodOrder;
import org.junit.jupiter.api.condition.EnabledIfEnvironmentVariable;
import video.api.client.api.ApiException;
import video.api.client.api.models.Page;
import video.api.client.api.models.Video;
import video.api.client.api.models.VideoCreationPayload;
import video.api.client.api.models.VideoWatermark;
import video.api.client.api.models.Watermark;
import video.api.integration.AbstractTest;

@DisplayName(value="Integration tests of api.watermarks() methods")
@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@TestMethodOrder(value=MethodOrderer.OrderAnnotation.class)
@EnabledIfEnvironmentVariable(named="INTEGRATION_TESTS_API_KEY", matches=".+")
public class WatermarksTest
extends AbstractTest {
    private Watermark testWatermark;

    @Test
    @Order(value=1)
    public void createWatermark() throws ApiException {
        File jpgFile = new File(this.getClass().getResource("/assets/cat.jpg").getFile());
        this.testWatermark = this.apiClient.watermarks().upload(jpgFile);
    }

    @Test
    @Order(value=2)
    public void listWatermarks() throws ApiException {
        Page watermarks = this.apiClient.watermarks().list().execute();
        Assertions.assertThat((List)watermarks.getItems()).anyMatch(w -> w.getWatermarkId().equals(this.testWatermark.getWatermarkId()));
    }

    @Test
    @Order(value=3)
    public void createVideoWithWatermark() throws ApiException {
        Video video = this.apiClient.videos().create(new VideoCreationPayload().title("[java] video with watermark").watermark(new VideoWatermark().bottom("10px").id(this.testWatermark.getWatermarkId())));
        Assertions.assertThat((String)video.getVideoId()).isNotBlank();
        this.apiClient.videos().delete(video.getVideoId());
    }

    @Test
    @Order(value=4)
    public void deleteWatermark() throws ApiException {
        this.apiClient.watermarks().delete(this.testWatermark.getWatermarkId());
    }
}

