/*
 * Decompiled with CFR 0.152.
 */
package vip.breakpoint.factory;

import com.alibaba.fastjson.JSONObject;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vip.breakpoint.annotion.WebLogging;

public class LoggingMethodInterceptor
implements InvocationHandler {
    private static final Logger log = LoggerFactory.getLogger(LoggingMethodInterceptor.class);
    private List<String> methods;
    private WebLogging webLogging;
    private static SimpleDateFormat pdf;
    private Object target;

    public LoggingMethodInterceptor(WebLogging webLogging, Object target) {
        this.webLogging = webLogging;
        this.target = target;
        this.methods = Arrays.asList(webLogging.methods());
        pdf = new SimpleDateFormat(webLogging.timePattern());
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (this.methods.contains(method.getName())) {
            log.info("\u63a5\u53e3\u8bf7\u6c42\u6570\u636e:\u3010{}\u3011||\u65b9\u6cd5:\u3010{}\u3011|| \u65f6\u95f4:\u3010{}\u3011", new Object[]{JSONObject.toJSONString((Object)args), method.getName(), pdf.format(new Date())});
        }
        Object resVal = method.invoke(this.target, args);
        if (this.methods.contains(method.getName())) {
            log.info("\u63a5\u53e3\u8bf7\u6c42\u5b8c\u6210\uff0c\u8fdb\u884c\u8fd4\u56de\u7ed3\u679c\uff1a\u3010{}\u3011", (Object)JSONObject.toJSONString((Object)resVal));
        }
        return resVal;
    }
}

