/*
 * Decompiled with CFR 0.152.
 */
package vip.breakpoint.process;

import java.util.ArrayList;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import vip.breakpoint.annotion.WebLogging;
import vip.breakpoint.exception.MultiInterfaceBeansException;
import vip.breakpoint.factory.LoggingFactory;

public class LoggingBeanPostProcessor
implements BeanDefinitionRegistryPostProcessor,
BeanPostProcessor,
ApplicationContextAware {
    private ApplicationContext applicationContext;
    private BeanDefinitionRegistry registry;
    private ConfigurableListableBeanFactory beanFactory;

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        BeanDefinition beanDefinition = this.registry.getBeanDefinition(beanName);
        String beanClassName = beanDefinition.getBeanClassName();
        try {
            Object loggingProxyObject;
            WebLogging webLogging;
            Class<?> oriClass = Class.forName(beanClassName);
            Class<?> targetClass = this.getTargetClass(oriClass);
            if (null != targetClass && null != (webLogging = targetClass.getAnnotation(WebLogging.class)) && null != (loggingProxyObject = LoggingFactory.getLoggingProxyObject(this.applicationContext.getClassLoader(), webLogging, bean, targetClass))) {
                return loggingProxyObject;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return bean;
    }

    private Class<?> getTargetClass(Class<?> oriClass) throws BeansException {
        Class<?>[] interfaces = oriClass.getInterfaces();
        ArrayList candidate = new ArrayList();
        for (Class<?> klass : interfaces) {
            if (klass.getAnnotation(WebLogging.class) == null) continue;
            candidate.add(klass);
        }
        if (candidate.size() > 1) {
            throw new MultiInterfaceBeansException("there have multi interfaces from bean");
        }
        if (candidate.size() == 0) {
            return null;
        }
        return (Class)candidate.get(0);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
        this.registry = registry;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }
}

