/*
 * Decompiled with CFR 0.152.
 */
package wiki.xsx.core.mybatis;

import java.lang.reflect.Field;
import java.sql.Connection;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.mapping.ParameterMode;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.type.DateOnlyTypeHandler;
import org.apache.ibatis.type.TimeOnlyTypeHandler;
import org.apache.ibatis.type.TypeHandler;
import org.apache.ibatis.type.TypeHandlerRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Intercepts(value={@Signature(type=StatementHandler.class, method="prepare", args={Connection.class, Integer.class})})
public class MybatisSqlInterceptor
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger(MybatisSqlInterceptor.class);

    public Object intercept(Invocation invocation) throws Throwable {
        if (log.isDebugEnabled()) {
            try {
                log.debug("==>      MySQL: {}", (Object)this.replaceParameters((StatementHandler)invocation.getTarget()));
            }
            catch (Exception e) {
                log.debug("the sql is error !!!", (Throwable)e);
            }
        }
        return invocation.proceed();
    }

    public Object plugin(Object target) {
        if (target instanceof StatementHandler) {
            return Plugin.wrap((Object)this.getRealHandler(target), (Interceptor)this);
        }
        return target;
    }

    public void setProperties(Properties properties) {
    }

    private Object getRealHandler(Object target) {
        Class<?> clz = target.getClass();
        if (clz.getTypeName().contains("$")) {
            Field field = target.getClass().getSuperclass().getDeclaredField("h");
            field.setAccessible(true);
            Object obj = field.get(target);
            field = obj.getClass().getDeclaredField("target");
            field.setAccessible(true);
            return field.get(obj);
        }
        return target;
    }

    private String replaceParameters(StatementHandler target) {
        MetaObject metaObject = SystemMetaObject.forObject((Object)target);
        MappedStatement mappedStatement = (MappedStatement)metaObject.getValue("delegate.mappedStatement");
        BoundSql boundSql = target.getBoundSql();
        Object parameterObject = boundSql.getParameterObject();
        List parameterMappingList = boundSql.getParameterMappings();
        String sql = this.format(boundSql.getSql());
        StringBuilder builder = new StringBuilder();
        int index = 0;
        StringTokenizer tokenizer = new StringTokenizer(sql, "?");
        boolean hasMoreTokens = tokenizer.hasMoreTokens();
        while (hasMoreTokens) {
            builder.append(tokenizer.nextToken());
            hasMoreTokens = tokenizer.hasMoreTokens();
            if (hasMoreTokens) {
                this.setParameter(builder, mappedStatement, boundSql, parameterObject, (ParameterMapping)parameterMappingList.get(index));
            }
            ++index;
        }
        return builder.toString();
    }

    private String format(String original) {
        StringBuilder builder = new StringBuilder();
        StringTokenizer tokenizer = new StringTokenizer(original);
        while (tokenizer.hasMoreTokens()) {
            builder.append(tokenizer.nextToken());
            builder.append(' ');
        }
        return builder.toString();
    }

    private void setParameter(StringBuilder sqlBuilder, MappedStatement mappedStatement, BoundSql boundSql, Object parameterObject, ParameterMapping parameterMapping) {
        Configuration configuration = mappedStatement.getConfiguration();
        TypeHandlerRegistry typeHandlerRegistry = configuration.getTypeHandlerRegistry();
        if (parameterMapping.getMode() != ParameterMode.OUT) {
            String propertyName = parameterMapping.getProperty();
            Object value = boundSql.hasAdditionalParameter(propertyName) ? boundSql.getAdditionalParameter(propertyName) : (parameterObject == null ? null : (typeHandlerRegistry.hasTypeHandler(parameterObject.getClass()) ? parameterObject : configuration.newMetaObject(parameterObject).getValue(propertyName)));
            sqlBuilder.append(ParameterHandler.getValue(value, parameterMapping.getTypeHandler()));
        }
    }

    private static class ParameterHandler {
        private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        private static final DateTimeFormatter TIME_FORMATTER = DateTimeFormatter.ofPattern("HH:mm:ss");

        private ParameterHandler() {
        }

        static Object getValue(Object value, TypeHandler<?> typeHandler) {
            if (value == null) {
                return null;
            }
            if (value instanceof String) {
                return "'" + value + "'";
            }
            if (value instanceof Date) {
                return "'" + ParameterHandler.dateFormat((Date)value, typeHandler) + "'";
            }
            return value;
        }

        static String dateFormat(Date date, TypeHandler<?> typeHandler) {
            LocalDateTime localDateTime = date.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
            if (typeHandler instanceof DateOnlyTypeHandler) {
                return localDateTime.format(DATE_FORMATTER);
            }
            if (typeHandler instanceof TimeOnlyTypeHandler) {
                return localDateTime.format(TIME_FORMATTER);
            }
            return localDateTime.format(DATE_TIME_FORMATTER);
        }
    }
}

