/*
 * Decompiled with CFR 0.152.
 */
package xin.manong.weapon.alarm;

import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xin.manong.weapon.alarm.AlarmChannel;
import xin.manong.weapon.alarm.AlarmReceiver;

public class AlarmConfig {
    private static final Logger logger = LoggerFactory.getLogger(AlarmConfig.class);
    private static final int DEFAULT_MIN_ASYNC_ALARM_NUM = 10;
    private static final long DEFAULT_MIN_ASYNC_ALARM_TIME_INTERVAL_MS = 300000L;
    public int minAsyncAlarmNum = 10;
    public long minAsyncAlarmTimeIntervalMs = 300000L;
    public String alarmSenderClass;
    public String dingWebHookURL;
    public String dingWebHookSecret;
    public Map<String, Object> alarmSenderConfig;
    public List<AlarmReceiver> alarmReceivers;
    public Map<AlarmChannel, List<String>> channelReceiverMap;

    public boolean check() {
        if (StringUtils.isEmpty((CharSequence)this.dingWebHookURL) && !StringUtils.isEmpty((CharSequence)this.dingWebHookSecret) || !StringUtils.isEmpty((CharSequence)this.dingWebHookURL) && StringUtils.isEmpty((CharSequence)this.dingWebHookSecret)) {
            logger.error("ding web hook info is not enough");
            return false;
        }
        if (StringUtils.isEmpty((CharSequence)this.alarmSenderClass)) {
            logger.error("alarm sender class name is empty");
            return false;
        }
        if (this.alarmReceivers == null || this.alarmReceivers.isEmpty()) {
            logger.error("alarm receiver info is empty");
            return false;
        }
        if (this.channelReceiverMap == null || this.channelReceiverMap.isEmpty()) {
            logger.error("alarm channel receiver mapping is empty");
            return false;
        }
        for (AlarmReceiver alarmReceiver : this.alarmReceivers) {
            if (!StringUtils.isEmpty((CharSequence)alarmReceiver.uid)) continue;
            logger.error("alarm receiver uid is empty");
            return false;
        }
        for (Map.Entry entry : this.channelReceiverMap.entrySet()) {
            AlarmChannel alarmChannel = (AlarmChannel)((Object)entry.getKey());
            List receiverIDs = (List)entry.getValue();
            if (receiverIDs == null || receiverIDs.isEmpty()) {
                logger.error("alarm receiver info is empty for channel[{}]", (Object)alarmChannel.name());
                return false;
            }
            for (String receiverID : receiverIDs) {
                AlarmReceiver alarmReceiver = new AlarmReceiver();
                alarmReceiver.uid = receiverID;
                if (this.alarmReceivers.contains(alarmReceiver)) continue;
                logger.error("alarm receiver info is not found for uid[{}] and channel[{}]", (Object)receiverID, (Object)alarmChannel.name());
                return false;
            }
        }
        if (this.minAsyncAlarmNum <= 0) {
            this.minAsyncAlarmNum = 10;
        }
        if (this.minAsyncAlarmTimeIntervalMs <= 0L) {
            this.minAsyncAlarmTimeIntervalMs = 300000L;
        }
        return true;
    }
}

