/*
 * Decompiled with CFR 0.152.
 */
package xin.manong.weapon.alarm;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xin.manong.weapon.alarm.Alarm;
import xin.manong.weapon.alarm.AlarmConfig;
import xin.manong.weapon.alarm.AlarmSender;
import xin.manong.weapon.alarm.AlarmStatus;

public class AlarmMonitor
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(AlarmMonitor.class);
    private static final String NAME = "AlarmMonitor";
    private boolean running = false;
    private AlarmConfig config;
    private AlarmSender alarmSender;
    private Thread monitorThread;
    private BlockingQueue<Alarm> alarmQueue;

    public AlarmMonitor(AlarmSender alarmSender) {
        this.config = alarmSender.config;
        this.alarmSender = alarmSender;
        this.alarmQueue = alarmSender.alarmQueue;
    }

    public final void start() {
        logger.info("alarm monitor is starting ...");
        if (this.running || this.monitorThread != null && this.monitorThread.isAlive()) {
            logger.warn("alarm monitor has been started, ignore request");
            return;
        }
        this.running = true;
        this.monitorThread = new Thread((Runnable)this, NAME);
        this.monitorThread.start();
        logger.info("alarm monitor has been started");
    }

    public final void stop() {
        logger.info("alarm monitor is stopping ...");
        if (!this.running || this.monitorThread == null || !this.monitorThread.isAlive()) {
            logger.warn("alarm monitor has been stopped, ignore request");
            return;
        }
        this.running = false;
        if (this.monitorThread != null && this.monitorThread.isAlive()) {
            this.monitorThread.interrupt();
        }
        try {
            if (this.monitorThread != null) {
                this.monitorThread.join();
            }
        }
        catch (InterruptedException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        logger.info("alarm monitor has been stopped");
    }

    @Override
    public final void run() {
        while (this.running) {
            try {
                List<Alarm> alarms = this.combineAlarms(this.batchGetAlarms());
                for (Alarm alarm : alarms) {
                    this.alarmSender.send(alarm);
                }
                logger.info("alarm monitor finish processing alarms, sleep {} ms", (Object)this.config.minAsyncAlarmTimeIntervalMs);
                Thread.sleep(this.config.minAsyncAlarmTimeIntervalMs);
            }
            catch (Throwable t) {
                logger.warn(t.getMessage(), t);
            }
        }
    }

    private List<Alarm> batchGetAlarms() throws InterruptedException {
        Alarm alarm;
        ArrayList<Alarm> alarms = new ArrayList<Alarm>();
        while ((alarm = this.alarmQueue.poll(3L, TimeUnit.SECONDS)) != null) {
            alarms.add(alarm);
            if (alarms.size() < this.config.minAsyncAlarmNum) continue;
            break;
        }
        return alarms;
    }

    private List<Alarm> combineAlarms(List<Alarm> alarms) {
        HashMap groupAlarmMap = new HashMap();
        for (Alarm alarm : alarms) {
            Map messageCountMap;
            if (!groupAlarmMap.containsKey((Object)alarm.status)) {
                groupAlarmMap.put(alarm.status, new HashMap());
            }
            if (!(messageCountMap = (Map)groupAlarmMap.get((Object)alarm.status)).containsKey(alarm.content)) {
                messageCountMap.put(alarm.content, 0);
            }
            messageCountMap.put(alarm.content, (Integer)messageCountMap.get(alarm.content) + 1);
        }
        ArrayList<Alarm> combinedAlarms = new ArrayList<Alarm>();
        for (Map.Entry entry : groupAlarmMap.entrySet()) {
            AlarmStatus status = (AlarmStatus)((Object)entry.getKey());
            Map messageCountMap = (Map)entry.getValue();
            int messageCount = 0;
            for (Integer count : messageCountMap.values()) {
                messageCount += count.intValue();
            }
            String message = String.join((CharSequence)"\n", messageCountMap.keySet());
            Alarm combinedAlarm = new Alarm(messageCount > 1 ? String.format("\u5408\u5e76\u62a5\u8b66\u6570\u91cf[%d] %s", messageCount, message) : message, status);
            combinedAlarms.add(combinedAlarm);
        }
        return combinedAlarms;
    }
}

