/*
 * Decompiled with CFR 0.152.
 */
package xin.manong.weapon.alarm;

import java.net.URLEncoder;
import java.util.Base64;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xin.manong.weapon.alarm.Alarm;
import xin.manong.weapon.alarm.AlarmConfig;
import xin.manong.weapon.alarm.AlarmMonitor;

public abstract class AlarmSender {
    private static final Logger logger = LoggerFactory.getLogger(AlarmSender.class);
    private static final int ALARM_QUEUE_SIZE = 200;
    protected AlarmConfig config;
    BlockingQueue<Alarm> alarmQueue;
    private AlarmMonitor monitor;

    public AlarmSender(AlarmConfig config) {
        this.config = config;
        this.alarmQueue = new ArrayBlockingQueue<Alarm>(200);
        this.monitor = new AlarmMonitor(this);
    }

    public final boolean start() {
        logger.info("alarm sender is starting ...");
        if (this.config == null || !this.config.check()) {
            logger.error("invalid alarm config");
            return false;
        }
        if (!this.init()) {
            logger.error("init alarm sender failed");
            return false;
        }
        this.monitor.start();
        logger.info("alarm sender has been started");
        return true;
    }

    public final void stop() {
        logger.info("alarm sender is stopping ...");
        this.monitor.stop();
        this.destroy();
        logger.info("alarm sender has been stopped");
    }

    public final boolean submit(Alarm alarm) {
        if (alarm == null || StringUtils.isEmpty((CharSequence)alarm.content)) {
            logger.warn("alarm is null or alarm content is empty, ignore it");
            return false;
        }
        if (!this.alarmQueue.offer(alarm)) {
            logger.warn("async alarm queue is full, ignore it");
            return false;
        }
        return true;
    }

    protected final String signDingTalkWebHookURL() {
        if (StringUtils.isEmpty((CharSequence)this.config.dingWebHookURL)) {
            return null;
        }
        if (StringUtils.isEmpty((CharSequence)this.config.dingWebHookSecret)) {
            logger.warn("ding talk web hook secret is empty");
            return this.config.dingWebHookURL;
        }
        Long timestamp = System.currentTimeMillis();
        try {
            String sha256 = "HmacSHA256";
            String utf8Encoding = "UTF-8";
            Mac mac = Mac.getInstance(sha256);
            mac.init(new SecretKeySpec(this.config.dingWebHookSecret.getBytes(utf8Encoding), sha256));
            byte[] bytes = mac.doFinal(String.format("%d\n%s", timestamp, this.config.dingWebHookSecret).getBytes(utf8Encoding));
            String sign = URLEncoder.encode(new String(Base64.getEncoder().encode(bytes)), utf8Encoding);
            return String.format("%s&timestamp=%d&sign=%s", this.config.dingWebHookURL, timestamp, sign);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return this.config.dingWebHookURL;
        }
    }

    protected boolean init() {
        return true;
    }

    protected void destroy() {
    }

    public abstract boolean send(Alarm var1);
}

