/*
 * Decompiled with CFR 0.152.
 */
package xin.manong.weapon.aliyun.ons;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xin.manong.weapon.aliyun.ons.Subscribe;
import xin.manong.weapon.aliyun.secret.DynamicSecretConfig;

public class ONSConsumerConfig
extends DynamicSecretConfig {
    private static final Logger logger = LoggerFactory.getLogger(ONSConsumerConfig.class);
    private static final int DEFAULT_CONSUME_THREAD_NUM = 1;
    private static final int DEFAULT_MAX_CACHED_MESSAGE_NUM = 1000;
    public int consumeThreadNum = 1;
    public int maxCachedMessageNum = 1000;
    public String consumeId;
    public String serverURL;
    public List<Subscribe> subscribes = new ArrayList<Subscribe>();

    public void addSubscribe(Subscribe subscribe) {
        if (subscribe == null || !subscribe.check()) {
            return;
        }
        if (this.subscribes == null) {
            this.subscribes = new ArrayList<Subscribe>();
        }
        for (Subscribe s : this.subscribes) {
            if (s.topic == null || !s.topic.equals(subscribe.topic)) continue;
            logger.warn("topic[{}] has been subscribed", (Object)subscribe.topic);
            return;
        }
        this.subscribes.add(subscribe);
    }

    @Override
    public boolean check() {
        if (!super.check()) {
            return false;
        }
        if (StringUtils.isEmpty((CharSequence)this.serverURL)) {
            logger.error("server url is empty");
            return false;
        }
        if (StringUtils.isEmpty((CharSequence)this.consumeId)) {
            logger.error("consume id is empty");
            return false;
        }
        if (this.subscribes == null || this.subscribes.isEmpty()) {
            logger.error("missing subscribe list");
            return false;
        }
        for (Subscribe subscribe : this.subscribes) {
            if (subscribe.check()) continue;
            return false;
        }
        if (this.consumeThreadNum <= 0) {
            this.consumeThreadNum = 1;
        }
        if (this.maxCachedMessageNum <= 0) {
            this.maxCachedMessageNum = 1000;
        }
        return true;
    }
}

