/*
 * Decompiled with CFR 0.152.
 */
package xin.manong.weapon.aliyun.ots;

import com.alicloud.openservices.tablestore.ClientConfiguration;
import com.alicloud.openservices.tablestore.SyncClient;
import com.alicloud.openservices.tablestore.TableStoreException;
import com.alicloud.openservices.tablestore.model.Condition;
import com.alicloud.openservices.tablestore.model.DeleteRowRequest;
import com.alicloud.openservices.tablestore.model.DeleteRowResponse;
import com.alicloud.openservices.tablestore.model.GetRangeRequest;
import com.alicloud.openservices.tablestore.model.GetRangeResponse;
import com.alicloud.openservices.tablestore.model.GetRowRequest;
import com.alicloud.openservices.tablestore.model.GetRowResponse;
import com.alicloud.openservices.tablestore.model.PrimaryKey;
import com.alicloud.openservices.tablestore.model.PutRowRequest;
import com.alicloud.openservices.tablestore.model.PutRowResponse;
import com.alicloud.openservices.tablestore.model.RangeIteratorParameter;
import com.alicloud.openservices.tablestore.model.RangeRowQueryCriteria;
import com.alicloud.openservices.tablestore.model.Row;
import com.alicloud.openservices.tablestore.model.RowDeleteChange;
import com.alicloud.openservices.tablestore.model.RowPutChange;
import com.alicloud.openservices.tablestore.model.RowUpdateChange;
import com.alicloud.openservices.tablestore.model.SingleRowQueryCriteria;
import com.alicloud.openservices.tablestore.model.UpdateRowRequest;
import com.alicloud.openservices.tablestore.model.UpdateRowResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xin.manong.weapon.aliyun.ots.OTSClientConfig;
import xin.manong.weapon.aliyun.ots.OTSConverter;
import xin.manong.weapon.aliyun.ots.OTSStatus;
import xin.manong.weapon.aliyun.ots.RecordIterator;
import xin.manong.weapon.base.rebuild.RebuildManager;
import xin.manong.weapon.base.rebuild.Rebuildable;
import xin.manong.weapon.base.record.KVRecord;
import xin.manong.weapon.base.secret.DynamicSecret;

public class OTSClient
implements Rebuildable {
    private static final Logger logger = LoggerFactory.getLogger(OTSClient.class);
    private static final String ERR_CODE_CONDITION_CHECK_FAIL = "OTSConditionCheckFail";
    private OTSClientConfig config;
    private SyncClient syncClient;

    public OTSClient(OTSClientConfig config) {
        this.config = config;
        if (!this.config.check()) {
            throw new RuntimeException("ots client config is invalid");
        }
        this.build();
        if (this.config.dynamic) {
            RebuildManager.register((Rebuildable)this);
        }
    }

    public void close() {
        logger.info("OTS client is closing ...");
        if (this.config.dynamic) {
            RebuildManager.unregister((Rebuildable)this);
        }
        if (this.syncClient != null) {
            this.syncClient.shutdown();
        }
        logger.info("OTS client has been closed");
    }

    public void rebuild() {
        logger.info("OTS client is rebuilding ...");
        if (DynamicSecret.accessKey.equals(this.config.aliyunSecret.accessKey) && DynamicSecret.secretKey.equals(this.config.aliyunSecret.secretKey)) {
            logger.warn("secret is not changed, ignore OTS client rebuilding");
            return;
        }
        this.config.aliyunSecret.accessKey = DynamicSecret.accessKey;
        this.config.aliyunSecret.secretKey = DynamicSecret.secretKey;
        SyncClient prevClient = this.syncClient;
        this.build();
        if (prevClient != null) {
            prevClient.shutdown();
        }
        logger.info("OTS client rebuild success");
    }

    private void build() {
        ClientConfiguration clientConf = new ClientConfiguration();
        clientConf.setConnectionTimeoutInMillisecond(this.config.connectionTimeoutMs);
        clientConf.setSocketTimeoutInMillisecond(this.config.socketTimeoutMs);
        clientConf.setConnectionRequestTimeoutInMillisecond(this.config.connectionRequestTimeoutMs);
        this.syncClient = new SyncClient(this.config.endpoint, this.config.aliyunSecret.accessKey, this.config.aliyunSecret.secretKey, this.config.instance, clientConf);
    }

    public RecordIterator rangeIterator(String tableName, Map<String, Object> startKeyMap, Map<String, Object> endKeyMap) {
        if (StringUtils.isEmpty((CharSequence)tableName)) {
            throw new RuntimeException("table is empty");
        }
        PrimaryKey startPrimaryKey = OTSConverter.convertPrimaryKey(startKeyMap);
        PrimaryKey endPrimaryKey = OTSConverter.convertPrimaryKey(endKeyMap);
        if (startKeyMap.size() != endKeyMap.size() || !startKeyMap.keySet().containsAll(endKeyMap.keySet())) {
            throw new RuntimeException("start keys and end keys are not consistent");
        }
        RangeIteratorParameter rangeIteratorParameter = new RangeIteratorParameter(tableName);
        rangeIteratorParameter.setInclusiveStartPrimaryKey(startPrimaryKey);
        rangeIteratorParameter.setExclusiveEndPrimaryKey(endPrimaryKey);
        rangeIteratorParameter.setMaxVersions(1);
        Iterator iterator = this.syncClient.createRangeIterator(rangeIteratorParameter);
        return new RecordIterator(iterator);
    }

    public List<KVRecord> getRange(String tableName, Map<String, Object> startKeyMap, Map<String, Object> endKeyMap) {
        if (StringUtils.isEmpty((CharSequence)tableName)) {
            throw new RuntimeException("table is empty");
        }
        PrimaryKey startPrimaryKey = OTSConverter.convertPrimaryKey(startKeyMap);
        PrimaryKey endPrimaryKey = OTSConverter.convertPrimaryKey(endKeyMap);
        if (startKeyMap.size() != endKeyMap.size() || !startKeyMap.keySet().containsAll(endKeyMap.keySet())) {
            throw new RuntimeException("start keys and end keys are not consistent");
        }
        RangeRowQueryCriteria rangeRowQueryCriteria = new RangeRowQueryCriteria(tableName);
        rangeRowQueryCriteria.setInclusiveStartPrimaryKey(startPrimaryKey);
        rangeRowQueryCriteria.setExclusiveEndPrimaryKey(endPrimaryKey);
        rangeRowQueryCriteria.setMaxVersions(1);
        ArrayList<KVRecord> kvRecords = new ArrayList<KVRecord>();
        while (true) {
            GetRangeResponse response = this.syncClient.getRange(new GetRangeRequest(rangeRowQueryCriteria));
            for (Row row : response.getRows()) {
                if (row == null) continue;
                KVRecord kvRecord = OTSConverter.convertRecord(row);
                kvRecords.add(kvRecord);
            }
            PrimaryKey nextPrimaryKey = response.getNextStartPrimaryKey();
            if (nextPrimaryKey == null) break;
            rangeRowQueryCriteria.setInclusiveStartPrimaryKey(nextPrimaryKey);
        }
        return kvRecords;
    }

    public KVRecord get(String tableName, Map<String, Object> keyMap) {
        if (StringUtils.isEmpty((CharSequence)tableName)) {
            throw new RuntimeException("table is empty");
        }
        PrimaryKey primaryKey = OTSConverter.convertPrimaryKey(keyMap);
        SingleRowQueryCriteria criteria = new SingleRowQueryCriteria(tableName, primaryKey);
        criteria.setMaxVersions(1);
        for (int i = 0; i < this.config.retryCnt; ++i) {
            try {
                GetRowResponse response = this.syncClient.getRow(new GetRowRequest(criteria));
                Row row = response.getRow();
                return row == null ? null : OTSConverter.convertRecord(row);
            }
            catch (Exception e) {
                logger.error("get failed for table[{}] and primary keys[{}], retry {} times", new Object[]{tableName, primaryKey.toString(), i + 1});
                logger.error(e.getMessage(), (Throwable)e);
                continue;
            }
        }
        return null;
    }

    public OTSStatus delete(String tableName, Map<String, Object> keyMap, Condition condition) {
        if (StringUtils.isEmpty((CharSequence)tableName)) {
            throw new RuntimeException("table is empty");
        }
        PrimaryKey primaryKey = OTSConverter.convertPrimaryKey(keyMap);
        RowDeleteChange change = new RowDeleteChange(tableName, primaryKey);
        if (condition != null) {
            change.setCondition(condition);
        }
        try {
            DeleteRowResponse response = this.syncClient.deleteRow(new DeleteRowRequest(change));
            return response == null ? OTSStatus.FAIL : OTSStatus.SUCCESS;
        }
        catch (Exception e) {
            if (e instanceof TableStoreException && ERR_CODE_CONDITION_CHECK_FAIL.equals(((TableStoreException)e).getErrorCode())) {
                logger.warn("delete condition check failed for table[{}] and primary keys[{}]", (Object)tableName, (Object)primaryKey.toString());
                return OTSStatus.CHECK_CONDITION_FAIL;
            }
            logger.error("delete failed for table[{}] and primary keys[{}]", (Object)tableName, (Object)primaryKey.toString());
            logger.error(e.getMessage(), (Throwable)e);
            return OTSStatus.FAIL;
        }
    }

    public OTSStatus put(String tableName, KVRecord kvRecord, Condition condition) {
        if (StringUtils.isEmpty((CharSequence)tableName)) {
            throw new RuntimeException("table name is empty");
        }
        Row record = OTSConverter.convertRecord(kvRecord);
        RowPutChange change = new RowPutChange(tableName, record.getPrimaryKey());
        change.addColumns(record.getColumns());
        if (condition != null) {
            change.setCondition(condition);
        }
        for (int i = 0; i < this.config.retryCnt; ++i) {
            try {
                PutRowResponse response = this.syncClient.putRow(new PutRowRequest(change));
                return response == null ? OTSStatus.FAIL : OTSStatus.SUCCESS;
            }
            catch (Exception e) {
                if (e instanceof TableStoreException && ERR_CODE_CONDITION_CHECK_FAIL.equals(((TableStoreException)e).getErrorCode())) {
                    logger.debug("put condition failed for table[{}] and primary keys[{}]", (Object)tableName, (Object)record.getPrimaryKey().toString());
                    return OTSStatus.CHECK_CONDITION_FAIL;
                }
                logger.error("put failed for table[{}] and primary keys[{}], retry {} times", new Object[]{tableName, record.getPrimaryKey().toString(), i + 1});
                logger.error(e.getMessage(), (Throwable)e);
                continue;
            }
        }
        return OTSStatus.FAIL;
    }

    public OTSStatus update(String tableName, KVRecord kvRecord, Condition condition) {
        if (StringUtils.isEmpty((CharSequence)tableName)) {
            throw new RuntimeException("table is empty");
        }
        Row record = OTSConverter.convertRecord(kvRecord);
        RowUpdateChange change = new RowUpdateChange(tableName, record.getPrimaryKey());
        change.put(Arrays.asList(record.getColumns()));
        if (condition != null) {
            change.setCondition(condition);
        }
        for (int i = 0; i < this.config.retryCnt; ++i) {
            try {
                UpdateRowResponse response = this.syncClient.updateRow(new UpdateRowRequest(change));
                return response == null ? OTSStatus.FAIL : OTSStatus.SUCCESS;
            }
            catch (Exception e) {
                if (e instanceof TableStoreException && ERR_CODE_CONDITION_CHECK_FAIL.equals(((TableStoreException)e).getErrorCode())) {
                    logger.warn("update condition check failed for table[{}] and primary keys[{}]", (Object)tableName, (Object)record.getPrimaryKey().toString());
                    return OTSStatus.CHECK_CONDITION_FAIL;
                }
                logger.error("update failed for table[{}] and primary keys[{}], retry {} times", new Object[]{tableName, record.getPrimaryKey().toString(), i + 1});
                logger.error(e.getMessage(), (Throwable)e);
                continue;
            }
        }
        return OTSStatus.FAIL;
    }
}

