/*
 * Decompiled with CFR 0.152.
 */
package xin.manong.weapon.aliyun.ots;

import com.alibaba.fastjson.JSON;
import com.alicloud.openservices.tablestore.model.Column;
import com.alicloud.openservices.tablestore.model.ColumnType;
import com.alicloud.openservices.tablestore.model.ColumnValue;
import com.alicloud.openservices.tablestore.model.PrimaryKey;
import com.alicloud.openservices.tablestore.model.PrimaryKeyBuilder;
import com.alicloud.openservices.tablestore.model.PrimaryKeyColumn;
import com.alicloud.openservices.tablestore.model.PrimaryKeyType;
import com.alicloud.openservices.tablestore.model.PrimaryKeyValue;
import com.alicloud.openservices.tablestore.model.RecordColumn;
import com.alicloud.openservices.tablestore.model.Row;
import com.alicloud.openservices.tablestore.model.StreamRecord;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xin.manong.weapon.base.record.KVRecord;
import xin.manong.weapon.base.record.RecordType;

public class OTSConverter {
    private static final Logger logger = LoggerFactory.getLogger(OTSConverter.class);

    public static KVRecord convertStreamRecord(StreamRecord streamRecord) {
        if (streamRecord == null) {
            return null;
        }
        Map<String, Object> keyMap = OTSConverter.convertPrimaryKey(streamRecord.getPrimaryKey());
        if (keyMap.isEmpty()) {
            return null;
        }
        KVRecord kvRecord = new KVRecord(new HashSet<String>(keyMap.keySet()), keyMap);
        StreamRecord.RecordType recordType = streamRecord.getRecordType();
        if (recordType != null) {
            kvRecord.setRecordType(RecordType.valueOf((String)recordType.name()));
        }
        if (kvRecord.getRecordType() == RecordType.DELETE) {
            return kvRecord;
        }
        Map<String, Object> fieldMap = OTSConverter.convertRecordColumns(streamRecord.getColumns());
        kvRecord.getFieldMap().putAll(fieldMap);
        return kvRecord;
    }

    public static KVRecord convertRecord(Row row) {
        if (row == null) {
            throw new RuntimeException("convert row is null");
        }
        KVRecord kvRecord = new KVRecord();
        PrimaryKey primaryKey = row.getPrimaryKey();
        for (PrimaryKeyColumn primaryKeyColumn : primaryKey.getPrimaryKeyColumns()) {
            kvRecord.put(primaryKeyColumn.getName(), OTSConverter.convertPrimaryKeyValue(primaryKeyColumn.getValue()));
        }
        kvRecord.setKeys(primaryKey.getPrimaryKeyColumnsMap().keySet());
        for (String name : row.getColumnsMap().keySet()) {
            Column column = row.getLatestColumn(name);
            if (column == null) continue;
            kvRecord.put(name, OTSConverter.convertColumnValue(column.getValue()));
        }
        return kvRecord;
    }

    public static Row convertRecord(KVRecord kvRecord) {
        if (kvRecord == null || kvRecord.isEmpty()) {
            throw new RuntimeException("convert record is null or empty");
        }
        if (CollectionUtils.isEmpty((Collection)kvRecord.getKeys())) {
            throw new RuntimeException("convert keys are empty");
        }
        HashMap<String, Object> keyMap = new HashMap<String, Object>();
        HashMap<String, Object> columnMap = new HashMap<String, Object>();
        for (Map.Entry entry : kvRecord.getFieldMap().entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (kvRecord.getKeys().contains(key)) {
                keyMap.put(key, value);
                continue;
            }
            columnMap.put(key, value instanceof JSON ? value.toString() : value);
        }
        if (keyMap.size() != kvRecord.getKeys().size()) {
            throw new RuntimeException("missing primary keys");
        }
        return new Row(OTSConverter.convertPrimaryKey(keyMap), OTSConverter.convertColumns(columnMap));
    }

    public static Map<String, Object> convertPrimaryKey(PrimaryKey primaryKey) {
        HashMap<String, Object> keyMap = new HashMap<String, Object>();
        PrimaryKeyColumn[] primaryKeyColumns = primaryKey.getPrimaryKeyColumns();
        if (primaryKeyColumns == null) {
            return keyMap;
        }
        for (int i = 0; i < primaryKeyColumns.length; ++i) {
            String name = primaryKeyColumns[i].getName();
            PrimaryKeyValue primaryKeyValue = primaryKeyColumns[i].getValue();
            keyMap.put(name, OTSConverter.convertPrimaryKeyValue(primaryKeyValue));
        }
        return keyMap;
    }

    public static PrimaryKey convertPrimaryKey(Map<String, Object> keyMap) {
        if (keyMap == null || keyMap.isEmpty()) {
            throw new RuntimeException("primary keys are empty");
        }
        PrimaryKeyBuilder builder = PrimaryKeyBuilder.createPrimaryKeyBuilder();
        for (Map.Entry<String, Object> entry : keyMap.entrySet()) {
            PrimaryKeyValue primaryKeyValue;
            Object value = entry.getValue();
            OTSConverter.checkPrimaryKey(value);
            if (value instanceof Integer) {
                primaryKeyValue = PrimaryKeyValue.fromLong((long)((Integer)value).longValue());
                builder.addPrimaryKeyColumn(entry.getKey(), primaryKeyValue);
                continue;
            }
            if (value instanceof Long) {
                primaryKeyValue = PrimaryKeyValue.fromLong((long)((Long)value));
                builder.addPrimaryKeyColumn(entry.getKey(), primaryKeyValue);
                continue;
            }
            if (value instanceof byte[]) {
                primaryKeyValue = PrimaryKeyValue.fromBinary((byte[])((byte[])value));
                builder.addPrimaryKeyColumn(entry.getKey(), primaryKeyValue);
                continue;
            }
            if (value == PrimaryKeyValue.INF_MIN || value == PrimaryKeyValue.INF_MAX) {
                builder.addPrimaryKeyColumn(entry.getKey(), (PrimaryKeyValue)value);
                continue;
            }
            primaryKeyValue = PrimaryKeyValue.fromString((String)((String)value));
            builder.addPrimaryKeyColumn(entry.getKey(), primaryKeyValue);
        }
        return builder.build();
    }

    public static Map<String, Object> convertRecordColumns(List<RecordColumn> recordColumns) {
        HashMap<String, Object> columnMap = new HashMap<String, Object>();
        for (RecordColumn recordColumn : recordColumns) {
            RecordColumn.ColumnType columnType = recordColumn.getColumnType();
            if (columnType == RecordColumn.ColumnType.DELETE_ALL_VERSION || columnType == RecordColumn.ColumnType.DELETE_ONE_VERSION) continue;
            Column column = recordColumn.getColumn();
            columnMap.put(column.getName(), OTSConverter.convertColumnValue(column.getValue()));
        }
        return columnMap;
    }

    public static List<Column> convertColumns(Map<String, Object> columnMap) {
        if (columnMap == null || columnMap.isEmpty()) {
            throw new RuntimeException("column map is empty");
        }
        ArrayList<Column> columns = new ArrayList<Column>();
        for (Map.Entry<String, Object> entry : columnMap.entrySet()) {
            Object value = entry.getValue();
            if (!OTSConverter.checkColumn(value)) continue;
            ColumnValue columnValue = value instanceof Integer ? ColumnValue.fromLong((long)((Integer)value).longValue()) : (value instanceof Long ? ColumnValue.fromLong((long)((Long)value)) : (value instanceof Float ? ColumnValue.fromDouble((double)((Float)value).doubleValue()) : (value instanceof Double ? ColumnValue.fromDouble((double)((Double)value)) : (value instanceof Boolean ? ColumnValue.fromBoolean((boolean)((Boolean)value)) : (value instanceof byte[] ? ColumnValue.fromBinary((byte[])((byte[])value)) : ColumnValue.fromString((String)((String)value)))))));
            columns.add(new Column(entry.getKey(), columnValue));
        }
        return columns;
    }

    private static void checkPrimaryKey(Object keyValue) {
        if (keyValue instanceof String) {
            return;
        }
        if (keyValue instanceof Integer) {
            return;
        }
        if (keyValue instanceof Long) {
            return;
        }
        if (keyValue instanceof byte[]) {
            return;
        }
        if (keyValue == PrimaryKeyValue.INF_MIN) {
            return;
        }
        if (keyValue == PrimaryKeyValue.INF_MAX) {
            return;
        }
        logger.error("unexpected primary key type[{}]", (Object)keyValue.getClass().getName());
        throw new RuntimeException(String.format("unexpected primary key type[%s]", keyValue.getClass().getName()));
    }

    private static boolean checkColumn(Object columnValue) {
        if (columnValue instanceof String) {
            return true;
        }
        if (columnValue instanceof Integer) {
            return true;
        }
        if (columnValue instanceof Float) {
            return true;
        }
        if (columnValue instanceof Double) {
            return true;
        }
        if (columnValue instanceof Long) {
            return true;
        }
        if (columnValue instanceof Boolean) {
            return true;
        }
        if (columnValue instanceof byte[]) {
            return true;
        }
        logger.warn("unexpected column value type[{}]", (Object)columnValue.getClass().getName());
        return false;
    }

    private static Object convertPrimaryKeyValue(PrimaryKeyValue primaryKeyValue) {
        if (primaryKeyValue.isInfMax() || primaryKeyValue.isInfMin()) {
            return primaryKeyValue;
        }
        PrimaryKeyType primaryKeyType = primaryKeyValue.getType();
        if (primaryKeyType == PrimaryKeyType.BINARY) {
            return primaryKeyValue.asBinary();
        }
        if (primaryKeyType == PrimaryKeyType.STRING) {
            return primaryKeyValue.asString();
        }
        if (primaryKeyType == PrimaryKeyType.INTEGER) {
            return primaryKeyValue.asLong();
        }
        throw new RuntimeException(String.format("invalid primary key type[{}]", primaryKeyType.name()));
    }

    private static Object convertColumnValue(ColumnValue columnValue) {
        ColumnType columnType = columnValue.getType();
        if (columnType == ColumnType.BINARY) {
            return columnValue.asBinary();
        }
        if (columnType == ColumnType.BOOLEAN) {
            return columnValue.asBoolean();
        }
        if (columnType == ColumnType.DOUBLE) {
            return columnValue.asDouble();
        }
        if (columnType == ColumnType.INTEGER) {
            return columnValue.asLong();
        }
        if (columnType == ColumnType.STRING) {
            return columnValue.asString();
        }
        throw new RuntimeException(String.format("invalid column value type[{}]", columnType.name()));
    }
}

