/*
 * Decompiled with CFR 0.152.
 */
package xin.manong.weapon.aliyun.ots;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xin.manong.weapon.aliyun.ots.OTSTunnelWorkerConfig;
import xin.manong.weapon.aliyun.secret.DynamicSecretConfig;

public class OTSTunnelConfig
extends DynamicSecretConfig {
    private static final Logger logger = LoggerFactory.getLogger(OTSTunnelConfig.class);
    public String endpoint;
    public String instance;
    public List<OTSTunnelWorkerConfig> workerConfigs = new ArrayList<OTSTunnelWorkerConfig>();

    public boolean addTunnelWorkerConfig(OTSTunnelWorkerConfig workerConfig) {
        if (workerConfig == null || !workerConfig.check()) {
            return false;
        }
        if (this.workerConfigs == null) {
            this.workerConfigs = new ArrayList<OTSTunnelWorkerConfig>();
        }
        for (OTSTunnelWorkerConfig config : this.workerConfigs) {
            if (!config.equals(workerConfig)) continue;
            logger.warn("worker config[{}/{}] has existed", (Object)workerConfig.table, (Object)workerConfig.tunnel);
            return false;
        }
        this.workerConfigs.add(workerConfig);
        return true;
    }

    public void removeTunnelWorkerConfig(OTSTunnelWorkerConfig workerConfig) {
        if (workerConfig == null) {
            return;
        }
        if (StringUtils.isEmpty((CharSequence)workerConfig.table)) {
            logger.warn("table is null, ignore remove request");
            return;
        }
        if (StringUtils.isEmpty((CharSequence)workerConfig.tunnel)) {
            logger.warn("tunnel is null, ignore remove request");
            return;
        }
        if (!this.workerConfigs.remove(workerConfig)) {
            logger.warn("tunnel worker[{}/{}] is not found", (Object)workerConfig.table, (Object)workerConfig.tunnel);
        }
    }

    @Override
    public boolean check() {
        if (!super.check()) {
            return false;
        }
        if (StringUtils.isEmpty((CharSequence)this.instance)) {
            logger.error("oss instance is empty");
            return false;
        }
        if (StringUtils.isEmpty((CharSequence)this.endpoint)) {
            logger.error("oss endpoint is empty");
            return false;
        }
        for (OTSTunnelWorkerConfig workerConfig : this.workerConfigs) {
            if (workerConfig.check()) continue;
            return false;
        }
        return true;
    }
}

