/*
 * Decompiled with CFR 0.152.
 */
package xin.manong.weapon.aliyun.ots;

import com.alicloud.openservices.tablestore.tunnel.worker.IChannelProcessor;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OTSTunnelWorkerConfig {
    private static final Logger logger = LoggerFactory.getLogger(OTSTunnelWorkerConfig.class);
    private static final int DEFAULT_CONSUME_THREAD_NUM = 5;
    private static final int DEFAULT_HEARTBEAT_INTERVAL_SEC = 30;
    private static final int DEFAULT_MAX_CONSUME_DELAY_MS = 60000;
    private static final int DEFAULT_MAX_RETRY_INTERVAL_MS = 200;
    private static final int DEFAULT_MAX_CHANNEL_PARALLEL = -1;
    private static final int MAX_CONSUME_THREAD_NUM = 32;
    public int consumeThreadNum = 5;
    public int heartBeatIntervalSec = 30;
    public int maxRetryIntervalMs = 200;
    public int maxChannelParallel = -1;
    public long maxConsumeDelayMs = 60000L;
    public String table;
    public String tunnel;
    public IChannelProcessor channelProcessor;

    public boolean check() {
        if (this.channelProcessor == null) {
            logger.error("channel processor is null");
            return false;
        }
        if (StringUtils.isEmpty((CharSequence)this.table)) {
            logger.error("table is empty");
            return false;
        }
        if (StringUtils.isEmpty((CharSequence)this.tunnel)) {
            logger.error("tunnel is empty");
            return false;
        }
        if (this.consumeThreadNum <= 0) {
            this.consumeThreadNum = 5;
        }
        if (this.heartBeatIntervalSec <= 0) {
            this.heartBeatIntervalSec = 30;
        }
        if (this.maxRetryIntervalMs <= 0) {
            this.maxRetryIntervalMs = 200;
        }
        if (this.maxConsumeDelayMs <= 0L) {
            this.maxConsumeDelayMs = 60000L;
        }
        if (this.consumeThreadNum > 32) {
            this.consumeThreadNum = 32;
        }
        return true;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof OTSTunnelWorkerConfig)) {
            return false;
        }
        OTSTunnelWorkerConfig workerConfig = (OTSTunnelWorkerConfig)object;
        if (workerConfig.tunnel == null && this.tunnel != null) {
            return false;
        }
        if (workerConfig.tunnel != null && this.tunnel == null) {
            return false;
        }
        if (workerConfig.table == null && this.table != null) {
            return false;
        }
        if (workerConfig.table != null && this.table == null) {
            return false;
        }
        if (workerConfig.table == this.table && workerConfig.tunnel == this.tunnel) {
            return true;
        }
        return workerConfig.tunnel.equals(this.tunnel) && workerConfig.table.equals(this.table);
    }

    public int hashCode() {
        int hash = this.table == null ? 0 : this.table.hashCode();
        hash = this.tunnel == null ? hash : hash * 31 + this.tunnel.hashCode();
        return hash;
    }
}

