/*
 * Decompiled with CFR 0.152.
 */
package xin.manong.weapon.aliyun.ots;

import com.alicloud.openservices.tablestore.TunnelClient;
import com.alicloud.openservices.tablestore.model.tunnel.ChannelInfo;
import com.alicloud.openservices.tablestore.model.tunnel.DescribeTunnelRequest;
import com.alicloud.openservices.tablestore.model.tunnel.DescribeTunnelResponse;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xin.manong.weapon.alarm.Alarm;
import xin.manong.weapon.alarm.AlarmSender;
import xin.manong.weapon.alarm.AlarmStatus;
import xin.manong.weapon.aliyun.ots.OTSTunnelConfig;
import xin.manong.weapon.aliyun.ots.OTSTunnelWorkerConfig;

public class OTSTunnelMonitor
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(OTSTunnelMonitor.class);
    private static final long DEFAULT_CHECK_TIME_INTERVAL_MS = 600000L;
    private boolean running = false;
    private long checkTimeIntervalMs = 600000L;
    private String appName;
    private OTSTunnelConfig tunnelConfig;
    private TunnelClient tunnelClient;
    private AlarmSender alarmSender;
    private Thread workThread;

    public OTSTunnelMonitor(OTSTunnelConfig tunnelConfig, TunnelClient tunnelClient) {
        this.tunnelConfig = tunnelConfig;
        this.tunnelClient = tunnelClient;
    }

    public void start() {
        logger.info("OTSTunnel monitor is starting ...");
        this.running = true;
        this.workThread = new Thread((Runnable)this, "TunnelMonitor");
        this.workThread.start();
        logger.info("tunnel monitor has been started");
    }

    public void stop() {
        logger.info("tunnel monitor is stopping ...");
        this.running = false;
        if (this.workThread.isAlive()) {
            this.workThread.interrupt();
        }
        try {
            this.workThread.join();
        }
        catch (InterruptedException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        logger.info("tunnel monitor has been stopped");
    }

    @Override
    public void run() {
        while (this.running) {
            for (OTSTunnelWorkerConfig workerConfig : this.tunnelConfig.workerConfigs) {
                this.check(workerConfig);
            }
            logger.info("tunnel monitor is running, sleep {} ms", (Object)this.checkTimeIntervalMs);
            try {
                Thread.sleep(this.checkTimeIntervalMs);
            }
            catch (InterruptedException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private void check(OTSTunnelWorkerConfig workerConfig) {
        DescribeTunnelRequest request = new DescribeTunnelRequest(workerConfig.table, workerConfig.tunnel);
        DescribeTunnelResponse response = this.tunnelClient.describeTunnel(request);
        List channels = response.getChannelInfos();
        int delayChannelNum = 0;
        long currentTimestamp = System.currentTimeMillis();
        for (ChannelInfo channel : channels) {
            long timeInterval;
            long consumeTimestamp = channel.getChannelConsumePoint().getTime();
            if (consumeTimestamp <= 0L || (timeInterval = currentTimestamp - consumeTimestamp) < workerConfig.maxConsumeDelayMs) continue;
            logger.warn("consume delay[{}] for channel[{}] in tunnel[{}] of table[{}]", new Object[]{timeInterval, channel.getChannelId(), workerConfig.tunnel, workerConfig.table, timeInterval});
            ++delayChannelNum;
        }
        if (delayChannelNum > 0) {
            Alarm alarm = new Alarm(String.format("OTS\u901a\u9053[%s:%s]\u6570\u636e\u5806\u79ef: \u5806\u79efchannel\u6570\u91cf[%d], \u8d85\u8fc7\u6700\u5927\u6d88\u8d39\u5ef6\u65f6[%d]ms", workerConfig.table, workerConfig.tunnel, delayChannelNum, workerConfig.maxConsumeDelayMs), AlarmStatus.ERROR).setAppName(this.appName).setTitle("OTS\u901a\u9053\u6570\u636e\u5806\u79ef\u62a5\u8b66");
            if (this.alarmSender != null) {
                this.alarmSender.send(alarm);
            }
        }
    }

    public void setAlarmSender(AlarmSender alarmSender) {
        this.alarmSender = alarmSender;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }
}

