/*
 * Decompiled with CFR 0.152.
 */
package xin.manong.weapon.aliyun.ons;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xin.manong.weapon.aliyun.ons.Subscribe;
import xin.manong.weapon.aliyun.secret.DynamicSecretConfig;

public class ONSConsumerConfig
extends DynamicSecretConfig {
    private static final Logger logger = LoggerFactory.getLogger(ONSConsumerConfig.class);
    private static final int DEFAULT_CONSUME_THREAD_NUM = 1;
    private static final int DEFAULT_MAX_CACHED_MESSAGE_NUM = 1000;
    public int consumeThreadNum = 1;
    public int maxCachedMessageNum = 1000;
    public String consumeId;
    public String serverURL;
    public List<Subscribe> subscribes = new ArrayList<Subscribe>();

    public void addSubscribe(Subscribe subscribe) {
        if (subscribe == null || !subscribe.check()) {
            return;
        }
        if (this.subscribes == null) {
            this.subscribes = new ArrayList<Subscribe>();
        }
        for (Subscribe s : this.subscribes) {
            if (s.topic == null || !s.topic.equals(subscribe.topic)) continue;
            logger.warn("topic[{}] has been subscribed", (Object)subscribe.topic);
            return;
        }
        this.subscribes.add(subscribe);
    }

    @Override
    public boolean check() {
        if (!super.check()) {
            return false;
        }
        if (StringUtils.isEmpty((CharSequence)this.serverURL)) {
            logger.error("server url is empty");
            return false;
        }
        if (StringUtils.isEmpty((CharSequence)this.consumeId)) {
            logger.error("consume id is empty");
            return false;
        }
        if (this.subscribes == null || this.subscribes.isEmpty()) {
            logger.error("missing subscribe list");
            return false;
        }
        for (Subscribe subscribe : this.subscribes) {
            if (subscribe.check()) continue;
            return false;
        }
        if (this.consumeThreadNum <= 0) {
            this.consumeThreadNum = 1;
        }
        if (this.maxCachedMessageNum <= 0) {
            this.maxCachedMessageNum = 1000;
        }
        return true;
    }

    public int getConsumeThreadNum() {
        return this.consumeThreadNum;
    }

    public int getMaxCachedMessageNum() {
        return this.maxCachedMessageNum;
    }

    public String getConsumeId() {
        return this.consumeId;
    }

    public String getServerURL() {
        return this.serverURL;
    }

    public List<Subscribe> getSubscribes() {
        return this.subscribes;
    }

    public void setConsumeThreadNum(int consumeThreadNum) {
        this.consumeThreadNum = consumeThreadNum;
    }

    public void setMaxCachedMessageNum(int maxCachedMessageNum) {
        this.maxCachedMessageNum = maxCachedMessageNum;
    }

    public void setConsumeId(String consumeId) {
        this.consumeId = consumeId;
    }

    public void setServerURL(String serverURL) {
        this.serverURL = serverURL;
    }

    public void setSubscribes(List<Subscribe> subscribes) {
        this.subscribes = subscribes;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ONSConsumerConfig)) {
            return false;
        }
        ONSConsumerConfig other = (ONSConsumerConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getConsumeThreadNum() != other.getConsumeThreadNum()) {
            return false;
        }
        if (this.getMaxCachedMessageNum() != other.getMaxCachedMessageNum()) {
            return false;
        }
        String this$consumeId = this.getConsumeId();
        String other$consumeId = other.getConsumeId();
        if (this$consumeId == null ? other$consumeId != null : !this$consumeId.equals(other$consumeId)) {
            return false;
        }
        String this$serverURL = this.getServerURL();
        String other$serverURL = other.getServerURL();
        if (this$serverURL == null ? other$serverURL != null : !this$serverURL.equals(other$serverURL)) {
            return false;
        }
        List<Subscribe> this$subscribes = this.getSubscribes();
        List<Subscribe> other$subscribes = other.getSubscribes();
        return !(this$subscribes == null ? other$subscribes != null : !((Object)this$subscribes).equals(other$subscribes));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ONSConsumerConfig;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getConsumeThreadNum();
        result = result * 59 + this.getMaxCachedMessageNum();
        String $consumeId = this.getConsumeId();
        result = result * 59 + ($consumeId == null ? 43 : $consumeId.hashCode());
        String $serverURL = this.getServerURL();
        result = result * 59 + ($serverURL == null ? 43 : $serverURL.hashCode());
        List<Subscribe> $subscribes = this.getSubscribes();
        result = result * 59 + ($subscribes == null ? 43 : ((Object)$subscribes).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "ONSConsumerConfig(consumeThreadNum=" + this.getConsumeThreadNum() + ", maxCachedMessageNum=" + this.getMaxCachedMessageNum() + ", consumeId=" + this.getConsumeId() + ", serverURL=" + this.getServerURL() + ", subscribes=" + this.getSubscribes() + ")";
    }
}

