/*
 * Decompiled with CFR 0.152.
 */
package xin.manong.weapon.aliyun.oss;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xin.manong.weapon.aliyun.secret.DynamicSecretConfig;

public class OSSClientConfig
extends DynamicSecretConfig {
    private static final Logger logger = LoggerFactory.getLogger(OSSClientConfig.class);
    private static final int DEFAULT_RETRY_CNT = 3;
    private static final int DEFAULT_CONNECTION_TIMEOUT_MS = 3000;
    private static final int DEFAULT_SOCKET_TIMEOUT_MS = 10000;
    public int retryCnt = 3;
    public int connectionTimeoutMs = 3000;
    public int socketTimeoutMs = 10000;
    public String endpoint;

    @Override
    public boolean check() {
        if (!super.check()) {
            return false;
        }
        if (StringUtils.isEmpty((CharSequence)this.endpoint)) {
            logger.error("endpoint is empty");
            return false;
        }
        return true;
    }

    public int getRetryCnt() {
        return this.retryCnt;
    }

    public int getConnectionTimeoutMs() {
        return this.connectionTimeoutMs;
    }

    public int getSocketTimeoutMs() {
        return this.socketTimeoutMs;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setRetryCnt(int retryCnt) {
        this.retryCnt = retryCnt;
    }

    public void setConnectionTimeoutMs(int connectionTimeoutMs) {
        this.connectionTimeoutMs = connectionTimeoutMs;
    }

    public void setSocketTimeoutMs(int socketTimeoutMs) {
        this.socketTimeoutMs = socketTimeoutMs;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OSSClientConfig)) {
            return false;
        }
        OSSClientConfig other = (OSSClientConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getRetryCnt() != other.getRetryCnt()) {
            return false;
        }
        if (this.getConnectionTimeoutMs() != other.getConnectionTimeoutMs()) {
            return false;
        }
        if (this.getSocketTimeoutMs() != other.getSocketTimeoutMs()) {
            return false;
        }
        String this$endpoint = this.getEndpoint();
        String other$endpoint = other.getEndpoint();
        return !(this$endpoint == null ? other$endpoint != null : !this$endpoint.equals(other$endpoint));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof OSSClientConfig;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getRetryCnt();
        result = result * 59 + this.getConnectionTimeoutMs();
        result = result * 59 + this.getSocketTimeoutMs();
        String $endpoint = this.getEndpoint();
        result = result * 59 + ($endpoint == null ? 43 : $endpoint.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "OSSClientConfig(retryCnt=" + this.getRetryCnt() + ", connectionTimeoutMs=" + this.getConnectionTimeoutMs() + ", socketTimeoutMs=" + this.getSocketTimeoutMs() + ", endpoint=" + this.getEndpoint() + ")";
    }
}

