/*
 * Decompiled with CFR 0.152.
 */
package xin.manong.weapon.aliyun.ots;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xin.manong.weapon.aliyun.secret.DynamicSecretConfig;

public class OTSClientConfig
extends DynamicSecretConfig {
    private static final Logger logger = LoggerFactory.getLogger(OTSClientConfig.class);
    private static final int DEFAULT_RETRY_CNT = 3;
    private static final int DEFAULT_CONNECTION_TIMEOUT_MS = 5000;
    private static final int DEFAULT_CONNECTION_REQUEST_TIMEOUT_MS = 5000;
    private static final int DEFAULT_SOCKET_TIMEOUT_MS = 5000;
    public int retryCnt = 3;
    public int connectionTimeoutMs = 5000;
    public int connectionRequestTimeoutMs = 5000;
    public int socketTimeoutMs = 5000;
    public String endpoint;
    public String instance;

    @Override
    public boolean check() {
        if (!super.check()) {
            return false;
        }
        if (StringUtils.isEmpty((CharSequence)this.endpoint)) {
            logger.error("endpoint is empty");
            return false;
        }
        if (StringUtils.isEmpty((CharSequence)this.instance)) {
            logger.error("instance is empty");
            return false;
        }
        if (this.retryCnt <= 0) {
            this.retryCnt = 3;
        }
        if (this.socketTimeoutMs <= 0) {
            this.socketTimeoutMs = 5000;
        }
        if (this.connectionTimeoutMs <= 0) {
            this.connectionTimeoutMs = 5000;
        }
        if (this.connectionRequestTimeoutMs <= 0) {
            this.connectionRequestTimeoutMs = 5000;
        }
        return true;
    }

    public int getRetryCnt() {
        return this.retryCnt;
    }

    public int getConnectionTimeoutMs() {
        return this.connectionTimeoutMs;
    }

    public int getConnectionRequestTimeoutMs() {
        return this.connectionRequestTimeoutMs;
    }

    public int getSocketTimeoutMs() {
        return this.socketTimeoutMs;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public String getInstance() {
        return this.instance;
    }

    public void setRetryCnt(int retryCnt) {
        this.retryCnt = retryCnt;
    }

    public void setConnectionTimeoutMs(int connectionTimeoutMs) {
        this.connectionTimeoutMs = connectionTimeoutMs;
    }

    public void setConnectionRequestTimeoutMs(int connectionRequestTimeoutMs) {
        this.connectionRequestTimeoutMs = connectionRequestTimeoutMs;
    }

    public void setSocketTimeoutMs(int socketTimeoutMs) {
        this.socketTimeoutMs = socketTimeoutMs;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public void setInstance(String instance) {
        this.instance = instance;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OTSClientConfig)) {
            return false;
        }
        OTSClientConfig other = (OTSClientConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getRetryCnt() != other.getRetryCnt()) {
            return false;
        }
        if (this.getConnectionTimeoutMs() != other.getConnectionTimeoutMs()) {
            return false;
        }
        if (this.getConnectionRequestTimeoutMs() != other.getConnectionRequestTimeoutMs()) {
            return false;
        }
        if (this.getSocketTimeoutMs() != other.getSocketTimeoutMs()) {
            return false;
        }
        String this$endpoint = this.getEndpoint();
        String other$endpoint = other.getEndpoint();
        if (this$endpoint == null ? other$endpoint != null : !this$endpoint.equals(other$endpoint)) {
            return false;
        }
        String this$instance = this.getInstance();
        String other$instance = other.getInstance();
        return !(this$instance == null ? other$instance != null : !this$instance.equals(other$instance));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof OTSClientConfig;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getRetryCnt();
        result = result * 59 + this.getConnectionTimeoutMs();
        result = result * 59 + this.getConnectionRequestTimeoutMs();
        result = result * 59 + this.getSocketTimeoutMs();
        String $endpoint = this.getEndpoint();
        result = result * 59 + ($endpoint == null ? 43 : $endpoint.hashCode());
        String $instance = this.getInstance();
        result = result * 59 + ($instance == null ? 43 : $instance.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "OTSClientConfig(retryCnt=" + this.getRetryCnt() + ", connectionTimeoutMs=" + this.getConnectionTimeoutMs() + ", connectionRequestTimeoutMs=" + this.getConnectionRequestTimeoutMs() + ", socketTimeoutMs=" + this.getSocketTimeoutMs() + ", endpoint=" + this.getEndpoint() + ", instance=" + this.getInstance() + ")";
    }
}

