/*
 * Decompiled with CFR 0.152.
 */
package xin.manong.weapon.aliyun.ots;

import com.alicloud.openservices.tablestore.model.search.query.Query;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OTSSearchRequest {
    private static final Logger logger = LoggerFactory.getLogger(OTSSearchRequest.class);
    private static final int DEFAULT_OFFSET = 0;
    private static final int DEFAULT_LIMIT = 20;
    private static final int DEFAULT_SEARCH_TIMEOUT_MS = 10000;
    public Integer offset = 0;
    public Integer limit = 20;
    public Integer searchTimeoutMs = 10000;
    public String tableName;
    public String indexName;
    public List<String> returnColumns;
    public Query query;

    public boolean check() {
        if (this.offset == null || this.offset < 0) {
            this.offset = 0;
        }
        if (this.limit == null || this.limit <= 0) {
            this.limit = 20;
        }
        if (this.searchTimeoutMs == null || this.searchTimeoutMs <= 0) {
            this.limit = 10000;
        }
        if (StringUtils.isEmpty((CharSequence)this.tableName)) {
            logger.error("table name is empty");
            return false;
        }
        if (StringUtils.isEmpty((CharSequence)this.indexName)) {
            logger.error("index name is empty");
            return false;
        }
        if (this.query == null) {
            logger.error("search query is null");
            return false;
        }
        return true;
    }

    public static class Builder {
        private OTSSearchRequest request = new OTSSearchRequest();

        public Builder tableName(String tableName) {
            this.request.tableName = tableName;
            return this;
        }

        public Builder indexName(String indexName) {
            this.request.indexName = indexName;
            return this;
        }

        public Builder returnColumns(List<String> returnColumns) {
            this.request.returnColumns = returnColumns;
            return this;
        }

        public Builder query(Query query) {
            this.request.query = query;
            return this;
        }

        public Builder offset(Integer offset) {
            this.request.offset = offset;
            return this;
        }

        public Builder limit(Integer limit) {
            this.request.limit = limit;
            return this;
        }

        public Builder searchTimeoutMs(Integer searchTimeoutMs) {
            this.request.searchTimeoutMs = searchTimeoutMs;
            return this;
        }

        public OTSSearchRequest build() {
            OTSSearchRequest replica = new OTSSearchRequest();
            replica.tableName = this.request.tableName;
            replica.indexName = this.request.indexName;
            replica.searchTimeoutMs = this.request.searchTimeoutMs;
            replica.returnColumns = this.request.returnColumns;
            replica.query = this.request.query;
            replica.offset = this.request.offset;
            replica.limit = this.request.limit;
            return replica;
        }
    }
}

