/*
 * Decompiled with CFR 0.152.
 */
package xin.manong.weapon.aliyun.ots;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xin.manong.weapon.aliyun.ots.OTSTunnelWorkerConfig;
import xin.manong.weapon.aliyun.secret.DynamicSecretConfig;

public class OTSTunnelConfig
extends DynamicSecretConfig {
    private static final Logger logger = LoggerFactory.getLogger(OTSTunnelConfig.class);
    public String endpoint;
    public String instance;
    public List<OTSTunnelWorkerConfig> workerConfigs = new ArrayList<OTSTunnelWorkerConfig>();

    public boolean addTunnelWorkerConfig(OTSTunnelWorkerConfig workerConfig) {
        if (workerConfig == null || !workerConfig.check()) {
            return false;
        }
        if (this.workerConfigs == null) {
            this.workerConfigs = new ArrayList<OTSTunnelWorkerConfig>();
        }
        for (OTSTunnelWorkerConfig config : this.workerConfigs) {
            if (!config.equals(workerConfig)) continue;
            logger.warn("worker config[{}/{}] has existed", (Object)workerConfig.table, (Object)workerConfig.tunnel);
            return false;
        }
        this.workerConfigs.add(workerConfig);
        return true;
    }

    public void removeTunnelWorkerConfig(OTSTunnelWorkerConfig workerConfig) {
        if (workerConfig == null) {
            return;
        }
        if (StringUtils.isEmpty((CharSequence)workerConfig.table)) {
            logger.warn("table is null, ignore remove request");
            return;
        }
        if (StringUtils.isEmpty((CharSequence)workerConfig.tunnel)) {
            logger.warn("tunnel is null, ignore remove request");
            return;
        }
        if (!this.workerConfigs.remove(workerConfig)) {
            logger.warn("tunnel worker[{}/{}] is not found", (Object)workerConfig.table, (Object)workerConfig.tunnel);
        }
    }

    @Override
    public boolean check() {
        if (!super.check()) {
            return false;
        }
        if (StringUtils.isEmpty((CharSequence)this.instance)) {
            logger.error("oss instance is empty");
            return false;
        }
        if (StringUtils.isEmpty((CharSequence)this.endpoint)) {
            logger.error("oss endpoint is empty");
            return false;
        }
        for (OTSTunnelWorkerConfig workerConfig : this.workerConfigs) {
            if (workerConfig.check()) continue;
            return false;
        }
        return true;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public String getInstance() {
        return this.instance;
    }

    public List<OTSTunnelWorkerConfig> getWorkerConfigs() {
        return this.workerConfigs;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public void setInstance(String instance) {
        this.instance = instance;
    }

    public void setWorkerConfigs(List<OTSTunnelWorkerConfig> workerConfigs) {
        this.workerConfigs = workerConfigs;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OTSTunnelConfig)) {
            return false;
        }
        OTSTunnelConfig other = (OTSTunnelConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$endpoint = this.getEndpoint();
        String other$endpoint = other.getEndpoint();
        if (this$endpoint == null ? other$endpoint != null : !this$endpoint.equals(other$endpoint)) {
            return false;
        }
        String this$instance = this.getInstance();
        String other$instance = other.getInstance();
        if (this$instance == null ? other$instance != null : !this$instance.equals(other$instance)) {
            return false;
        }
        List<OTSTunnelWorkerConfig> this$workerConfigs = this.getWorkerConfigs();
        List<OTSTunnelWorkerConfig> other$workerConfigs = other.getWorkerConfigs();
        return !(this$workerConfigs == null ? other$workerConfigs != null : !((Object)this$workerConfigs).equals(other$workerConfigs));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof OTSTunnelConfig;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $endpoint = this.getEndpoint();
        result = result * 59 + ($endpoint == null ? 43 : $endpoint.hashCode());
        String $instance = this.getInstance();
        result = result * 59 + ($instance == null ? 43 : $instance.hashCode());
        List<OTSTunnelWorkerConfig> $workerConfigs = this.getWorkerConfigs();
        result = result * 59 + ($workerConfigs == null ? 43 : ((Object)$workerConfigs).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "OTSTunnelConfig(endpoint=" + this.getEndpoint() + ", instance=" + this.getInstance() + ", workerConfigs=" + this.getWorkerConfigs() + ")";
    }
}

