/*
 * Decompiled with CFR 0.152.
 */
package xin.manong.weapon.aliyun.datahub;

import com.aliyun.datahub.DatahubClient;
import com.aliyun.datahub.DatahubConfiguration;
import com.aliyun.datahub.auth.Account;
import com.aliyun.datahub.auth.AliyunAccount;
import com.aliyun.datahub.exception.DatahubClientException;
import com.aliyun.datahub.model.GetTopicResult;
import com.aliyun.datahub.model.PutRecordsResult;
import com.aliyun.datahub.model.RecordEntry;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xin.manong.weapon.aliyun.datahub.DataHubClientConfig;
import xin.manong.weapon.base.rebuild.RebuildManager;
import xin.manong.weapon.base.rebuild.Rebuildable;
import xin.manong.weapon.base.secret.DynamicSecret;

public class DataHubClient
implements Rebuildable {
    private static final Logger logger = LoggerFactory.getLogger(DataHubClient.class);
    private DataHubClientConfig config;
    private DatahubClient client;

    public DataHubClient(DataHubClientConfig config) {
        this.config = config;
        if (this.config == null || !this.config.check()) {
            throw new RuntimeException("data hub client config is invalid");
        }
        this.build();
        if (this.config.dynamic) {
            RebuildManager.register((Rebuildable)this);
        }
    }

    public void close() {
        logger.info("data hub client is closing ...");
        if (this.config.dynamic) {
            RebuildManager.unregister((Rebuildable)this);
        }
        logger.info("data hub client has been closed");
    }

    public void rebuild() {
        logger.info("data hub client is rebuilding ...");
        if (DynamicSecret.accessKey.equals(this.config.aliyunSecret.accessKey) && DynamicSecret.secretKey.equals(this.config.aliyunSecret.secretKey)) {
            logger.warn("secret is not changed, ignore data hub client rebuilding");
            return;
        }
        this.config.aliyunSecret.accessKey = DynamicSecret.accessKey;
        this.config.aliyunSecret.secretKey = DynamicSecret.secretKey;
        this.build();
        logger.info("data hub client rebuild success");
    }

    private void build() {
        AliyunAccount account = new AliyunAccount(this.config.aliyunSecret.accessKey, this.config.aliyunSecret.secretKey);
        DatahubConfiguration conf = new DatahubConfiguration((Account)account, this.config.endpoint);
        this.client = new DatahubClient(conf);
    }

    public boolean putRecords(String project, String topic, List<RecordEntry> recordEntries) {
        if (StringUtils.isEmpty((CharSequence)project)) {
            logger.error("project is empty");
            return false;
        }
        if (StringUtils.isEmpty((CharSequence)topic)) {
            logger.error("topic is empty");
            return false;
        }
        if (recordEntries == null || recordEntries.isEmpty()) {
            logger.warn("record entries are empty");
            return false;
        }
        PutRecordsResult result = this.client.putRecords(project, topic, recordEntries, this.config.retryCnt);
        return result.getFailedRecordCount() == 0;
    }

    public GetTopicResult getTopicInfo(String project, String topic) throws DatahubClientException {
        if (StringUtils.isEmpty((CharSequence)project)) {
            logger.error("project is empty");
            throw new DatahubClientException("project is empty");
        }
        if (StringUtils.isEmpty((CharSequence)topic)) {
            logger.error("topic is empty");
            throw new DatahubClientException("topic is empty");
        }
        return this.client.getTopic(project, topic);
    }
}

