/*
 * Decompiled with CFR 0.152.
 */
package xin.manong.weapon.aliyun.log;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.aliyun.openservices.aliyun.log.producer.Callback;
import com.aliyun.openservices.aliyun.log.producer.LogProducer;
import com.aliyun.openservices.aliyun.log.producer.Producer;
import com.aliyun.openservices.aliyun.log.producer.ProducerConfig;
import com.aliyun.openservices.aliyun.log.producer.ProjectConfig;
import com.aliyun.openservices.log.Client;
import com.aliyun.openservices.log.common.LogContent;
import com.aliyun.openservices.log.common.LogItem;
import com.aliyun.openservices.log.common.QueriedLog;
import com.aliyun.openservices.log.request.GetLogsRequest;
import com.aliyun.openservices.log.response.GetLogsResponse;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xin.manong.weapon.aliyun.log.LogClientConfig;
import xin.manong.weapon.aliyun.log.LogPushCallback;
import xin.manong.weapon.aliyun.log.LogSearchRequest;
import xin.manong.weapon.aliyun.log.LogSearchResponse;
import xin.manong.weapon.base.rebuild.RebuildManager;
import xin.manong.weapon.base.rebuild.Rebuildable;
import xin.manong.weapon.base.record.KVRecord;
import xin.manong.weapon.base.record.KVRecords;
import xin.manong.weapon.base.secret.DynamicSecret;

public class LogClient
implements Rebuildable {
    private static final Logger logger = LoggerFactory.getLogger(LogClient.class);
    private LogClientConfig config;
    private Client client;
    private Producer producer;
    private Set<String> projects;

    public LogClient(LogClientConfig config) {
        this.config = config;
    }

    public boolean init() {
        logger.info("log client is init ...");
        if (!this.config.check()) {
            return false;
        }
        if (!this.build()) {
            return false;
        }
        if (this.config.dynamic) {
            RebuildManager.register((Rebuildable)this);
        }
        logger.info("log client has finished init");
        return true;
    }

    public void destroy() {
        logger.info("log client is destroying ...");
        if (this.config.dynamic) {
            RebuildManager.unregister((Rebuildable)this);
        }
        try {
            if (this.producer != null) {
                this.producer.close();
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        if (this.client != null) {
            this.client.shutdown();
        }
        logger.info("log client has been destroyed");
    }

    public void rebuild() {
        logger.info("log client is rebuilding ...");
        if (DynamicSecret.accessKey.equals(this.config.aliyunSecret.accessKey) && DynamicSecret.secretKey.equals(this.config.aliyunSecret.secretKey)) {
            logger.warn("secret is not changed, ignore log client rebuilding");
            return;
        }
        this.config.aliyunSecret.accessKey = DynamicSecret.accessKey;
        this.config.aliyunSecret.secretKey = DynamicSecret.secretKey;
        Client prevClient = this.client;
        Producer prevProducer = this.producer;
        if (!this.build()) {
            throw new RuntimeException("rebuild log client failed");
        }
        try {
            if (prevProducer != null) {
                prevProducer.close();
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        if (prevClient != null) {
            prevClient.shutdown();
        }
        logger.info("log client rebuild success");
    }

    private boolean build() {
        this.client = new Client(this.config.endpoint, this.config.aliyunSecret.accessKey, this.config.aliyunSecret.secretKey);
        this.producer = new LogProducer(new ProducerConfig());
        this.projects = new HashSet<String>();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildProjectClient(String project) {
        if (this.projects.contains(project)) {
            return;
        }
        LogClient logClient = this;
        synchronized (logClient) {
            if (this.projects.contains(project)) {
                return;
            }
            this.producer.putProjectConfig(new ProjectConfig(project, this.config.endpoint, this.config.aliyunSecret.accessKey, this.config.aliyunSecret.secretKey));
            this.projects.add(project);
        }
    }

    private LogItem convert(KVRecord kvRecord) {
        LogItem logItem = new LogItem();
        for (Map.Entry entry : kvRecord.getFieldMap().entrySet()) {
            Object value = entry.getValue();
            logItem.PushBack((String)entry.getKey(), value instanceof JSON ? JSON.toJSONString(value, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect}) : value.toString());
        }
        return logItem;
    }

    public void push(String project, String logStore, KVRecords kvRecords) {
        if (StringUtils.isEmpty((CharSequence)project)) {
            logger.error("project is empty");
            return;
        }
        if (StringUtils.isEmpty((CharSequence)logStore)) {
            logger.error("log store is empty");
            return;
        }
        if (kvRecords == null || kvRecords.isEmpty()) {
            logger.error("push records are empty");
            return;
        }
        this.buildProjectClient(project);
        for (int i = 0; i < kvRecords.getRecordCount(); ++i) {
            KVRecord kvRecord = kvRecords.getRecord(i);
            LogItem logItem = this.convert(kvRecord);
            LogPushCallback callback = new LogPushCallback(project, logStore, logItem);
            try {
                this.producer.send(project, logStore, logItem, (Callback)callback);
                continue;
            }
            catch (Exception e) {
                logger.warn(e.getMessage(), (Throwable)e);
            }
        }
    }

    public LogSearchResponse search(LogSearchRequest request) {
        if (request == null || !request.check()) {
            logger.error("search request is not valid");
            return LogSearchResponse.buildError("search request is not valid");
        }
        GetLogsRequest getLogsRequest = new GetLogsRequest(request.project, request.logStore, (int)(request.startTime / 1000L), (int)(request.stopTime / 1000L), request.topic, request.query, request.offset.longValue(), request.lines.longValue(), request.reverse.booleanValue());
        try {
            GetLogsResponse getLogsResponse = this.client.GetLogs(getLogsRequest);
            if (getLogsResponse == null) {
                logger.error("search response is null");
                return LogSearchResponse.buildError("search response is null");
            }
            KVRecords kvRecords = new KVRecords();
            List queriedLogs = getLogsResponse.getLogs();
            for (QueriedLog queriedLog : queriedLogs) {
                KVRecord kvRecord = new KVRecord();
                for (LogContent logContent : queriedLog.mLogItem.mContents) {
                    kvRecord.put(logContent.mKey, (Object)logContent.mValue);
                }
                kvRecords.addRecord(kvRecord);
            }
            return LogSearchResponse.buildOK(kvRecords, getLogsResponse.getProcessedRow());
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return LogSearchResponse.buildError(e.getMessage());
        }
    }
}

