/*
 * Decompiled with CFR 0.152.
 */
package xin.manong.weapon.aliyun.log;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogSearchRequest {
    private static final Logger logger = LoggerFactory.getLogger(LogSearchRequest.class);
    public static final Long DEFAULT_OFFSET = 0L;
    public static final Long DEFAULT_LINES = 20L;
    public String project;
    public String logStore;
    public String topic;
    public String query;
    public Long offset = DEFAULT_OFFSET;
    public Long lines = DEFAULT_LINES;
    public Long startTime;
    public Long stopTime;
    public Boolean reverse = false;

    public boolean check() {
        if (StringUtils.isEmpty((CharSequence)this.project)) {
            logger.error("project is empty");
            return false;
        }
        if (StringUtils.isEmpty((CharSequence)this.logStore)) {
            logger.error("log store is empty");
            return false;
        }
        if (StringUtils.isEmpty((CharSequence)this.query)) {
            logger.error("search query is empty");
            return false;
        }
        if (this.stopTime == null || this.stopTime <= 0L) {
            this.stopTime = System.currentTimeMillis();
        }
        if (this.startTime == null || this.startTime <= 0L) {
            this.startTime = this.stopTime - 86400000L;
        }
        if (this.offset == null || this.offset < 0L) {
            this.offset = DEFAULT_OFFSET;
        }
        if (this.lines == null || this.lines <= 0L) {
            this.lines = DEFAULT_LINES;
        }
        if (this.reverse == null) {
            this.reverse = false;
        }
        return true;
    }
}

