/*
 * Decompiled with CFR 0.152.
 */
package xin.manong.weapon.aliyun.ons;

import com.aliyun.openservices.ons.api.Consumer;
import com.aliyun.openservices.ons.api.ONSFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xin.manong.weapon.aliyun.ons.ONSConsumerConfig;
import xin.manong.weapon.aliyun.ons.Subscribe;
import xin.manong.weapon.base.rebuild.RebuildListener;
import xin.manong.weapon.base.rebuild.RebuildManager;
import xin.manong.weapon.base.rebuild.Rebuildable;
import xin.manong.weapon.base.secret.DynamicSecret;

public class ONSConsumer
implements Rebuildable {
    private static final Logger logger = LoggerFactory.getLogger(ONSConsumer.class);
    protected ONSConsumerConfig config;
    protected List<RebuildListener> rebuildListeners;
    protected Consumer consumer;

    public ONSConsumer(ONSConsumerConfig config) {
        this.config = config;
        this.rebuildListeners = new ArrayList<RebuildListener>();
    }

    private boolean build() {
        Properties properties = new Properties();
        properties.put("NAMESRV_ADDR", this.config.serverURL);
        properties.put("GROUP_ID", this.config.consumeId);
        properties.put("AccessKey", this.config.aliyunSecret.accessKey);
        properties.put("SecretKey", this.config.aliyunSecret.secretKey);
        properties.put("ConsumeThreadNums", (Object)this.config.consumeThreadNum);
        properties.put("maxCachedMessageAmount", (Object)this.config.maxCachedMessageNum);
        properties.put("MessageModel", "CLUSTERING");
        try {
            this.consumer = ONSFactory.createConsumer((Properties)properties);
            for (Subscribe subscribe : this.config.subscribes) {
                this.consumer.subscribe(subscribe.topic, subscribe.tags, subscribe.listener);
            }
            this.consumer.start();
            logger.info("build ONS consumer success");
            return true;
        }
        catch (Exception e) {
            logger.error("build ONS consumer failed");
            logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public void rebuild() {
        logger.info("ONS consumer is rebuilding ...");
        if (DynamicSecret.accessKey.equals(this.config.aliyunSecret.accessKey) && DynamicSecret.secretKey.equals(this.config.aliyunSecret.secretKey)) {
            logger.warn("secret is not changed, ignore ONS consumer rebuilding");
            return;
        }
        this.config.aliyunSecret.accessKey = DynamicSecret.accessKey;
        this.config.aliyunSecret.secretKey = DynamicSecret.secretKey;
        Consumer prevConsumer = this.consumer;
        if (prevConsumer != null) {
            prevConsumer.shutdown();
        }
        for (RebuildListener rebuildListener : this.rebuildListeners) {
            rebuildListener.notifyRebuildEvent((Rebuildable)this);
        }
        if (!this.build()) {
            throw new RuntimeException("rebuild ONS consumer failed");
        }
        logger.info("ONS consumer rebuild success");
    }

    public boolean start() {
        logger.info("ONS consumer is starting ...");
        if (this.config == null) {
            logger.error("ONS consumer config is null");
            return false;
        }
        if (!this.config.check()) {
            return false;
        }
        if (!this.build()) {
            return false;
        }
        if (this.config.dynamic) {
            RebuildManager.register((Rebuildable)this);
        }
        logger.info("ONS consumer has been started");
        return true;
    }

    public void stop() {
        logger.info("ONS consumer is stopping ...");
        if (this.config.dynamic) {
            RebuildManager.unregister((Rebuildable)this);
        }
        if (this.consumer != null) {
            try {
                this.consumer.shutdown();
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        logger.info("ONS consumer has been stopped");
    }

    public void addRebuildListener(RebuildListener listener) {
        if (listener == null) {
            return;
        }
        this.rebuildListeners.add(listener);
    }
}

