/*
 * Decompiled with CFR 0.152.
 */
package xin.manong.weapon.aliyun.ons;

import com.aliyun.openservices.ons.api.Message;
import com.aliyun.openservices.ons.api.ONSFactory;
import com.aliyun.openservices.ons.api.Producer;
import com.aliyun.openservices.ons.api.SendResult;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xin.manong.weapon.aliyun.ons.ONSProducerConfig;
import xin.manong.weapon.base.rebuild.RebuildManager;
import xin.manong.weapon.base.rebuild.Rebuildable;
import xin.manong.weapon.base.secret.DynamicSecret;

public class ONSProducer
implements Rebuildable {
    private static final Logger logger = LoggerFactory.getLogger(ONSProducer.class);
    private ONSProducerConfig config;
    private Producer producer;

    public ONSProducer(ONSProducerConfig config) {
        this.config = config;
    }

    public void rebuild() {
        logger.info("ONS producer is rebuilding ...");
        if (DynamicSecret.accessKey.equals(this.config.aliyunSecret.accessKey) && DynamicSecret.secretKey.equals(this.config.aliyunSecret.secretKey)) {
            logger.warn("secret is not changed, ignore ONS producer rebuilding");
            return;
        }
        this.config.aliyunSecret.accessKey = DynamicSecret.accessKey;
        this.config.aliyunSecret.secretKey = DynamicSecret.secretKey;
        Producer prevProducer = this.producer;
        if (!this.build()) {
            throw new RuntimeException("rebuild ONS producer failed");
        }
        if (prevProducer != null) {
            prevProducer.shutdown();
        }
        logger.info("ONS producer rebuild success");
    }

    private boolean build() {
        Properties properties = new Properties();
        properties.put("AccessKey", this.config.aliyunSecret.accessKey);
        properties.put("SecretKey", this.config.aliyunSecret.secretKey);
        properties.put("SendMsgTimeoutMillis", (Object)this.config.requestTimeoutMs);
        properties.put("NAMESRV_ADDR", this.config.serverURL);
        try {
            this.producer = ONSFactory.createProducer((Properties)properties);
            this.producer.start();
        }
        catch (Exception e) {
            logger.error("build ONS producer failed");
            return false;
        }
        return true;
    }

    public boolean init() {
        logger.info("ONS producer is init ...");
        if (!this.config.check()) {
            return false;
        }
        if (!this.build()) {
            return false;
        }
        if (this.config.dynamic) {
            RebuildManager.register((Rebuildable)this);
        }
        logger.info("ONS producer has finished init");
        return true;
    }

    public void destroy() {
        logger.info("ONS producer is destroying ...");
        if (this.config.dynamic) {
            RebuildManager.unregister((Rebuildable)this);
        }
        if (this.producer != null) {
            try {
                this.producer.shutdown();
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        logger.info("ONS producer has been destroyed");
    }

    public SendResult send(Message message) {
        if (message == null) {
            logger.error("send message is null");
            return null;
        }
        for (int i = 0; i < this.config.retryCnt; ++i) {
            try {
                return this.producer.send(message);
            }
            catch (Exception e) {
                logger.error("send message failed for topic[{}], retry {} times", (Object)message.getTopic(), (Object)(i + 1));
                logger.error(e.getMessage(), (Throwable)e);
                continue;
            }
        }
        return null;
    }
}

