/*
 * Decompiled with CFR 0.152.
 */
package xin.manong.weapon.aliyun.ons;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xin.manong.weapon.aliyun.secret.DynamicSecretConfig;

public class ONSProducerConfig
extends DynamicSecretConfig {
    private static final Logger logger = LoggerFactory.getLogger(ONSProducerConfig.class);
    private static final int DEFAULT_RETRY_CNT = 3;
    private static final int DEFAULT_REQUEST_TIMEOUT_MS = 3000;
    public int retryCnt = 3;
    public int requestTimeoutMs = 3000;
    public String serverURL;

    @Override
    public boolean check() {
        if (!super.check()) {
            return false;
        }
        if (StringUtils.isEmpty((CharSequence)this.serverURL)) {
            logger.error("server url is empty");
            return false;
        }
        return true;
    }

    public int getRetryCnt() {
        return this.retryCnt;
    }

    public int getRequestTimeoutMs() {
        return this.requestTimeoutMs;
    }

    public String getServerURL() {
        return this.serverURL;
    }

    public void setRetryCnt(int retryCnt) {
        this.retryCnt = retryCnt;
    }

    public void setRequestTimeoutMs(int requestTimeoutMs) {
        this.requestTimeoutMs = requestTimeoutMs;
    }

    public void setServerURL(String serverURL) {
        this.serverURL = serverURL;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ONSProducerConfig)) {
            return false;
        }
        ONSProducerConfig other = (ONSProducerConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getRetryCnt() != other.getRetryCnt()) {
            return false;
        }
        if (this.getRequestTimeoutMs() != other.getRequestTimeoutMs()) {
            return false;
        }
        String this$serverURL = this.getServerURL();
        String other$serverURL = other.getServerURL();
        return !(this$serverURL == null ? other$serverURL != null : !this$serverURL.equals(other$serverURL));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ONSProducerConfig;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getRetryCnt();
        result = result * 59 + this.getRequestTimeoutMs();
        String $serverURL = this.getServerURL();
        result = result * 59 + ($serverURL == null ? 43 : $serverURL.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "ONSProducerConfig(retryCnt=" + this.getRetryCnt() + ", requestTimeoutMs=" + this.getRequestTimeoutMs() + ", serverURL=" + this.getServerURL() + ")";
    }
}

