/*
 * Decompiled with CFR 0.152.
 */
package xin.manong.weapon.aliyun.oss;

import com.aliyun.oss.ClientBuilderConfiguration;
import com.aliyun.oss.OSS;
import com.aliyun.oss.OSSClientBuilder;
import com.aliyun.oss.model.GetObjectRequest;
import com.aliyun.oss.model.ListObjectsRequest;
import com.aliyun.oss.model.OSSObject;
import com.aliyun.oss.model.OSSObjectSummary;
import com.aliyun.oss.model.ObjectListing;
import com.aliyun.oss.model.ObjectMetadata;
import com.aliyun.oss.model.PutObjectResult;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xin.manong.weapon.aliyun.oss.OSSClientConfig;
import xin.manong.weapon.aliyun.oss.OSSMeta;
import xin.manong.weapon.base.rebuild.RebuildManager;
import xin.manong.weapon.base.rebuild.Rebuildable;
import xin.manong.weapon.base.secret.DynamicSecret;
import xin.manong.weapon.base.util.CommonUtil;

public class OSSClient
implements Rebuildable {
    private static final Logger logger = LoggerFactory.getLogger(OSSClient.class);
    private static final String PREFIX_HTTP = "http://";
    private static final String PREFIX_HTTPS = "https://";
    private static final String ALIYUN_OSS_DOMAIN = "aliyuncs.com";
    private static final int BUFFER_SIZE = 4096;
    private static final long EXPIRED_TIME_1H = 3600000L;
    private OSSClientConfig config;
    private OSS instance;

    public OSSClient(OSSClientConfig config) {
        this.config = config;
        if (!this.config.check()) {
            throw new RuntimeException("oss client config is invalid");
        }
        this.build();
        if (this.config.dynamic) {
            RebuildManager.register((Rebuildable)this);
        }
    }

    public void close() {
        logger.info("OSS client is closing ...");
        if (this.config.dynamic) {
            RebuildManager.unregister((Rebuildable)this);
        }
        if (this.instance != null) {
            this.instance.shutdown();
        }
        logger.info("OSS client has been closed");
    }

    public void rebuild() {
        logger.info("OSS client is rebuilding ...");
        if (DynamicSecret.accessKey.equals(this.config.aliyunSecret.accessKey) && DynamicSecret.secretKey.equals(this.config.aliyunSecret.secretKey)) {
            logger.warn("secret is not changed, ignore OSS client rebuilding");
            return;
        }
        this.config.aliyunSecret.accessKey = DynamicSecret.accessKey;
        this.config.aliyunSecret.secretKey = DynamicSecret.secretKey;
        OSS prevInstance = this.instance;
        this.build();
        if (prevInstance != null) {
            prevInstance.shutdown();
        }
        logger.info("OSS client rebuild success");
    }

    private void build() {
        ClientBuilderConfiguration configuration = new ClientBuilderConfiguration();
        configuration.setConnectionTimeout(this.config.connectionTimeoutMs);
        configuration.setSocketTimeout(this.config.socketTimeoutMs);
        this.instance = new OSSClientBuilder().build(this.config.endpoint, this.config.aliyunSecret.accessKey, this.config.aliyunSecret.secretKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getObjectOnce(GetObjectRequest request) {
        InputStream inputStream = null;
        ByteArrayOutputStream outputStream = null;
        try {
            int size;
            OSSObject ossObject = this.instance.getObject(request);
            if (ossObject == null || ossObject.getObjectContent() == null) {
                logger.warn("oss object is not found for key[{}] and bucket[{}]", (Object)request.getKey(), (Object)request.getBucketName());
                byte[] byArray = null;
                return byArray;
            }
            byte[] buffer = new byte[4096];
            inputStream = ossObject.getObjectContent();
            outputStream = new ByteArrayOutputStream(4096);
            while ((size = inputStream.read(buffer, 0, 4096)) != -1) {
                outputStream.write(buffer, 0, size);
            }
            byte[] byArray = outputStream.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            byte[] byArray = null;
            return byArray;
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public InputStream getObjectStream(String bucket, String key) {
        GetObjectRequest request = new GetObjectRequest(bucket, key);
        try {
            OSSObject ossObject = this.instance.getObject(request);
            if (ossObject == null || ossObject.getObjectContent() == null) {
                logger.warn("oss object is not found for key[{}] and bucket[{}]", (Object)request.getKey(), (Object)request.getBucketName());
                return null;
            }
            return ossObject.getObjectContent();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public byte[] getObject(String bucket, String key) {
        GetObjectRequest request = new GetObjectRequest(bucket, key);
        for (int i = 0; i < this.config.retryCnt; ++i) {
            byte[] content = this.getObjectOnce(request);
            if (content != null) {
                return content;
            }
            logger.warn("get oss object failed for key[{}] and bucket[{}], retry {} times", new Object[]{key, bucket, i + 1});
        }
        logger.error("get oss object failed for key[{}] and bucket[{}]", (Object)key, (Object)bucket);
        return null;
    }

    public boolean putObject(String bucket, String key, byte[] content) {
        if (content == null || content.length == 0) {
            logger.warn("put content is empty for bucket[{}] and key[{}]", (Object)bucket, (Object)key);
            return false;
        }
        for (int i = 0; i < this.config.retryCnt; ++i) {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(content);
            if (!this.putObject(bucket, key, inputStream)) continue;
            return true;
        }
        logger.error("put object failed for bucket[{}] and key[{}]", (Object)bucket, (Object)key);
        return false;
    }

    public boolean putObject(String bucket, String key, InputStream inputStream) {
        if (inputStream == null) {
            logger.error("input stream is null");
            return false;
        }
        PutObjectResult result = this.instance.putObject(bucket, key, inputStream);
        if (result == null || StringUtils.isEmpty((CharSequence)result.getETag())) {
            logger.error("put object failed for bucket[{}] and key[{}]", (Object)bucket, (Object)key);
            return false;
        }
        return true;
    }

    public void deleteObject(String bucket, String key) {
        try {
            this.instance.deleteObject(bucket, key);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public ObjectMetadata getObjectMeta(String bucket, String key) {
        try {
            return this.instance.getObjectMetadata(bucket, key);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public List<String> list(String bucket, String directory) {
        try {
            ObjectListing objectListing;
            int count = 0;
            int maxKeys = 1000;
            int maxNum = 10000;
            String nextMarker = null;
            ArrayList<String> keys = new ArrayList<String>();
            do {
                objectListing = this.instance.listObjects(new ListObjectsRequest(bucket).withPrefix(directory).withMarker(nextMarker).withMaxKeys(Integer.valueOf(1000)));
                List summaryList = objectListing.getObjectSummaries();
                for (OSSObjectSummary summary : summaryList) {
                    if (summary.getKey().equals(directory)) continue;
                    keys.add(summary.getKey());
                    if (++count < 10000) continue;
                    break;
                }
                nextMarker = objectListing.getNextMarker();
            } while (objectListing.isTruncated());
            return keys;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public String sign(String bucket, String key) {
        return this.sign(bucket, key, 3600000L);
    }

    public String sign(String bucket, String key, long ttl) {
        long currentTime = new Date().getTime();
        Date expiredTime = ttl > 0L ? new Date(currentTime + ttl) : new Date(currentTime + 3600000L);
        URL url = this.instance.generatePresignedUrl(bucket, key, expiredTime);
        return url.toString();
    }

    public boolean exist(String bucket, String key) {
        return this.instance.doesObjectExist(bucket, key);
    }

    public static OSSMeta parseURL(String ossURL) {
        String key;
        String host = CommonUtil.getHost((String)ossURL);
        if (StringUtils.isEmpty((CharSequence)host)) {
            logger.error("parse host failed for url[{}]", (Object)ossURL);
            return null;
        }
        int from = host.indexOf(".");
        if (from == -1) {
            logger.error("parse bucket failed for url[{}]", (Object)ossURL);
            return null;
        }
        OSSMeta ossMeta = new OSSMeta();
        ossMeta.bucket = host.substring(0, from);
        int to = host.indexOf(".", from + 1);
        if (to == -1) {
            logger.error("parse region failed for url[{}]", (Object)ossURL);
            return null;
        }
        ossMeta.region = host.substring(from + 1, to);
        if (ossMeta.region.startsWith("oss-")) {
            ossMeta.region = ossMeta.region.substring("oss-".length());
        }
        if (StringUtils.isEmpty((CharSequence)(key = OSSClient.parseKey(ossURL)))) {
            logger.error("parse key failed for url[{}]", (Object)ossURL);
            return null;
        }
        ossMeta.key = key;
        return ossMeta;
    }

    public static String buildURL(OSSMeta ossMeta) {
        if (ossMeta == null || !ossMeta.check()) {
            logger.error("oss meta is null or invalid");
            return null;
        }
        return String.format(ossMeta.region.startsWith("oss-") ? "http://%s.%s.%s/%s" : "http://%s.oss-%s.%s/%s", ossMeta.bucket, ossMeta.region, ALIYUN_OSS_DOMAIN, ossMeta.key);
    }

    private static String parseKey(String ossURL) {
        String key;
        int from = -1;
        if (ossURL.startsWith(PREFIX_HTTP)) {
            from = PREFIX_HTTP.length();
        } else if (ossURL.startsWith(PREFIX_HTTPS)) {
            from = PREFIX_HTTPS.length();
        }
        if (from == -1) {
            logger.error("invalid protocol for url[{}]", (Object)ossURL);
            return null;
        }
        int index = ossURL.indexOf("/", from);
        String string = key = index == -1 ? "" : ossURL.substring(index + 1);
        if (key.indexOf("?") != -1) {
            key = key.substring(0, key.indexOf("?"));
        }
        try {
            key = URLDecoder.decode(key, "UTF-8");
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return key;
    }
}

