/*
 * Decompiled with CFR 0.152.
 */
package xin.manong.weapon.aliyun.ots;

import com.alicloud.openservices.tablestore.TunnelClient;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xin.manong.weapon.alarm.AlarmSender;
import xin.manong.weapon.aliyun.ots.OTSTunnelConfig;
import xin.manong.weapon.aliyun.ots.OTSTunnelMonitor;
import xin.manong.weapon.aliyun.ots.OTSTunnelWorker;
import xin.manong.weapon.aliyun.ots.OTSTunnelWorkerConfig;
import xin.manong.weapon.base.rebuild.RebuildListener;
import xin.manong.weapon.base.rebuild.RebuildManager;
import xin.manong.weapon.base.rebuild.Rebuildable;
import xin.manong.weapon.base.secret.DynamicSecret;

public class OTSTunnel
implements Rebuildable {
    private static final Logger logger = LoggerFactory.getLogger(OTSTunnel.class);
    protected String appName;
    protected OTSTunnelConfig config;
    protected OTSTunnelMonitor monitor;
    protected TunnelClient tunnelClient;
    protected Map<String, OTSTunnelWorker> workerMap;
    protected List<RebuildListener> rebuildListeners;
    protected AlarmSender alarmSender;

    public OTSTunnel(OTSTunnelConfig config) {
        this.config = config;
        this.workerMap = new ConcurrentHashMap<String, OTSTunnelWorker>();
        this.rebuildListeners = new ArrayList<RebuildListener>();
    }

    private boolean build() {
        this.tunnelClient = new TunnelClient(this.config.endpoint, this.config.aliyunSecret.accessKey, this.config.aliyunSecret.secretKey, this.config.instance);
        this.workerMap.clear();
        for (OTSTunnelWorkerConfig workerConfig : this.config.workerConfigs) {
            OTSTunnelWorker worker = new OTSTunnelWorker(workerConfig, this.tunnelClient);
            if (!worker.start()) {
                return false;
            }
            String key = DigestUtils.md5Hex((String)String.format("%s_%s", workerConfig.table, workerConfig.tunnel));
            this.workerMap.put(key, worker);
        }
        this.monitor = new OTSTunnelMonitor(this.config, this.tunnelClient);
        this.monitor.setAppName(this.appName);
        this.monitor.setAlarmSender(this.alarmSender);
        this.monitor.start();
        return true;
    }

    public void rebuild() {
        logger.info("OTS tunnel is rebuilding ...");
        if (DynamicSecret.accessKey.equals(this.config.aliyunSecret.accessKey) && DynamicSecret.secretKey.equals(this.config.aliyunSecret.secretKey)) {
            logger.warn("secret is not changed, ignore OTS tunnel rebuilding");
            return;
        }
        this.config.aliyunSecret.accessKey = DynamicSecret.accessKey;
        this.config.aliyunSecret.secretKey = DynamicSecret.secretKey;
        OTSTunnelMonitor prevMonitor = this.monitor;
        TunnelClient prevClient = this.tunnelClient;
        if (prevMonitor != null) {
            prevMonitor.stop();
        }
        for (OTSTunnelWorker worker : this.workerMap.values()) {
            worker.stop();
        }
        this.workerMap.clear();
        if (prevClient != null) {
            prevClient.shutdown();
        }
        for (RebuildListener rebuildListener : this.rebuildListeners) {
            rebuildListener.notifyRebuildEvent((Rebuildable)this);
        }
        if (!this.build()) {
            throw new RuntimeException("rebuild OTS tunnel failed");
        }
        logger.info("OTS tunnel rebuild success");
    }

    public boolean start() {
        logger.info("OTS tunnel is starting ...");
        if (this.config == null) {
            logger.error("OTS tunnel config is null");
            return false;
        }
        if (!this.config.check()) {
            return false;
        }
        if (!this.build()) {
            return false;
        }
        if (this.config.dynamic) {
            RebuildManager.register((Rebuildable)this);
        }
        logger.info("OTS tunnel has been started");
        return true;
    }

    public void stop() {
        logger.info("OTS tunnel is stopping ...");
        if (this.config.dynamic) {
            RebuildManager.unregister((Rebuildable)this);
        }
        if (this.monitor != null) {
            this.monitor.stop();
        }
        for (OTSTunnelWorker worker : this.workerMap.values()) {
            worker.stop();
        }
        this.workerMap.clear();
        if (this.tunnelClient != null) {
            this.tunnelClient.shutdown();
        }
        logger.info("OTS tunnel has been stopped");
    }

    public void addRebuildListener(RebuildListener listener) {
        if (listener == null) {
            return;
        }
        this.rebuildListeners.add(listener);
    }

    public boolean startTunnelWorker(OTSTunnelWorkerConfig workerConfig) {
        if (workerConfig == null || !workerConfig.check()) {
            logger.error("invalid OTS tunnel worker config");
            return false;
        }
        String key = DigestUtils.md5Hex((String)String.format("%s_%s", workerConfig.table, workerConfig.tunnel));
        if (this.workerMap.containsKey(key)) {
            logger.warn("tunnel worker[{}/{}] has existed", (Object)workerConfig.table, (Object)workerConfig.tunnel);
            return false;
        }
        if (!this.config.addTunnelWorkerConfig(workerConfig)) {
            return false;
        }
        OTSTunnelWorker worker = new OTSTunnelWorker(workerConfig, this.tunnelClient);
        if (!worker.start()) {
            this.config.removeTunnelWorkerConfig(workerConfig);
            return false;
        }
        this.workerMap.put(key, worker);
        return true;
    }

    public void stopTunnelWorker(OTSTunnelWorkerConfig workerConfig) {
        if (workerConfig == null) {
            return;
        }
        if (StringUtils.isEmpty((CharSequence)workerConfig.table)) {
            logger.warn("table is null, ignore remove request");
            return;
        }
        if (StringUtils.isEmpty((CharSequence)workerConfig.tunnel)) {
            logger.warn("tunnel is null, ignore remove request");
            return;
        }
        String key = DigestUtils.md5Hex((String)String.format("%s_%s", workerConfig.table, workerConfig.tunnel));
        OTSTunnelWorker worker = this.workerMap.remove(key);
        if (worker == null) {
            logger.warn("tunnel worker[{}/{}] is not found", (Object)workerConfig.table, (Object)workerConfig.tunnel);
            return;
        }
        worker.stop();
        this.config.removeTunnelWorkerConfig(workerConfig);
    }

    public void setAlarmSender(AlarmSender alarmSender) {
        this.alarmSender = alarmSender;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }
}

