/*
 * Decompiled with CFR 0.152.
 */
package xyz.redrain.helper;

import xyz.redrain.exception.InsertValuesNoExistException;
import xyz.redrain.exception.ParamIsNullException;
import xyz.redrain.parse.ObjectEntity;
import xyz.redrain.parse.ObjectParse;
import xyz.redrain.parse.ParseUtil;

public class InsertHelper {
    public String insertObj(Object param) throws Exception {
        return this.getInsertSql(param, false);
    }

    public String insertObjSelective(Object param) throws Exception {
        return this.getInsertSql(param, true);
    }

    public String getInsertSql(Object param, boolean isSelective) throws Exception {
        if (null == param) {
            throw new ParamIsNullException();
        }
        ObjectEntity objectEntity = ObjectParse.getObjectEntity(param);
        if (isSelective) {
            ObjectParse.delNullProperty(objectEntity);
        }
        if (objectEntity.getPropertyEntities().isEmpty()) {
            throw new InsertValuesNoExistException();
        }
        return String.format("INSERT INTO %s ( %s ) VALUES ( %s )", ParseUtil.addBackQuote(objectEntity.getTableName()), ParseUtil.getJdbcParams(objectEntity), ParseUtil.getSqlParams(objectEntity));
    }
}

