/*
 * Decompiled with CFR 0.152.
 */
package xyz.redrain.parse;

import java.util.function.Supplier;
import java.util.stream.Collectors;
import xyz.redrain.parse.ObjectEntity;
import xyz.redrain.parse.PropertyEntity;

public class ParseUtil {
    public static String underlineStitching(String target) {
        if (null == target || "".equals(target.trim())) {
            return null;
        }
        char[] chars = target.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] < 'A' || chars[i] > 'Z') continue;
            target = target.replace(String.valueOf(chars[i]), "_" + String.valueOf(chars[i]).toLowerCase());
            if (i != 0) continue;
            target = target.substring(1);
        }
        return target;
    }

    public static String toUpperCase(String target) {
        if (null == target || "".equals(target.trim())) {
            return null;
        }
        char[] chars = target.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] != '_' || i >= chars.length - 1) continue;
            target = target.replace("_" + chars[i + 1], String.valueOf(chars[i + 1]).toUpperCase());
            if (i != chars.length - 1) continue;
            target = target.substring(0, target.length() - 1);
        }
        return target;
    }

    public static String getProperty(String value, String defaultValue) {
        if (null == value || "".equals(value.trim())) {
            return defaultValue;
        }
        return value;
    }

    public static String getProperty(String value, Supplier<String> supplier) {
        if (null == value || "".equals(value.trim())) {
            return supplier.get();
        }
        return value;
    }

    public static String getSqlParams(ObjectEntity objectEntity) {
        return objectEntity.getPropertyEntities().stream().map(propertyEntity -> String.format("#{ %s , %s }", propertyEntity.getPropertyName(), ParseUtil.getPropertyTypeStr(propertyEntity))).collect(Collectors.joining(" , "));
    }

    public static String getJdbcParams(ObjectEntity objectEntity) {
        return objectEntity.getPropertyEntities().stream().map(propertyEntity -> ParseUtil.addBackQuote(propertyEntity.getColumnName())).collect(Collectors.joining(" , "));
    }

    public static String getJdbcParamsAndAlias(ObjectEntity objectEntity) {
        return objectEntity.getPropertyEntities().stream().map(propertyEntity -> String.format("%s AS '%s'", ParseUtil.addBackQuote(propertyEntity.getColumnName()), propertyEntity.getPropertyName())).collect(Collectors.joining(" , "));
    }

    public static String getEqualParams(PropertyEntity propertyEntity, String paramPrefix) {
        paramPrefix = paramPrefix != null && !"".equals(paramPrefix.trim()) ? paramPrefix + "." : "";
        return String.format(" %s = #{%s,%s} ", ParseUtil.addBackQuote(propertyEntity.getColumnName()), paramPrefix + propertyEntity.getPropertyName(), ParseUtil.getPropertyTypeStr(propertyEntity));
    }

    public static String getEqualParams(PropertyEntity propertyEntity) {
        return ParseUtil.getEqualParams(propertyEntity, null);
    }

    private static String getPropertyTypeStr(PropertyEntity propertyEntity) {
        return propertyEntity.getJdbcType() != null ? "jdbcType = " + propertyEntity.getJdbcType().toUpperCase() : "javaType = " + propertyEntity.getJavaType();
    }

    public static String addBackQuote(String s) {
        if (s == null || "".equals(s.trim())) {
            return s;
        }
        return String.format("`%s`", s);
    }

    public static String removeBackQuote(String s) {
        return s == null ? null : s.replaceAll("`", "");
    }
}

