/*
 * Decompiled with CFR 0.152.
 */
package xyz.ressor.source.http;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.apache.http.Header;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicHeader;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.ressor.commons.utils.Exceptions;
import xyz.ressor.commons.utils.RessorUtils;
import xyz.ressor.source.AbstractSource;
import xyz.ressor.source.LoadedResource;
import xyz.ressor.source.NonListenableSource;
import xyz.ressor.source.ResourceId;
import xyz.ressor.source.SourceVersion;
import xyz.ressor.source.http.CacheControlStrategy;
import xyz.ressor.source.http.HttpResourceId;
import xyz.ressor.source.http.version.ETag;
import xyz.ressor.source.version.LastModified;

public class HttpSource
extends AbstractSource<HttpResourceId>
implements NonListenableSource<HttpResourceId> {
    private static final Logger log = LoggerFactory.getLogger(HttpSource.class);
    private static final ZoneId GMT = ZoneId.of("GMT");
    protected final CloseableHttpClient client;
    protected final Consumer<HttpRequestBase> requestInterceptor;
    protected final boolean keepAlive;

    public HttpSource(CloseableHttpClient client) {
        this(client, r -> {}, true);
    }

    public HttpSource(CloseableHttpClient client, @NotNull Consumer<HttpRequestBase> requestInterceptor, boolean keepAlive) {
        this.client = client;
        this.requestInterceptor = requestInterceptor;
        this.keepAlive = keepAlive;
    }

    public LoadedResource loadIfModified(HttpResourceId resourceId, SourceVersion version) {
        CacheControlStrategy cacheControl = resourceId.getCacheControl();
        if (version == SourceVersion.EMPTY || cacheControl == CacheControlStrategy.NONE) {
            return this.loadResource(resourceId);
        }
        if (cacheControl == CacheControlStrategy.ETAG) {
            return this.loadResource(resourceId, Collections.singletonList(new BasicHeader("If-None-Match", version.val().toString())));
        }
        if (cacheControl == CacheControlStrategy.IF_MODIFIED_SINCE) {
            return this.loadResource(resourceId, Collections.singletonList(new BasicHeader("If-Modified-Since", this.lastModifiedValue((Long)version.val()))));
        }
        if ((cacheControl == CacheControlStrategy.LAST_MODIFIED_HEAD || cacheControl == CacheControlStrategy.ETAG_HEAD) && this.isChanged(resourceId, version)) {
            return this.loadResource(resourceId);
        }
        return null;
    }

    public String describe() {
        return "Http";
    }

    protected boolean isChanged(HttpResourceId resourceId, SourceVersion version) {
        try {
            HttpHead head = new HttpHead(resourceId.getResourceURI());
            this.intercept((HttpRequestBase)head);
            CloseableHttpResponse response = this.client.execute((HttpUriRequest)head);
            if (resourceId.getCacheControl() == CacheControlStrategy.ETAG_HEAD) {
                String eTag = this.getHeader(response, "ETag");
                return eTag == null || !eTag.equals(version.val());
            }
            if (resourceId.getCacheControl() == CacheControlStrategy.LAST_MODIFIED_HEAD) {
                Instant lastModified = this.getLastModified(response);
                return lastModified == null || lastModified.isAfter(Instant.ofEpochMilli((Long)version.val()));
            }
            return true;
        }
        catch (Throwable t) {
            throw Exceptions.wrap((Throwable)t);
        }
    }

    protected LoadedResource loadResource(HttpResourceId resourceId) {
        return this.loadResource(resourceId, Collections.emptyList());
    }

    protected LoadedResource loadResource(HttpResourceId resourceId, List<Header> headers) {
        try {
            String resourceURI = resourceId.getResourceURI();
            CacheControlStrategy cacheControl = resourceId.getCacheControl();
            HttpGet get = new HttpGet(resourceURI);
            headers.forEach(arg_0 -> ((HttpGet)get).addHeader(arg_0));
            this.intercept((HttpRequestBase)get);
            CloseableHttpResponse response = this.client.execute((HttpUriRequest)get);
            if (response.getStatusLine() != null) {
                int statusCode = response.getStatusLine().getStatusCode();
                if (statusCode == 200) {
                    SourceVersion version = SourceVersion.EMPTY;
                    if (cacheControl == CacheControlStrategy.ETAG || cacheControl == CacheControlStrategy.ETAG_HEAD) {
                        String eTag = this.getHeader(response, "ETag");
                        if (eTag != null) {
                            version = new ETag(eTag);
                        } else {
                            log.debug("Not recognized a ETag header from the response");
                        }
                    } else if (cacheControl == CacheControlStrategy.IF_MODIFIED_SINCE || cacheControl == CacheControlStrategy.LAST_MODIFIED_HEAD) {
                        Instant lastModified = this.getLastModified(response);
                        if (lastModified != null) {
                            version = new LastModified(lastModified.toEpochMilli());
                        } else {
                            log.debug("Not recognized a Last-Modified header from the response");
                        }
                    }
                    return new LoadedResource(response.getEntity() != null ? response.getEntity().getContent() : RessorUtils.emptyInputStream(), version, (ResourceId)resourceId);
                }
                log.debug("Received {} status code for GET {}", (Object)statusCode, (Object)resourceURI);
            } else {
                log.debug("No status line received for GET {}", (Object)resourceURI);
            }
            return null;
        }
        catch (Throwable t) {
            throw Exceptions.wrap((Throwable)t);
        }
    }

    protected String getHeader(CloseableHttpResponse httpResult, String name) {
        Header header = httpResult.getFirstHeader(name);
        if (header != null && header.getValue().length() > 0) {
            return header.getValue();
        }
        return null;
    }

    protected Instant getLastModified(CloseableHttpResponse httpResult) {
        TemporalAccessor ta = null;
        Header header = httpResult.getFirstHeader("Last-Modified");
        if (header != null && header.getValue().length() > 0) {
            try {
                ta = DateTimeFormatter.RFC_1123_DATE_TIME.parse(header.getValue());
            }
            catch (Throwable t) {
                log.debug(t.getMessage(), t);
            }
        }
        return ta == null ? null : Instant.from(ta);
    }

    protected void intercept(HttpRequestBase req) {
        this.requestInterceptor.accept(req);
        if (this.keepAlive) {
            req.addHeader("Connection", "keep-alive");
        }
    }

    protected String lastModifiedValue(long timestamp) {
        return DateTimeFormatter.RFC_1123_DATE_TIME.format(this.toDateTime(timestamp));
    }

    private ZonedDateTime toDateTime(long timestamp) {
        return ZonedDateTime.of(LocalDateTime.ofInstant(Instant.ofEpochMilli(timestamp), ZoneOffset.UTC), GMT);
    }
}

