/*
 * Decompiled with CFR 0.152.
 */
package xyz.ressor.source.http;

import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultClientConnectionReuseStrategy;
import org.apache.http.impl.client.DefaultConnectionKeepAliveStrategy;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.client.LaxRedirectStrategy;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import xyz.ressor.source.http.HttpSource;

public class HttpSourceBuilder {
    private CloseableHttpClient client;
    private Integer socketTimeoutMs;
    private Integer connectTimeoutMs;
    private boolean alwaysFollowRedirects = true;
    private Integer receiveBufferSize;
    private Integer maxTotalConnections;
    private Integer inactiveTtlMs;
    private boolean keepAlive = true;
    private boolean contentCompression = false;
    private Consumer<HttpRequestBase> requestInterceptor = r -> {};

    public HttpSourceBuilder httpClient(CloseableHttpClient client) {
        this.client = client;
        return this;
    }

    public HttpSourceBuilder socketTimeoutMs(int socketTimeoutMs) {
        this.socketTimeoutMs = socketTimeoutMs;
        return this;
    }

    public HttpSourceBuilder connectTimeoutMs(int connectTimeoutMs) {
        this.connectTimeoutMs = connectTimeoutMs;
        return this;
    }

    public HttpSourceBuilder alwaysFollowRedirects(boolean alwaysFollowRedirects) {
        this.alwaysFollowRedirects = alwaysFollowRedirects;
        return this;
    }

    public HttpSourceBuilder keepAlive(boolean keepAlive) {
        this.keepAlive = keepAlive;
        return this;
    }

    public HttpSourceBuilder receiveBufferSize(int receiveBufferSize) {
        this.receiveBufferSize = receiveBufferSize;
        return this;
    }

    public HttpSourceBuilder pool(int maxTotalConnections, int inactiveTtlMs) {
        this.maxTotalConnections = maxTotalConnections;
        this.inactiveTtlMs = inactiveTtlMs;
        return this;
    }

    public HttpSourceBuilder contentCompression(boolean contentCompression) {
        this.contentCompression = contentCompression;
        return this;
    }

    public HttpSourceBuilder requestInterceptor(Consumer<HttpRequestBase> requestInterceptor) {
        this.requestInterceptor = requestInterceptor;
        return this;
    }

    public HttpSource build() {
        if (this.client == null) {
            HttpClientBuilder client = HttpClients.custom();
            SocketConfig.Builder socketConfig = SocketConfig.custom();
            if (this.receiveBufferSize != null) {
                socketConfig.setRcvBufSize(this.receiveBufferSize.intValue());
            }
            if (this.socketTimeoutMs != null) {
                socketConfig.setSoTimeout(this.socketTimeoutMs.intValue());
            }
            client.setDefaultSocketConfig(socketConfig.setSoKeepAlive(this.keepAlive).build());
            if (this.connectTimeoutMs != null) {
                client.setDefaultRequestConfig(RequestConfig.custom().setConnectTimeout(this.connectTimeoutMs.intValue()).setConnectionRequestTimeout(this.connectTimeoutMs.intValue()).setContentCompressionEnabled(this.contentCompression).build());
            } else {
                client.setDefaultRequestConfig(RequestConfig.custom().setContentCompressionEnabled(this.contentCompression).build());
            }
            if (this.alwaysFollowRedirects) {
                client.setRedirectStrategy((RedirectStrategy)LaxRedirectStrategy.INSTANCE);
            } else {
                client.disableRedirectHandling();
            }
            if (this.keepAlive) {
                client.setKeepAliveStrategy((ConnectionKeepAliveStrategy)DefaultConnectionKeepAliveStrategy.INSTANCE).setConnectionReuseStrategy((ConnectionReuseStrategy)DefaultClientConnectionReuseStrategy.INSTANCE);
            }
            if (this.maxTotalConnections != null) {
                PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager((long)this.inactiveTtlMs.intValue(), TimeUnit.MILLISECONDS);
                cm.setMaxTotal(this.maxTotalConnections.intValue());
                client.setConnectionManager((HttpClientConnectionManager)cm);
            }
            this.client = client.build();
        }
        return new HttpSource(this.client, this.requestInterceptor, this.keepAlive);
    }
}

